/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public class MediaType
implements Comparable<MediaType> {
    private static final boolean nocache = Boolean.getBoolean("juneau.nocache");
    private static final ConcurrentHashMap<String, MediaType> cache = new ConcurrentHashMap();
    public static final MediaType CSV = MediaType.forString("text/csv");
    public static final MediaType HTML = MediaType.forString("text/html");
    public static final MediaType JSON = MediaType.forString("application/json");
    public static final MediaType MSGPACK = MediaType.forString("octal/msgpack");
    public static final MediaType PLAIN = MediaType.forString("text/plain");
    public static final MediaType UON = MediaType.forString("text/uon");
    public static final MediaType URLENCODING = MediaType.forString("application/x-www-form-urlencoded");
    public static final MediaType XML = MediaType.forString("text/xml");
    public static final MediaType XMLSOAP = MediaType.forString("text/xml+soap");
    public static final MediaType RDF = MediaType.forString("text/xml+rdf");
    public static final MediaType RDFABBREV = MediaType.forString("text/xml+rdf+abbrev");
    public static final MediaType NTRIPLE = MediaType.forString("text/n-triple");
    public static final MediaType TURTLE = MediaType.forString("text/turtle");
    public static final MediaType N3 = MediaType.forString("text/n3");
    private final String mediaType;
    private final String type;
    private final String subType;
    private final String[] subTypes;
    private final String[] subTypesSorted;
    private final List<String> subTypesList;
    private final Map<String, Set<String>> parameters;
    private final boolean hasSubtypeMeta;

    public static MediaType forString(String s) {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        MediaType mt = cache.get(s);
        if (mt == null) {
            mt = new MediaType(s);
            if (nocache) {
                return mt;
            }
            cache.putIfAbsent(s, mt);
        }
        return cache.get(s);
    }

    public static MediaType[] forStrings(String ... s) {
        MediaType[] mt = new MediaType[s.length];
        for (int i = 0; i < s.length; ++i) {
            mt[i] = MediaType.forString(s[i]);
        }
        return mt;
    }

    MediaType(String mt) {
        Builder b = new Builder(mt);
        this.mediaType = b.mediaType;
        this.type = b.type;
        this.subType = b.subType;
        this.subTypes = b.subTypes;
        this.subTypesSorted = b.subTypesSorted;
        this.subTypesList = Collections.unmodifiableList(Arrays.asList(this.subTypes));
        this.parameters = b.parameters == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(b.parameters);
        this.hasSubtypeMeta = b.hasSubtypeMeta;
    }

    public final String getType() {
        return this.type;
    }

    public final String getSubType() {
        return this.subType;
    }

    public final boolean hasSubType(String st) {
        if (st != null) {
            for (String s : this.subTypes) {
                if (!st.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public final List<String> getSubTypes() {
        return this.subTypesList;
    }

    public final boolean isMeta() {
        return this.hasSubtypeMeta;
    }

    public final int match(MediaType o, boolean allowExtraSubTypes) {
        if (this == o || this.type.equals(o.type) && this.subType.equals(o.subType)) {
            return 100000;
        }
        int c = 0;
        if (this.type.equals(o.type)) {
            c += 10000;
        } else if ("*".equals(this.type) || "*".equals(o.type)) {
            c += 5000;
        }
        if (c == 0) {
            return 0;
        }
        if (ArrayUtils.equals(this.subTypesSorted, o.subTypesSorted)) {
            return c + 7500;
        }
        for (String st1 : this.subTypes) {
            if ("*".equals(st1)) {
                c += 0;
                continue;
            }
            if (ArrayUtils.contains(st1, o.subTypes)) {
                c += 100;
                continue;
            }
            if (o.hasSubtypeMeta) {
                c += 10;
                continue;
            }
            return 0;
        }
        for (String st2 : o.subTypes) {
            if ("*".equals(st2)) {
                c += 0;
                continue;
            }
            if (ArrayUtils.contains(st2, this.subTypes)) {
                c += 100;
                continue;
            }
            if (this.hasSubtypeMeta) {
                c += 10;
                continue;
            }
            if (!allowExtraSubTypes) {
                return 0;
            }
            c += 10;
        }
        return c;
    }

    public final Map<String, Set<String>> getParameters() {
        return this.parameters;
    }

    public final String toString() {
        if (this.parameters.isEmpty()) {
            return this.mediaType;
        }
        StringBuilder sb = new StringBuilder(this.mediaType);
        for (Map.Entry<String, Set<String>> e : this.parameters.entrySet()) {
            for (String value : e.getValue()) {
                sb.append(';').append(e.getKey()).append('=').append(value);
            }
        }
        return sb.toString();
    }

    public final int hashCode() {
        return this.mediaType.hashCode();
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    @Override
    public final int compareTo(MediaType o) {
        return this.mediaType.compareTo(o.mediaType);
    }

    private static class Builder {
        private String mediaType;
        private String type;
        private String subType;
        private String[] subTypes;
        private String[] subTypesSorted;
        private Map<String, Set<String>> parameters;
        private boolean hasSubtypeMeta;

        private Builder(String mt) {
            mt = mt.trim();
            int i = mt.indexOf(59);
            if (i == -1) {
                this.parameters = Collections.EMPTY_MAP;
            } else {
                this.parameters = new TreeMap<String, Set<String>>();
                String[] tokens = mt.substring(i + 1).split(";");
                for (int j = 0; j < tokens.length; ++j) {
                    String[] parm = tokens[j].split("=");
                    if (parm.length != 2) continue;
                    String k = parm[0].trim();
                    String v = parm[1].trim();
                    if (!this.parameters.containsKey(k)) {
                        this.parameters.put(k, new TreeSet());
                    }
                    this.parameters.get(k).add(v);
                }
                mt = mt.substring(0, i);
            }
            this.mediaType = mt;
            if (mt != null) {
                i = (mt = mt.replace(' ', '+')).indexOf(47);
                this.type = i == -1 ? mt : mt.substring(0, i);
                this.subType = i == -1 ? "*" : mt.substring(i + 1);
            }
            this.subTypes = StringUtils.split(this.subType, '+');
            this.subTypesSorted = Arrays.copyOf(this.subTypes, this.subTypes.length);
            Arrays.sort(this.subTypesSorted);
            this.hasSubtypeMeta = ArrayUtils.contains("*", this.subTypes);
        }
    }
}

