/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.juneau.http.StringRange;
import org.apache.juneau.internal.StringUtils;

public class HeaderRangeArray {
    final StringRange[] typeRanges;
    private final List<StringRange> typeRangesList;

    protected HeaderRangeArray(String value) {
        this.typeRanges = StringRange.parse(value);
        this.typeRangesList = Collections.unmodifiableList(Arrays.asList(this.typeRanges));
    }

    public int findMatch(String[] types) {
        for (StringRange mr : this.typeRanges) {
            for (int i = 0; i < types.length; ++i) {
                if (!mr.matches(types[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public List<StringRange> asSimpleRanges() {
        return this.typeRangesList;
    }

    public String toString() {
        return StringUtils.join((Object[])this.typeRanges, ',');
    }
}

