/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlDocTemplateBasic;
import org.apache.juneau.html.HtmlSerializerContext;

public final class HtmlDocSerializerContext
extends HtmlSerializerContext {
    public static final String HTMLDOC_header = "HtmlDocSerializer.header";
    public static final String HTMLDOC_links = "HtmlDocSerializer.links.list";
    public static final String HTMLDOC_links_add = "HtmlDocSerializer.links.list.add";
    public static final String HTMLDOC_nav = "HtmlDocSerializer.nav";
    public static final String HTMLDOC_aside = "HtmlDocSerializer.aside";
    public static final String HTMLDOC_footer = "HtmlDocSerializer.footer";
    public static final String HTMLDOC_noResultsMessage = "HtmlDocSerializer.noResultsMessage";
    public static final String HTMLDOC_nowrap = "HtmlDocSerializer.nowrap";
    public static final String HTMLDOC_stylesheet = "HtmlDocSerializer.stylesheet";
    public static final String HTMLDOC_stylesheet_add = "HtmlDocSerializer.stylesheet.list.add";
    public static final String HTMLDOC_style = "HtmlDocSerializer.style.list";
    public static final String HTMLDOC_style_add = "HtmlDocSerializer.style.list.add";
    public static final String HTMLDOC_script = "HtmlDocSerializer.script.list";
    public static final String HTMLDOC_script_add = "HtmlDocSerializer.script.list.add";
    public static final String HTMLDOC_template = "HtmlDocSerializer.template";
    final String[] style;
    final String[] stylesheet;
    final String[] script;
    final String[] links;
    final String header;
    final String nav;
    final String aside;
    final String footer;
    final String noResultsMessage;
    final boolean nowrap;
    final HtmlDocTemplate template;

    public HtmlDocSerializerContext(PropertyStore ps) {
        super(ps);
        this.style = ps.getProperty(HTMLDOC_style, String[].class, new String[0]);
        this.stylesheet = ps.getProperty(HTMLDOC_stylesheet, String[].class, new String[0]);
        this.script = ps.getProperty(HTMLDOC_script, String[].class, new String[0]);
        this.header = ps.getProperty(HTMLDOC_header, String.class, null);
        this.nav = ps.getProperty(HTMLDOC_nav, String.class, null);
        this.aside = ps.getProperty(HTMLDOC_aside, String.class, null);
        this.footer = ps.getProperty(HTMLDOC_footer, String.class, null);
        this.nowrap = ps.getProperty(HTMLDOC_nowrap, Boolean.TYPE, false);
        this.links = ps.getProperty(HTMLDOC_links, String[].class, new String[0]);
        this.noResultsMessage = ps.getProperty(HTMLDOC_noResultsMessage, String.class, "<p>no results</p>");
        this.template = ps.getTypedProperty(HTMLDOC_template, HtmlDocTemplate.class, HtmlDocTemplateBasic.class, new Object[0]);
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("HtmlDocSerializerContext", new ObjectMap().append("header", this.header).append("nav", this.nav).append("links", this.links).append("aside", this.aside).append("footer", this.footer).append("style", this.style).append("stylesheet", this.stylesheet).append("nowrap", this.nowrap).append("template", this.template).append("noResultsMessage", this.noResultsMessage));
    }
}

