/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto;

import org.apache.juneau.PartType;
import org.apache.juneau.html.HtmlLink;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

@HtmlLink(nameProperty="name", hrefProperty="href")
public class Link
implements Comparable<Link> {
    private String name;
    private String href;

    public Link() {
    }

    public Link(String name, String href, Object ... hrefArgs) {
        this.setName(name);
        this.setHref(href, hrefArgs);
    }

    public String getName() {
        return this.name;
    }

    public Link setName(String name) {
        this.name = name;
        return this;
    }

    public String getHref() {
        return this.href;
    }

    public Link setHref(String href) {
        this.setHref(href, new Object[0]);
        return this;
    }

    public Link setHref(String href, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = UrlEncodingSerializer.DEFAULT.serialize(PartType.PATH, args[i]);
        }
        this.href = StringUtils.format((String)href, (Object[])args);
        return this;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Link o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Link)) {
            return false;
        }
        return this.compareTo((Link)o) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

