/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Type;
import java.util.TreeMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PartType;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.urlencoding.UrlEncodingParser;

public class RequestPathMatch
extends TreeMap<String, String> {
    private static final long serialVersionUID = 1L;
    private UrlEncodingParser parser;
    private BeanSession beanSession;
    private String remainder;

    RequestPathMatch() {
        super(String.CASE_INSENSITIVE_ORDER);
    }

    RequestPathMatch setParser(UrlEncodingParser parser) {
        this.parser = parser;
        return this;
    }

    RequestPathMatch setBeanSession(BeanSession beanSession) {
        this.beanSession = beanSession;
        return this;
    }

    RequestPathMatch setRemainder(String remainder) {
        this.remainder = remainder;
        return this;
    }

    @Override
    public void put(String name, Object value) {
        this.put(name, value);
    }

    public <T> T get(String name, Class<T> type) throws ParseException {
        return this.parse(name, this.beanSession.getClassMeta(type));
    }

    public <T> T get(String name, Type type, Type ... args) throws ParseException {
        return this.parse(name, this.beanSession.getClassMeta(type, args));
    }

    <T> T parse(String name, ClassMeta<T> cm) throws ParseException {
        Object attr = this.get(name);
        Object t = null;
        if (attr != null) {
            t = this.parser.parse(PartType.PATH, attr.toString(), cm);
        }
        if (t == null && cm.isPrimitive()) {
            return (T)cm.getPrimitiveDefault();
        }
        return (T)t;
    }

    public String getRemainder() {
        return StringUtils.urlDecode((String)this.remainder);
    }

    public String getRemainderUndecoded() {
        return this.remainder;
    }
}

