/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.PartType;
import org.apache.juneau.http.Accept;
import org.apache.juneau.http.AcceptCharset;
import org.apache.juneau.http.AcceptEncoding;
import org.apache.juneau.http.AcceptLanguage;
import org.apache.juneau.http.Authorization;
import org.apache.juneau.http.CacheControl;
import org.apache.juneau.http.Connection;
import org.apache.juneau.http.ContentLength;
import org.apache.juneau.http.ContentType;
import org.apache.juneau.http.Date;
import org.apache.juneau.http.Expect;
import org.apache.juneau.http.From;
import org.apache.juneau.http.Host;
import org.apache.juneau.http.IfMatch;
import org.apache.juneau.http.IfModifiedSince;
import org.apache.juneau.http.IfNoneMatch;
import org.apache.juneau.http.IfRange;
import org.apache.juneau.http.IfUnmodifiedSince;
import org.apache.juneau.http.MaxForwards;
import org.apache.juneau.http.Pragma;
import org.apache.juneau.http.ProxyAuthorization;
import org.apache.juneau.http.Range;
import org.apache.juneau.http.Referer;
import org.apache.juneau.http.TE;
import org.apache.juneau.http.Upgrade;
import org.apache.juneau.http.UserAgent;
import org.apache.juneau.http.Via;
import org.apache.juneau.http.Warning;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.RequestQuery;
import org.apache.juneau.urlencoding.UrlEncodingParser;

public class RequestHeaders
extends TreeMap<String, String[]> {
    private static final long serialVersionUID = 1L;
    private UrlEncodingParser parser;
    private BeanSession beanSession;
    private RequestQuery queryParams;

    RequestHeaders() {
        super(String.CASE_INSENSITIVE_ORDER);
    }

    RequestHeaders setParser(UrlEncodingParser parser) {
        this.parser = parser;
        return this;
    }

    RequestHeaders setBeanSession(BeanSession beanSession) {
        this.beanSession = beanSession;
        return this;
    }

    RequestHeaders setQueryParams(RequestQuery queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public RequestHeaders addDefault(Map<String, String> defaultEntries) {
        if (defaultEntries != null) {
            for (Map.Entry<String, String> e : defaultEntries.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                String[] v = (String[])this.get(key);
                if (v != null && v.length != 0 && !StringUtils.isEmpty((String)v[0])) continue;
                this.put(key, new String[]{value});
            }
        }
        return this;
    }

    @Override
    public RequestHeaders put(String name, Enumeration<String> values) {
        if (values.hasMoreElements()) {
            String v = values.nextElement();
            Object[] s = new String[]{v};
            while (values.hasMoreElements()) {
                s = (String[])ArrayUtils.append((Object[])s, (Object[])new String[]{values.nextElement()});
            }
            this.put(name, s);
        }
        return this;
    }

    public String getString(String name) {
        String[] v = null;
        if (this.queryParams != null) {
            v = (String[])this.queryParams.get(name);
        }
        if (v == null || v.length == 0) {
            v = (String[])this.get(name);
        }
        if (v == null || v.length == 0) {
            return null;
        }
        return v[0];
    }

    public String getString(String name, String def) {
        String s = this.getString(name);
        return StringUtils.isEmpty((String)s) ? def : s;
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int def) {
        String s = this.getString(name);
        return StringUtils.isEmpty((String)s) ? def : Integer.parseInt(s);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean def) {
        String s = this.getString(name);
        return StringUtils.isEmpty((String)s) ? def : Boolean.parseBoolean(s);
    }

    @Override
    public void put(String name, Object value) {
        super.put(name, new String[]{StringUtils.toString((Object)value)});
    }

    public <T> T get(String name, Class<T> type) {
        String h = this.getString(name);
        return (T)this.beanSession.convertToType((Object)h, type);
    }

    public <T> T get(String name, T def, Class<T> type) {
        String h = this.getString(name);
        if (h == null) {
            return def;
        }
        return (T)this.beanSession.convertToType((Object)h, type);
    }

    public <T> T get(String name, Type type, Type ... args) throws ParseException {
        String h = this.getString(name);
        return (T)this.parser.parse(PartType.HEADER, h, this.beanSession.getClassMeta(type, args));
    }

    public RequestHeaders subset(String ... headers) {
        RequestHeaders rh2 = new RequestHeaders().setParser(this.parser).setBeanSession(this.beanSession).setQueryParams(this.queryParams);
        for (String h : headers) {
            if (!this.containsKey(h)) continue;
            rh2.put(h, this.get(h));
        }
        return rh2;
    }

    public RequestHeaders subset(String headers) {
        return this.subset(StringUtils.split((String)headers));
    }

    public Accept getAccept() {
        return Accept.forString((String)this.getString("Accept"));
    }

    public AcceptCharset getAcceptCharset() {
        return AcceptCharset.forString((String)this.getString("Accept-Charset"));
    }

    public AcceptEncoding getAcceptEncoding() {
        return AcceptEncoding.forString((String)this.getString("Accept-Encoding"));
    }

    public AcceptLanguage getAcceptLanguage() {
        return AcceptLanguage.forString((String)this.getString("Accept-Language"));
    }

    public Authorization getAuthorization() {
        return Authorization.forString((String)this.getString("Authorization"));
    }

    public CacheControl getCacheControl() {
        return CacheControl.forString((String)this.getString("Cache-Control"));
    }

    public Connection getConnection() {
        return Connection.forString((String)this.getString("Connection"));
    }

    public ContentLength getContentLength() {
        return ContentLength.forString((String)this.getString("Content-Length"));
    }

    public ContentType getContentType() {
        return ContentType.forString((String)this.getString("Content-Type"));
    }

    public Date getDate() {
        return Date.forString((String)this.getString("Date"));
    }

    public Expect getExpect() {
        return Expect.forString((String)this.getString("Expect"));
    }

    public From getFrom() {
        return From.forString((String)this.getString("From"));
    }

    public Host getHost() {
        return Host.forString((String)this.getString("Host"));
    }

    public IfMatch getIfMatch() {
        return IfMatch.forString((String)this.getString("If-Match"));
    }

    public IfModifiedSince getIfModifiedSince() {
        return IfModifiedSince.forString((String)this.getString("If-Modified-Since"));
    }

    public IfNoneMatch getIfNoneMatch() {
        return IfNoneMatch.forString((String)this.getString("If-None-Match"));
    }

    public IfRange getIfRange() {
        return IfRange.forString((String)this.getString("If-Range"));
    }

    public IfUnmodifiedSince getIfUnmodifiedSince() {
        return IfUnmodifiedSince.forString((String)this.getString("If-Unmodified-Since"));
    }

    public MaxForwards getMaxForwards() {
        return MaxForwards.forString((String)this.getString("Max-Forwards"));
    }

    public Pragma getPragma() {
        return Pragma.forString((String)this.getString("Pragma"));
    }

    public ProxyAuthorization getProxyAuthorization() {
        return ProxyAuthorization.forString((String)this.getString("Proxy-Authorization"));
    }

    public Range getRange() {
        return Range.forString((String)this.getString("Range"));
    }

    public Referer getReferer() {
        return Referer.forString((String)this.getString("Referer"));
    }

    public TE getTE() {
        return TE.forString((String)this.getString("TE"));
    }

    public TimeZone getTimeZone() {
        String tz = this.getString("Time-Zone");
        if (tz != null) {
            return TimeZone.getTimeZone(tz);
        }
        return null;
    }

    public UserAgent getUserAgent() {
        return UserAgent.forString((String)this.getString("User-Agent"));
    }

    public Upgrade getUpgrade() {
        return Upgrade.forString((String)this.getString("Upgrade"));
    }

    public Via getVia() {
        return Via.forString((String)this.getString("Via"));
    }

    public Warning getWarning() {
        return Warning.forString((String)this.getString("Warning"));
    }

    public String toString(boolean sorted) {
        AbstractMap m = sorted ? new TreeMap() : new LinkedHashMap();
        for (Map.Entry e : this.entrySet()) {
            String[] v = (String[])e.getValue();
            m.put(e.getKey(), v.length == 1 ? v[0] : v);
        }
        return JsonSerializer.DEFAULT_LAX.toString(m);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }
}

