/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletInputStream;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.ContentType;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.CharSequenceReader;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.RequestHeaders;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.urlencoding.UrlEncodingParser;

public class RequestBody {
    private byte[] body;
    private final RestRequest req;
    private EncoderGroup encoders;
    private Encoder encoder;
    private ParserGroup parsers;
    private UrlEncodingParser urlEncodingParser;
    private RequestHeaders headers;
    private BeanSession beanSession;
    private int contentLength = 0;

    RequestBody(RestRequest req) {
        this.req = req;
    }

    RequestBody setEncoders(EncoderGroup encoders) {
        this.encoders = encoders;
        return this;
    }

    RequestBody setParsers(ParserGroup parsers) {
        this.parsers = parsers;
        return this;
    }

    RequestBody setHeaders(RequestHeaders headers) {
        this.headers = headers;
        return this;
    }

    RequestBody setUrlEncodingParser(UrlEncodingParser urlEncodingParser) {
        this.urlEncodingParser = urlEncodingParser;
        return this;
    }

    RequestBody setBeanSession(BeanSession beanSession) {
        this.beanSession = beanSession;
        return this;
    }

    RequestBody load(byte[] body) {
        this.body = body;
        return this;
    }

    boolean isLoaded() {
        return this.body != null;
    }

    public <T> T asType(Class<T> type) throws IOException, ParseException {
        return this.parse(this.beanSession.getClassMeta(type));
    }

    public <T> T asType(Type type, Type ... args) {
        return this.parse(this.beanSession.getClassMeta(type, args));
    }

    public String asString() throws IOException {
        if (this.body == null) {
            this.body = IOUtils.readBytes((InputStream)this.getInputStream(), (int)1024);
        }
        return new String(this.body, IOUtils.UTF8);
    }

    public String asHex() throws IOException {
        if (this.body == null) {
            this.body = IOUtils.readBytes((InputStream)this.getInputStream(), (int)1024);
        }
        return StringUtils.toHex((byte[])this.body);
    }

    public BufferedReader getReader() throws IOException {
        Reader r = this.getUnbufferedReader();
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        int len = this.req.getContentLength();
        int buffSize = len <= 0 ? 8192 : Math.max(len, 8192);
        return new BufferedReader(r, buffSize);
    }

    protected Reader getUnbufferedReader() throws IOException {
        if (this.body != null) {
            return new CharSequenceReader((CharSequence)new String(this.body, IOUtils.UTF8));
        }
        return new InputStreamReader((InputStream)this.getInputStream(), this.req.getCharacterEncoding());
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.body != null) {
            return new ServletInputStream2(this.body);
        }
        Encoder enc = this.getEncoder();
        ServletInputStream is = this.req.getRawInputStream();
        if (enc != null) {
            InputStream is2 = enc.getInputStream((InputStream)is);
            return new ServletInputStream2(is2);
        }
        return is;
    }

    public ParserMatch getParserMatch() {
        ParserMatch pm;
        ContentType mediaType = this.headers.getContentType();
        if (StringUtils.isEmpty((Object)mediaType)) {
            mediaType = this.body != null ? MediaType.UON : MediaType.JSON;
        }
        if ((pm = this.parsers.getParserMatch((MediaType)mediaType)) == null && mediaType.equals((Object)MediaType.URLENCODING)) {
            pm = new ParserMatch(MediaType.URLENCODING, (Parser)this.urlEncodingParser);
        }
        return pm;
    }

    public Parser getParser() {
        ParserMatch pm = this.getParserMatch();
        return pm == null ? null : pm.getParser();
    }

    public ReaderParser getReaderParser() {
        Parser p = this.getParser();
        if (p != null && p.isReaderParser()) {
            return (ReaderParser)p;
        }
        return null;
    }

    private <T> T parse(ClassMeta<T> cm) throws RestException {
        try {
            if (cm.isReader()) {
                return (T)this.getReader();
            }
            if (cm.isInputStream()) {
                return (T)this.getInputStream();
            }
            TimeZone timeZone = this.headers.getTimeZone();
            Locale locale = this.req.getLocale();
            ParserMatch pm = this.getParserMatch();
            if (pm != null) {
                Parser p = pm.getParser();
                MediaType mediaType = pm.getMediaType();
                try {
                    this.req.getProperties().append("mediaType", (Object)mediaType).append("characterEncoding", (Object)this.req.getCharacterEncoding());
                    if (!p.isReaderParser()) {
                        InputStreamParser p2 = (InputStreamParser)p;
                        ParserSession session = p2.createSession((Object)this.getInputStream(), this.req.getProperties(), this.req.getJavaMethod(), this.req.getContext().getResource(), locale, timeZone, mediaType);
                        return (T)p2.parseSession(session, cm);
                    }
                    ReaderParser p2 = (ReaderParser)p;
                    ParserSession session = p2.createSession((Object)this.getUnbufferedReader(), this.req.getProperties(), this.req.getJavaMethod(), this.req.getContext().getResource(), locale, timeZone, mediaType);
                    return (T)p2.parseSession(session, cm);
                }
                catch (ParseException e) {
                    throw new RestException(400, "Could not convert request body content to class type ''{0}'' using parser ''{1}''.", cm, p.getClass().getName()).initCause(e);
                }
            }
            throw new RestException(415, "Unsupported media-type in request header ''Content-Type'': ''{0}''\n\tSupported media-types: {1}", this.headers.getContentType(), this.req.getParserGroup().getSupportedMediaTypes());
        }
        catch (IOException e) {
            throw new RestException(500, "I/O exception occurred while attempting to handle request ''{0}''.", this.req.getDescription()).initCause(e);
        }
    }

    private Encoder getEncoder() {
        if (this.encoder == null) {
            String ce = this.req.getHeader("content-encoding");
            if (!StringUtils.isEmpty((String)ce)) {
                ce = ce.trim();
                this.encoder = this.encoders.getEncoder(ce);
                if (this.encoder == null) {
                    throw new RestException(415, "Unsupported encoding in request header ''Content-Encoding'': ''{0}''\n\tSupported codings: {1}", this.req.getHeader("content-encoding"), this.encoders.getSupportedEncodings());
                }
            }
            if (this.encoder != null) {
                this.contentLength = -1;
            }
        }
        if (this.encoder == IdentityEncoder.INSTANCE) {
            return null;
        }
        return this.encoder;
    }

    public int getContentLength() {
        return this.contentLength == 0 ? this.req.getRawContentLength() : this.contentLength;
    }

    private static class ServletInputStream2
    extends ServletInputStream {
        private final InputStream is;

        private ServletInputStream2(InputStream is) {
            this.is = is;
        }

        private ServletInputStream2(byte[] b) {
            this(new ByteArrayInputStream(b));
        }

        public final int read() throws IOException {
            return this.is.read();
        }

        public final void close() throws IOException {
            this.is.close();
        }
    }
}

