/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.UriContext;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommonContext;
import org.apache.juneau.jena.RdfSerializerContext;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.NamespaceFactory;
import org.apache.juneau.xml.XmlUtils;

public final class RdfSerializerSession
extends SerializerSession {
    private final String rdfLanguage;
    private final Namespace juneauNs;
    private final Namespace juneauBpNs;
    private final boolean addLiteralTypes;
    private final boolean addRootProperty;
    private final boolean useXmlNamespaces;
    private final boolean looseCollections;
    private final boolean autoDetectNamespaces;
    private final boolean addBeanTypeProperties;
    private final Property pRoot;
    private final Property pValue;
    private final Property pType;
    private final Model model;
    private final RDFWriter writer;
    private final RdfCollectionFormat collectionFormat;
    private final Namespace[] namespaces;

    protected RdfSerializerSession(RdfSerializerContext ctx, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        super((SerializerContext)ctx, op, output, javaMethod, locale, timeZone, mediaType, uriContext);
        ObjectMap jenaSettings = new ObjectMap();
        jenaSettings.put((Object)"rdfXml.tab", (Object)(this.isUseWhitespace() ? 2 : 0));
        jenaSettings.put((Object)"rdfXml.attributeQuoteChar", (Object)Character.toString(this.getQuoteChar()));
        jenaSettings.putAll(ctx.jenaSettings);
        if (op == null || op.isEmpty()) {
            this.rdfLanguage = ctx.rdfLanguage;
            this.juneauNs = ctx.juneauNs;
            this.juneauBpNs = ctx.juneauBpNs;
            this.addLiteralTypes = ctx.addLiteralTypes;
            this.addRootProperty = ctx.addRootProperty;
            this.collectionFormat = ctx.collectionFormat;
            this.looseCollections = ctx.looseCollections;
            this.useXmlNamespaces = ctx.useXmlNamespaces;
            this.autoDetectNamespaces = ctx.autoDetectNamespaces;
            this.namespaces = ctx.namespaces;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
        } else {
            this.rdfLanguage = op.getString("Rdf.language", ctx.rdfLanguage);
            this.juneauNs = op.containsKey((Object)"Rdf.juneauNs") ? NamespaceFactory.parseNamespace((Object)op.get((Object)"Rdf.juneauNs")) : ctx.juneauNs;
            this.juneauBpNs = op.containsKey((Object)"Rdf.juneauBpNs") ? NamespaceFactory.parseNamespace((Object)op.get((Object)"Rdf.juneauBpNs")) : ctx.juneauBpNs;
            this.addLiteralTypes = op.getBoolean("RdfSerializer.addLiteralTypes", Boolean.valueOf(ctx.addLiteralTypes));
            this.addRootProperty = op.getBoolean("RdfSerializer.addRootProperty", Boolean.valueOf(ctx.addRootProperty));
            for (Map.Entry e : op.entrySet()) {
                String key = (String)e.getKey();
                if (!key.startsWith("Rdf.jena.")) continue;
                jenaSettings.put((Object)key.substring(9), e.getValue());
            }
            this.collectionFormat = RdfCollectionFormat.valueOf(op.getString("Rdf.collectionFormat", "DEFAULT"));
            this.looseCollections = op.getBoolean("Rdf.looseCollections", Boolean.valueOf(ctx.looseCollections));
            this.useXmlNamespaces = op.getBoolean("Rdf.useXmlNamespaces", Boolean.valueOf(ctx.useXmlNamespaces));
            this.autoDetectNamespaces = op.getBoolean("RdfSerializer.autoDetectNamespaces", Boolean.valueOf(ctx.autoDetectNamespaces));
            this.namespaces = (Namespace[])op.get(Namespace[].class, "RdfSerializer.namespaces.list", (Object)ctx.namespaces);
            this.addBeanTypeProperties = op.getBoolean("RdfSerializer.addBeanTypeProperties", Boolean.valueOf(ctx.addBeanTypeProperties));
        }
        this.model = ModelFactory.createDefaultModel();
        this.addModelPrefix(this.juneauNs);
        this.addModelPrefix(this.juneauBpNs);
        for (Namespace ns : this.namespaces) {
            this.addModelPrefix(ns);
        }
        this.pRoot = this.model.createProperty(this.juneauNs.getUri(), "root");
        this.pValue = this.model.createProperty(this.juneauNs.getUri(), "value");
        this.pType = this.model.createProperty(this.juneauNs.getUri(), "_type");
        this.writer = this.model.getWriter(this.rdfLanguage);
        String propPrefix = RdfCommonContext.LANG_PROP_MAP.get(this.rdfLanguage);
        if (propPrefix == null) {
            throw new FormattedRuntimeException("Unknown RDF language encountered: ''{0}''", new Object[]{this.rdfLanguage});
        }
        for (Map.Entry e : jenaSettings.entrySet()) {
            if (!((String)e.getKey()).startsWith(propPrefix)) continue;
            this.writer.setProperty(((String)e.getKey()).substring(propPrefix.length()), e.getValue());
        }
    }

    public void addModelPrefix(Namespace ns) {
        this.model.setNsPrefix(ns.getName(), ns.getUri());
    }

    public final RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public final boolean isUseXmlNamespaces() {
        return this.useXmlNamespaces;
    }

    public final boolean isLooseCollections() {
        return this.looseCollections;
    }

    public final String getRdfLanguage() {
        return this.rdfLanguage;
    }

    public final Namespace getJuneauNs() {
        return this.juneauNs;
    }

    public final Namespace getJuneauBpNs() {
        return this.juneauBpNs;
    }

    public final boolean isAddLiteralTypes() {
        return this.addLiteralTypes;
    }

    public final boolean isAddRootProp() {
        return this.addRootProperty;
    }

    public final boolean isAutoDetectNamespaces() {
        return this.autoDetectNamespaces;
    }

    public final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    public final Property getRootProp() {
        return this.pRoot;
    }

    public final Property getValueProperty() {
        return this.pValue;
    }

    public final Property getTypeProperty() {
        return this.pType;
    }

    public final Model getModel() {
        return this.model;
    }

    public final RDFWriter getRdfWriter() {
        return this.writer;
    }

    public final String encodeTextInvalidChars(Object o) {
        if (o == null) {
            return null;
        }
        String s = this.toString(o);
        return XmlUtils.escapeText((Object)s);
    }

    public final String encodeElementName(Object o) {
        String s = this.toString(o);
        return XmlUtils.encodeElementName((Object)s);
    }
}

