/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommonContext;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.xml.Namespace;

public final class RdfSerializerContext
extends SerializerContext
implements RdfCommonContext {
    public static final String RDF_addLiteralTypes = "RdfSerializer.addLiteralTypes";
    public static final String RDF_addRootProperty = "RdfSerializer.addRootProperty";
    public static final String RDF_autoDetectNamespaces = "RdfSerializer.autoDetectNamespaces";
    public static final String RDF_namespaces = "RdfSerializer.namespaces.list";
    public static final String RDF_addBeanTypeProperties = "RdfSerializer.addBeanTypeProperties";
    final boolean addLiteralTypes;
    final boolean addRootProperty;
    final boolean useXmlNamespaces;
    final boolean looseCollections;
    final boolean autoDetectNamespaces;
    final boolean addBeanTypeProperties;
    final String rdfLanguage;
    final Namespace juneauNs;
    final Namespace juneauBpNs;
    final RdfCollectionFormat collectionFormat;
    final Map<String, Object> jenaSettings = new HashMap<String, Object>();
    final Namespace[] namespaces;

    public RdfSerializerContext(PropertyStore ps) {
        super(ps);
        this.addLiteralTypes = (Boolean)ps.getProperty(RDF_addLiteralTypes, Boolean.TYPE, (Object)false);
        this.addRootProperty = (Boolean)ps.getProperty(RDF_addRootProperty, Boolean.TYPE, (Object)false);
        this.useXmlNamespaces = (Boolean)ps.getProperty("Rdf.useXmlNamespaces", Boolean.TYPE, (Object)true);
        this.looseCollections = (Boolean)ps.getProperty("Rdf.looseCollections", Boolean.TYPE, (Object)false);
        this.autoDetectNamespaces = (Boolean)ps.getProperty(RDF_autoDetectNamespaces, Boolean.TYPE, (Object)true);
        this.rdfLanguage = (String)ps.getProperty("Rdf.language", String.class, (Object)"RDF/XML-ABBREV");
        this.juneauNs = (Namespace)ps.getProperty("Rdf.juneauNs", Namespace.class, (Object)new Namespace("j", "http://www.apache.org/juneau/"));
        this.juneauBpNs = (Namespace)ps.getProperty("Rdf.juneauBpNs", Namespace.class, (Object)new Namespace("jp", "http://www.apache.org/juneaubp/"));
        this.collectionFormat = (RdfCollectionFormat)((Object)ps.getProperty("Rdf.collectionFormat", RdfCollectionFormat.class, (Object)RdfCollectionFormat.DEFAULT));
        this.namespaces = (Namespace[])ps.getProperty(RDF_namespaces, Namespace[].class, (Object)new Namespace[0]);
        this.addBeanTypeProperties = (Boolean)ps.getProperty(RDF_addBeanTypeProperties, Boolean.TYPE, ps.getProperty("Serializer.addBeanTypeProperties", Boolean.TYPE, (Object)true));
    }

    public ObjectMap asMap() {
        return super.asMap().append("RdfSerializerContext", (Object)new ObjectMap().append("addLiteralTypes", (Object)this.addLiteralTypes).append("addRootProperty", (Object)this.addRootProperty).append("useXmlNamespaces", (Object)this.useXmlNamespaces).append("looseCollections", (Object)this.looseCollections).append("autoDetectNamespaces", (Object)this.autoDetectNamespaces).append("rdfLanguage", (Object)this.rdfLanguage).append("juneauNs", (Object)this.juneauNs).append("juneauBpNs", (Object)this.juneauBpNs).append("collectionFormat", (Object)this.collectionFormat).append("namespaces", (Object)this.namespaces).append("addBeanTypeProperties", (Object)this.addBeanTypeProperties));
    }
}

