/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.microservice.Resource;
import org.apache.juneau.rest.Redirect;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.HtmlDoc;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.converters.Queryable;
import org.apache.juneau.transforms.DateSwap;
import org.apache.juneau.utils.IOPipe;

@RestResource(title="File System Explorer", description="Contents of $R{attribute.path}", messages="nls/DirectoryResource", htmldoc=@HtmlDoc(links={"up: request:/..", "options: servlet:/?method=OPTIONS"}), properties={@Property(name="HtmlSerializer.uriAnchorText", value="PROPERTY_NAME"), @Property(name="RestServlet.allowMethodParam", value="*"), @Property(name="DirectoryResource.rootDir", value="")})
public class DirectoryResource
extends Resource {
    private static final long serialVersionUID = 1L;
    private File rootDir;
    private boolean allowDeletes;
    private boolean allowPuts;
    private boolean allowViews;
    private static Logger logger = Logger.getLogger(DirectoryResource.class.getName());

    public void init() throws ServletException {
        ObjectMap p = this.getProperties();
        this.rootDir = new File(p.getString("DirectoryResource.rootDir"));
        this.allowViews = p.getBoolean("DirectoryResource.allowViews", Boolean.valueOf(false));
        this.allowDeletes = p.getBoolean("DirectoryResource.allowDeletes", Boolean.valueOf(false));
        this.allowPuts = p.getBoolean("DirectoryResource.allowPuts", Boolean.valueOf(false));
    }

    protected File getRootDir() {
        if (this.rootDir == null) {
            this.rootDir = new File(this.getProperties().getString("rootDir"));
            if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
                throw new RuntimeException("Could not create root dir");
            }
        }
        return this.rootDir;
    }

    @RestMethod(name="GET", path="/*", description="On directories, returns a directory listing.\nOn files, returns information about the file.", converters={Queryable.class})
    public Object doGet(RestRequest req) throws Exception {
        File f;
        this.checkAccess(req);
        String pathInfo = req.getPathInfo();
        File file = f = pathInfo == null ? this.rootDir : new File(this.rootDir.getAbsolutePath() + pathInfo);
        if (!f.exists()) {
            throw new RestException(404, "File not found", new Object[0]);
        }
        req.setAttribute("path", (Object)f.getAbsolutePath());
        if (f.isDirectory()) {
            LinkedList<FileResource> l = new LinkedList<FileResource>();
            File[] files = f.listFiles();
            if (files != null) {
                for (File fc : files) {
                    URL fUrl = new URL(req.getRequestURL().append("/").append(fc.getName()).toString());
                    l.add(new FileResource(fc, fUrl));
                }
            }
            return l;
        }
        return new FileResource(f, new URL(req.getRequestURL().toString()));
    }

    @RestMethod(name="DELETE", path="/*", description="Delete a file on the file system.")
    public Object doDelete(RestRequest req) throws Exception {
        this.checkAccess(req);
        File f = new File(this.rootDir.getAbsolutePath() + req.getPathInfo());
        this.deleteFile(f);
        if (req.getHeader("Accept").contains("text/html")) {
            return new Redirect();
        }
        return "File deleted";
    }

    @RestMethod(name="PUT", path="/*", description="Add or overwrite a file on the file system.")
    public Object doPut(RestRequest req) throws Exception {
        this.checkAccess(req);
        File f = new File(this.rootDir.getAbsolutePath() + req.getPathInfo());
        String parentSubPath = f.getParentFile().getAbsolutePath().substring(this.rootDir.getAbsolutePath().length());
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
        IOPipe.create((Object)req.getInputStream(), (Object)bos).closeOut().run();
        if (req.getContentType().contains("html")) {
            return new Redirect((Object)parentSubPath);
        }
        return "File added";
    }

    @RestMethod(name="VIEW", path="/*", description="View the contents of a file.\nApplies to files only.")
    public Reader doView(RestRequest req, RestResponse res) throws Exception {
        this.checkAccess(req);
        File f = new File(this.rootDir.getAbsolutePath() + req.getPathInfo());
        if (!f.exists()) {
            throw new RestException(404, "File not found", new Object[0]);
        }
        if (f.isDirectory()) {
            throw new RestException(405, "VIEW not available on directories", new Object[0]);
        }
        res.setContentType("text/plain");
        return new FileReader(f);
    }

    @RestMethod(name="DOWNLOAD", path="/*", description="Download the contents of a file.\nApplies to files only.")
    public Reader doDownload(RestRequest req, RestResponse res) throws Exception {
        this.checkAccess(req);
        File f = new File(this.rootDir.getAbsolutePath() + req.getPathInfo());
        if (!f.exists()) {
            throw new RestException(404, "File not found", new Object[0]);
        }
        if (f.isDirectory()) {
            throw new RestException(405, "DOWNLOAD not available on directories", new Object[0]);
        }
        res.setContentType("application");
        return new FileReader(f);
    }

    protected void checkAccess(RestRequest req) {
        String method = req.getMethod();
        if (method.equals("VIEW") && !this.allowViews) {
            throw new RestException(405, "VIEW not enabled", new Object[0]);
        }
        if (method.equals("PUT") && !this.allowPuts) {
            throw new RestException(405, "PUT not enabled", new Object[0]);
        }
        if (method.equals("DELETE") && !this.allowDeletes) {
            throw new RestException(405, "DELETE not enabled", new Object[0]);
        }
        if (method.equals("DOWNLOAD") && !this.allowViews) {
            throw new RestException(405, "DOWNLOAD not enabled", new Object[0]);
        }
    }

    private void deleteFile(File f) {
        try {
            File[] files;
            if (f.isDirectory() && (files = f.listFiles()) != null) {
                for (File fc : files) {
                    this.deleteFile(fc);
                }
            }
            f.delete();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot delete file '" + f.getAbsolutePath() + "'", e);
        }
    }

    public class FileResource {
        private File f;
        private URL url;

        public FileResource(File f, URL url) {
            this.f = f;
            this.url = url;
        }

        public URL getUrl() {
            return this.url;
        }

        public String getType() {
            return this.f.isDirectory() ? "dir" : "file";
        }

        public String getName() {
            return this.f.getName();
        }

        public long getSize() {
            return this.f.length();
        }

        @BeanProperty(swap=DateSwap.ISO8601DTP.class)
        public Date getLastModified() {
            return new Date(this.f.lastModified());
        }

        public URL getView() throws Exception {
            if (DirectoryResource.this.allowViews && this.f.canRead() && !this.f.isDirectory()) {
                return new URL(this.url + "?method=VIEW");
            }
            return null;
        }

        public URL getDownload() throws Exception {
            if (DirectoryResource.this.allowViews && this.f.canRead() && !this.f.isDirectory()) {
                return new URL(this.url + "?method=DOWNLOAD");
            }
            return null;
        }

        public URL getDelete() throws Exception {
            if (DirectoryResource.this.allowDeletes && this.f.canWrite()) {
                return new URL(this.url + "?method=DELETE");
            }
            return null;
        }
    }
}

