/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.dto.html5.Form;
import org.apache.juneau.dto.html5.HtmlBuilder;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.ini.ConfigFileBuilder;
import org.apache.juneau.microservice.Resource;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.FormData;
import org.apache.juneau.rest.annotation.HtmlDoc;
import org.apache.juneau.rest.annotation.MethodSwagger;
import org.apache.juneau.rest.annotation.Parameter;
import org.apache.juneau.rest.annotation.Path;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;

@RestResource(path="/config", title="Configuration", description="Contents of configuration file.", htmldoc=@HtmlDoc(links={"up: request:/..", "options: servlet:/?method=OPTIONS", "edit: servlet:/edit"}))
public class ConfigResource
extends Resource {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/", description="Show contents of config file.")
    public ConfigFile getConfigContents() throws Exception {
        return this.getServletConfig().getConfigFile();
    }

    @RestMethod(name="GET", path="/edit", description="Edit config file.")
    public Form getConfigEditForm(RestRequest req) throws Exception {
        return HtmlBuilder.form().id("form").action("servlet:/").method("POST").enctype("application/x-www-form-urlencoded").children(new Object[]{HtmlBuilder.div()._class("data").children(new Object[]{HtmlBuilder.table((Object[])new Object[]{HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.td().style("text-align:right").children(new Object[]{HtmlBuilder.button((String)"submit", (Object[])new Object[]{"Submit"}), HtmlBuilder.button((String)"reset", (Object[])new Object[]{"Reset"})})}), HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th().child((Object)"Contents")}), HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th().child((Object)HtmlBuilder.textarea().name("contents").rows((Number)40).cols((Object)120).style("white-space:pre;word-wrap:normal;overflow-x:scroll;font-family:monospace;").text((Object)this.getConfigContents().toString()))})})})});
    }

    @RestMethod(name="GET", path="/{section}", description="Show config file section.", swagger=@MethodSwagger(parameters={@Parameter(in="path", name="section", description="Section name.")}))
    public ObjectMap getConfigSection(@Path(value="section") String section) throws Exception {
        return this.getSection(section);
    }

    @RestMethod(name="GET", path="/{section}/{key}", description="Show config file entry.", swagger=@MethodSwagger(parameters={@Parameter(in="path", name="section", description="Section name."), @Parameter(in="path", name="key", description="Entry name.")}))
    public String getConfigEntry(@Path(value="section") String section, @Path(value="key") String key) throws Exception {
        return this.getSection(section).getString(key);
    }

    @RestMethod(name="POST", path="/", description="Sets contents of config file from a FORM post.", swagger=@MethodSwagger(parameters={@Parameter(in="formData", name="contents", description="New contents in INI file format.")}))
    public ConfigFile setConfigContentsFormPost(@FormData(value="contents") String contents) throws Exception {
        return this.setConfigContents(new StringReader(contents));
    }

    @RestMethod(name="PUT", path="/", description="Sets contents of config file.", swagger=@MethodSwagger(parameters={@Parameter(in="body", description="New contents in INI file format.")}))
    public ConfigFile setConfigContents(@Body Reader contents) throws Exception {
        ConfigFile cf2 = new ConfigFileBuilder().build(contents);
        return this.getConfigContents().merge(cf2).save();
    }

    @RestMethod(name="PUT", path="/{section}", description="Add or overwrite a config file section.", swagger=@MethodSwagger(parameters={@Parameter(in="path", name="section", description="Section name."), @Parameter(in="body", description="New contents for section as a simple map with string keys and values.")}))
    public ObjectMap setConfigSection(@Path(value="section") String section, @Body Map<String, String> contents) throws Exception {
        this.getConfigContents().setSection(section, contents);
        return this.getSection(section);
    }

    @RestMethod(name="PUT", path="/{section}/{key}", description="Add or overwrite a config file entry.", swagger=@MethodSwagger(parameters={@Parameter(in="path", name="section", description="Section name."), @Parameter(in="path", name="key", description="Entry name."), @Parameter(in="body", description="New value as a string.")}))
    public String setConfigSection(@Path(value="section") String section, @Path(value="key") String key, @Body String value) throws Exception {
        this.getConfigContents().put(section, key, value, false);
        return this.getSection(section).getString(key);
    }

    private ObjectMap getSection(String name) throws Exception {
        ObjectMap m = this.getConfigContents().getSectionMap(name);
        if (m == null) {
            throw new RestException(404, "Section not found.", new Object[0]);
        }
        return m;
    }
}

