/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice;

import java.io.ByteArrayInputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.ini.ConfigFileBuilder;
import org.apache.juneau.ini.ConfigFileListener;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.vars.ArgsVar;
import org.apache.juneau.svl.vars.ConfigFileVar;
import org.apache.juneau.svl.vars.IfVar;
import org.apache.juneau.svl.vars.ManifestFileVar;
import org.apache.juneau.svl.vars.SwitchVar;
import org.apache.juneau.utils.Args;
import org.apache.juneau.utils.ManifestFile;

public abstract class Microservice {
    private static Args args;
    private static ConfigFile cf;
    private static ManifestFile mf;
    private String cfPath;

    protected Microservice(String ... args) throws Exception {
        Microservice.args = new Args(args);
    }

    public Microservice setConfig(String cfPath, boolean create) throws IOException {
        File f = new File(cfPath);
        if (!f.exists()) {
            if (!create) {
                throw new FileNotFoundException("Could not locate config file at '" + f.getAbsolutePath() + "'");
            }
            if (!f.createNewFile()) {
                throw new FileNotFoundException("Could not create config file at '" + f.getAbsolutePath() + "'");
            }
        }
        this.cfPath = cfPath;
        return this;
    }

    public Microservice setConfig(ConfigFile cf) {
        Microservice.cf = cf;
        return this;
    }

    public Microservice setManifest(Manifest mf) {
        Microservice.mf = new ManifestFile(mf);
        return this;
    }

    public Microservice setManifestContents(String ... contents) throws IOException {
        String s = StringUtils.join((Object[])contents, (String)"\n") + "\n";
        mf = new ManifestFile(new Manifest(new ByteArrayInputStream(s.getBytes("UTF-8"))));
        return this;
    }

    public Microservice setManifest(File f) throws IOException {
        mf = new ManifestFile(f);
        return this;
    }

    public Microservice setManifest(Class<?> c) throws IOException {
        mf = new ManifestFile(c);
        return this;
    }

    protected VarResolverBuilder createVarResolver() {
        VarResolverBuilder b = new VarResolverBuilder().defaultVars().vars(new Class[]{ConfigFileVar.class, ManifestFileVar.class, ArgsVar.class, SwitchVar.class, IfVar.class}).contextObject("manifest", (Object)mf).contextObject("args", (Object)args);
        if (cf != null) {
            b.contextObject("config", (Object)cf);
        }
        return b;
    }

    protected static Args getArgs() {
        return args;
    }

    protected static ConfigFile getConfig() {
        return cf;
    }

    protected static ManifestFile getManifest() {
        return mf;
    }

    public Microservice start() throws Exception {
        Set spKeys;
        if (mf == null) {
            Manifest m = new Manifest();
            File f = new File("META-INF/MANIFEST.MF");
            if (f.exists()) {
                try {
                    m.read(new FileInputStream(f));
                }
                catch (IOException e) {
                    System.err.println("Problem detected in MANIFEST.MF.  Contents below:\n" + IOUtils.read((File)f));
                    throw e;
                }
            }
            URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
            URL url = cl.findResource("META-INF/MANIFEST.MF");
            if (url != null) {
                try {
                    m.read(url.openStream());
                }
                catch (IOException e) {
                    System.err.println("Problem detected in MANIFEST.MF.  Contents below:\n" + IOUtils.read((InputStream)url.openStream()));
                    throw e;
                }
            }
            mf = new ManifestFile(m);
        }
        ConfigFileBuilder cfb = new ConfigFileBuilder();
        if (this.cfPath != null) {
            cf = cfb.build(this.cfPath).getResolving(this.createVarResolver().build());
        }
        if (cf == null) {
            if (args.hasArg(0)) {
                this.cfPath = args.getArg(0);
            } else if (mf.containsKey((Object)"Main-ConfigFile")) {
                this.cfPath = mf.getString("Main-ConfigFile");
            } else {
                String cmd = System.getProperty("sun.java.command", "not_found").split("\\s+")[0];
                if (cmd.endsWith(".jar")) {
                    this.cfPath = cmd.replace(".jar", ".cfg");
                }
            }
            if (this.cfPath == null) {
                System.err.println("Running class [" + this.getClass().getSimpleName() + "] without a config file.");
                cf = cfb.build();
            } else {
                System.out.println("Running class [" + this.getClass().getSimpleName() + "] using config file [" + this.cfPath + "]");
                cf = cfb.build(this.cfPath).getResolving(this.createVarResolver().build());
            }
        }
        if (this.cfPath != null) {
            System.setProperty("juneau.configFile", this.cfPath);
        }
        if ((spKeys = cf.getSectionKeys("SystemProperties")) != null) {
            for (String key : spKeys) {
                System.setProperty(key, cf.get("SystemProperties", key));
            }
        }
        cf.addListener(new ConfigFileListener(){

            public void onSave(ConfigFile cf) {
                Microservice.this.onConfigSave(cf);
            }

            public void onChange(ConfigFile cf, Set<String> changes) {
                Microservice.this.onConfigChange(cf, changes);
            }
        });
        new Thread(){

            @Override
            public void run() {
                Console c = System.console();
                if (c == null) {
                    System.out.println("No available console.");
                } else {
                    String l;
                    while ((l = c.readLine("\nEnter 'exit' to exit.\n", new Object[0])) != null && !l.equals("exit")) {
                    }
                    Microservice.this.stop();
                }
            }
        }.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Microservice.this.stop();
            }
        });
        this.onStart();
        return this;
    }

    public Microservice join() throws Exception {
        return this;
    }

    public Microservice stop() {
        this.onStop();
        return this;
    }

    public void kill() {
        System.exit(2);
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    protected void onConfigSave(ConfigFile cf) {
    }

    protected void onConfigChange(ConfigFile cf, Set<String> changes) {
    }
}

