/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.XmlSerializerContext;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.XmlWriter;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

@Produces(value="text/xml+schema", contentType="text/xml")
public class XmlSchemaSerializer
extends XmlSerializer {
    private final XmlSerializerContext ctx;
    private static Pattern pTargetNs = Pattern.compile("targetNamespace=['\"]([^'\"]+)['\"]");

    public XmlSchemaSerializer(PropertyStore propertyStore) {
        this(propertyStore, null);
    }

    public XmlSchemaSerializer(PropertyStore propertyStore, Map<String, Object> overrideProperties) {
        super(propertyStore);
        this.ctx = this.propertyStore.create(overrideProperties).getContext(XmlSerializerContext.class);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        XmlSerializerSession s = (XmlSerializerSession)session;
        if (s.isEnableNamespaces() && s.isAutoDetectNamespaces()) {
            this.findNsfMappings(s, o);
        }
        Namespace xs = s.getXsNamespace();
        Namespace[] allNs = ArrayUtils.append(new Namespace[]{s.getDefaultNamespace()}, s.getNamespaces());
        Schemas schemas = new Schemas(s, xs, s.getDefaultNamespace(), allNs);
        schemas.process(s, o);
        schemas.serializeTo(session.getWriter());
    }

    public Validator getValidator(SerializerSession session, Object o) throws Exception {
        this.doSerialize(session, o);
        String xmlSchema = session.getWriter().toString();
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (xmlSchema.indexOf(0) != -1) {
            final HashMap<String, String> schemas = new HashMap<String, String>();
            String[] ss = xmlSchema.split("\u0000");
            xmlSchema = ss[0];
            for (String s : ss) {
                Matcher m = pTargetNs.matcher(s);
                if (!m.find()) continue;
                schemas.put(m.group(1), s);
            }
            factory.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    String schema = (String)schemas.get(namespaceURI);
                    if (schema == null) {
                        throw new FormattedRuntimeException("No schema found for namespaceURI ''{0}''", namespaceURI);
                    }
                    try {
                        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS 3.0"));
                        LSInput in = domImplementationLS.createLSInput();
                        in.setCharacterStream(new StringReader(schema));
                        in.setSystemId(systemId);
                        return in;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return factory.newSchema(new StreamSource(new StringReader(xmlSchema))).newValidator();
    }

    private static <T> T first(T ... tt) {
        for (T t : tt) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    private static String getXmlAttrType(ClassMeta<?> cm) {
        if (cm.isBoolean()) {
            return "boolean";
        }
        if (cm.isNumber()) {
            if (cm.isDecimal()) {
                return "decimal";
            }
            return "integer";
        }
        return "string";
    }

    @Override
    public XmlSerializerSession createSession(Object output, ObjectMap op, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        if (op == null) {
            op = new ObjectMap();
        }
        op.put("XmlSerializer.enableNamespaces", true);
        return new XmlSerializerSession(this.ctx, op, output, javaMethod, locale, timeZone, mediaType, uriContext);
    }

    private class Schema {
        private StringWriter sw = new StringWriter();
        private XmlWriter w;
        private XmlSerializerSession session;
        private Namespace defaultNs;
        private Namespace targetNs;
        private Schemas schemas;
        private Set<String> processedTypes = new HashSet<String>();
        private Set<String> processedAttributes = new HashSet<String>();
        private Set<String> processedElements = new HashSet<String>();

        public Schema(XmlSerializerSession session, Schemas schemas, Namespace xs, Namespace targetNs, Namespace defaultNs, Namespace[] allNs) throws IOException {
            this.schemas = schemas;
            this.defaultNs = defaultNs;
            this.targetNs = targetNs;
            this.session = session;
            this.w = new XmlWriter(this.sw, session.isUseWhitespace(), session.getMaxIndent(), session.isTrimStrings(), session.getQuoteChar(), null, true, null);
            int i = session.getIndent();
            this.w.oTag(i, "schema");
            this.w.attr("xmlns", xs.getUri());
            this.w.attr("targetNamespace", targetNs.getUri());
            this.w.attr("elementFormDefault", "qualified");
            if (targetNs != defaultNs) {
                this.w.attr("attributeFormDefault", "qualified");
            }
            for (Namespace ns2 : allNs) {
                this.w.attr("xmlns", ns2.name, (Object)ns2.uri);
            }
            this.w.append('>').nl(i);
            for (Namespace ns : allNs) {
                if (ns == targetNs) continue;
                this.w.oTag(i + 1, "import").attr("namespace", ns.getUri()).attr("schemaLocation", ns.getName() + ".xsd").append("/>").nl(i + 1);
            }
        }

        private boolean processElement(String name, ClassMeta<?> cm) throws IOException {
            if (this.processedElements.contains(name)) {
                return false;
            }
            this.processedElements.add(name);
            ClassMeta<?> ft = cm.getSerializedClassMeta();
            int i = this.session.getIndent() + 1;
            if (name == null) {
                name = this.getElementName(ft);
            }
            Namespace ns = (Namespace)XmlSchemaSerializer.first(new Namespace[]{ft.getExtendedMeta(XmlClassMeta.class).getNamespace(), this.defaultNs});
            String type = this.getXmlType(ns, ft);
            this.w.oTag(i, "element").attr("name", XmlUtils.encodeElementName(name)).attr("type", type).append('/').append('>').nl(i);
            this.schemas.queueType(ns, null, ft);
            this.schemas.processQueue();
            return true;
        }

        private boolean processAttribute(String name, ClassMeta<?> cm) throws IOException {
            if (this.processedAttributes.contains(name)) {
                return false;
            }
            this.processedAttributes.add(name);
            int i = this.session.getIndent() + 1;
            String type = XmlSchemaSerializer.getXmlAttrType(cm);
            this.w.oTag(i, "attribute").attr("name", name).attr("type", type).append('/').append('>').nl(i);
            return true;
        }

        private boolean processType(String name, ClassMeta<?> cm) throws IOException {
            if (this.processedTypes.contains(name)) {
                return false;
            }
            this.processedTypes.add(name);
            int i = this.session.getIndent() + 1;
            cm = cm.getSerializedClassMeta();
            XmlBeanMeta xbm = cm.isBean() ? cm.getBeanMeta().getExtendedMeta(XmlBeanMeta.class) : null;
            this.w.oTag(i, "complexType").attr("name", name);
            if (xbm != null && xbm.getContentFormat() != null && xbm.getContentFormat().isOneOf(XmlFormat.TEXT, XmlFormat.TEXT_PWS, XmlFormat.MIXED, XmlFormat.MIXED_PWS, XmlFormat.XMLTEXT) || !cm.isMapOrBean()) {
                this.w.attr("mixed", "true");
            }
            this.w.cTag().nl(i);
            if (!(cm.isMapOrBean() || cm.isCollectionOrArray() || cm.isAbstract() && !cm.isNumber() || cm.isObject())) {
                this.w.oTag(i + 1, "attribute").attr("name", this.session.getBeanTypePropertyName(cm)).attr("type", "string").ceTag().nl(i + 1);
            } else {
                if (cm.isBean()) {
                    BeanMeta<?> bm = cm.getBeanMeta();
                    boolean hasChildElements = false;
                    for (BeanPropertyMeta pMeta : bm.getPropertyMetas()) {
                        XmlFormat pMetaFormat = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getXmlFormat();
                        if (pMetaFormat == XmlFormat.ATTR) continue;
                        hasChildElements = true;
                    }
                    XmlBeanMeta xbm2 = bm.getExtendedMeta(XmlBeanMeta.class);
                    if (xbm2.getContentProperty() != null && xbm2.getContentFormat() == XmlFormat.ELEMENTS) {
                        this.w.sTag(i + 1, "sequence").nl(i + 1);
                        this.w.oTag(i + 2, "any").attr("processContents", "skip").attr("minOccurs", 0).ceTag().nl(i + 2);
                        this.w.eTag(i + 1, "sequence").nl(i + 1);
                    } else if (hasChildElements) {
                        XmlBeanPropertyMeta xmlMeta;
                        boolean hasOtherNsElement = false;
                        boolean hasCollapsed = false;
                        for (BeanPropertyMeta pMeta : bm.getPropertyMetas()) {
                            xmlMeta = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class);
                            if (xmlMeta.getXmlFormat() == XmlFormat.ATTR) continue;
                            if (xmlMeta.getNamespace() != null) {
                                ClassMeta<?> ct2 = pMeta.getClassMeta();
                                Namespace cNs = (Namespace)XmlSchemaSerializer.first(new Namespace[]{xmlMeta.getNamespace(), ct2.getExtendedMeta(XmlClassMeta.class).getNamespace(), cm.getExtendedMeta(XmlClassMeta.class).getNamespace(), this.defaultNs});
                                this.schemas.queueElement(cNs, pMeta.getName(), ct2);
                                hasOtherNsElement = true;
                            }
                            if (xmlMeta.getXmlFormat() != XmlFormat.COLLAPSED) continue;
                            hasCollapsed = true;
                        }
                        if (hasOtherNsElement || hasCollapsed) {
                            this.w.oTag(i + 1, "choice").attr("maxOccurs", "unbounded").cTag().nl(i + 1);
                            this.w.oTag(i + 2, "any").attr("processContents", "skip").attr("minOccurs", 0).ceTag().nl(i + 2);
                            this.w.eTag(i + 1, "choice").nl(i + 1);
                        } else {
                            this.w.sTag(i + 1, "all").nl(i + 1);
                            for (BeanPropertyMeta pMeta : bm.getPropertyMetas()) {
                                xmlMeta = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class);
                                if (xmlMeta.getXmlFormat() == XmlFormat.ATTR) continue;
                                boolean isCollapsed = xmlMeta.getXmlFormat() == XmlFormat.COLLAPSED;
                                ClassMeta<?> ct2 = pMeta.getClassMeta();
                                String childName = pMeta.getName();
                                if (isCollapsed) {
                                    if (xmlMeta.getChildName() != null) {
                                        childName = xmlMeta.getChildName();
                                    }
                                    ct2 = pMeta.getClassMeta().getElementType();
                                }
                                Namespace cNs = (Namespace)XmlSchemaSerializer.first(new Namespace[]{xmlMeta.getNamespace(), ct2.getExtendedMeta(XmlClassMeta.class).getNamespace(), cm.getExtendedMeta(XmlClassMeta.class).getNamespace(), this.defaultNs});
                                if (xmlMeta.getNamespace() == null) {
                                    this.w.oTag(i + 2, "element").attr("name", (Object)XmlUtils.encodeElementName(childName), false).attr("type", this.getXmlType(cNs, ct2)).attr("minOccurs", 0);
                                    this.w.ceTag().nl(i + 2);
                                    continue;
                                }
                                this.schemas.queueElement(cNs, pMeta.getName(), ct2);
                                hasOtherNsElement = true;
                            }
                            this.w.eTag(i + 1, "all").nl(i + 1);
                        }
                    }
                    for (BeanPropertyMeta pMeta : bm.getExtendedMeta(XmlBeanMeta.class).getAttrProperties().values()) {
                        Namespace pNs = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
                        if (pNs == null) {
                            pNs = this.defaultNs;
                        }
                        if (pNs != this.targetNs) {
                            this.schemas.queueAttribute(pNs, pMeta.getName(), pMeta.getClassMeta());
                            this.w.oTag(i + 1, "attribute").attr("ref", pNs.getName() + ':' + pMeta.getName()).ceTag().nl(i + 1);
                            continue;
                        }
                        this.w.oTag(i + 1, "attribute").attr("name", (Object)pMeta.getName(), true).attr("type", XmlSchemaSerializer.getXmlAttrType(pMeta.getClassMeta())).ceTag().nl(i + 1);
                    }
                } else if (cm.isCollectionOrArray()) {
                    ClassMeta<?> elementType = cm.getElementType();
                    if (elementType.isObject()) {
                        this.w.sTag(i + 1, "sequence").nl(i + 1);
                        this.w.oTag(i + 2, "any").attr("processContents", "skip").attr("maxOccurs", "unbounded").attr("minOccurs", "0").ceTag().nl(i + 2);
                        this.w.eTag(i + 1, "sequence").nl(i + 1);
                    } else {
                        Namespace cNs = (Namespace)XmlSchemaSerializer.first(new Namespace[]{elementType.getExtendedMeta(XmlClassMeta.class).getNamespace(), cm.getExtendedMeta(XmlClassMeta.class).getNamespace(), this.defaultNs});
                        this.schemas.queueType(cNs, null, elementType);
                        this.w.sTag(i + 1, "sequence").nl(i + 1);
                        this.w.oTag(i + 2, "any").attr("processContents", "skip").attr("maxOccurs", "unbounded").attr("minOccurs", "0").ceTag().nl(i + 2);
                        this.w.eTag(i + 1, "sequence").nl(i + 1);
                    }
                } else if (cm.isMap() || cm.isAbstract() || cm.isObject()) {
                    this.w.sTag(i + 1, "sequence").nl(i + 1);
                    this.w.oTag(i + 2, "any").attr("processContents", "skip").attr("maxOccurs", "unbounded").attr("minOccurs", "0").ceTag().nl(i + 2);
                    this.w.eTag(i + 1, "sequence").nl(i + 1);
                }
                this.w.oTag(i + 1, "attribute").attr("name", this.session.getBeanTypePropertyName(null)).attr("type", "string").ceTag().nl(i + 1);
            }
            this.w.eTag(i, "complexType").nl(i);
            this.schemas.processQueue();
            return true;
        }

        private String getElementName(ClassMeta<?> cm) {
            String name = (cm = cm.getSerializedClassMeta()).getDictionaryName();
            if (name == null) {
                name = cm.isBoolean() ? "boolean" : (cm.isNumber() ? "number" : (cm.isCollectionOrArray() ? "array" : (!cm.isMapOrBean() && !cm.isCollectionOrArray() && !cm.isObject() && !cm.isAbstract() ? "string" : "object")));
            }
            return name;
        }

        public String toString() {
            try {
                int i = this.session.getIndent();
                this.w.eTag(i, "schema").nl(i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.sw.toString();
        }

        private String getXmlType(Namespace currentNs, ClassMeta<?> cm) {
            String name = null;
            cm = cm.getSerializedClassMeta();
            if (currentNs == this.targetNs && cm.isPrimitive()) {
                if (cm.isBoolean()) {
                    name = "boolean";
                } else if (cm.isNumber()) {
                    name = cm.isDecimal() ? "decimal" : "integer";
                }
            }
            if (name == null) {
                name = XmlUtils.encodeElementName(cm);
                this.schemas.queueType(currentNs, name, cm);
                return currentNs.getName() + ":" + name;
            }
            return name;
        }
    }

    private class Schemas
    extends LinkedHashMap<Namespace, Schema> {
        private static final long serialVersionUID = 1L;
        private Namespace defaultNs;
        private LinkedList<QueueEntry> elementQueue = new LinkedList();
        private LinkedList<QueueEntry> attributeQueue = new LinkedList();
        private LinkedList<QueueEntry> typeQueue = new LinkedList();

        private Schemas(XmlSerializerSession session, Namespace xs, Namespace defaultNs, Namespace[] allNs) throws IOException {
            this.defaultNs = defaultNs;
            for (Namespace ns : allNs) {
                this.put(ns, new Schema(session, this, xs, ns, defaultNs, allNs));
            }
        }

        private Schema getSchema(Namespace ns) {
            Schema s;
            if (ns == null) {
                ns = this.defaultNs;
            }
            if ((s = (Schema)this.get(ns)) == null) {
                throw new FormattedRuntimeException("No schema defined for namespace ''{0}''", ns);
            }
            return s;
        }

        private void process(SerializerSession session, Object o) throws IOException {
            ClassMeta<Object> cm = session.getClassMetaForObject(o);
            Namespace ns = this.defaultNs;
            if (cm == null) {
                this.queueElement(ns, "null", XmlSchemaSerializer.this.object());
            } else {
                XmlClassMeta xmlMeta = cm.getExtendedMeta(XmlClassMeta.class);
                if (cm.getDictionaryName() != null && xmlMeta.getNamespace() != null) {
                    ns = xmlMeta.getNamespace();
                }
                this.queueElement(ns, cm.getDictionaryName(), cm);
            }
            this.processQueue();
        }

        private void processQueue() throws IOException {
            boolean b;
            do {
                QueueEntry q;
                b = false;
                while (!this.elementQueue.isEmpty()) {
                    q = this.elementQueue.removeFirst();
                    b |= this.getSchema(q.ns).processElement(q.name, q.cm);
                }
                while (!this.typeQueue.isEmpty()) {
                    q = this.typeQueue.removeFirst();
                    b |= this.getSchema(q.ns).processType(q.name, q.cm);
                }
                while (!this.attributeQueue.isEmpty()) {
                    q = this.attributeQueue.removeFirst();
                    b |= this.getSchema(q.ns).processAttribute(q.name, q.cm);
                }
            } while (b);
        }

        private void queueElement(Namespace ns, String name, ClassMeta<?> cm) {
            this.elementQueue.add(new QueueEntry(ns, name, cm));
        }

        private void queueType(Namespace ns, String name, ClassMeta<?> cm) {
            if (name == null) {
                name = XmlUtils.encodeElementName(cm);
            }
            this.typeQueue.add(new QueueEntry(ns, name, cm));
        }

        private void queueAttribute(Namespace ns, String name, ClassMeta<?> cm) {
            this.attributeQueue.add(new QueueEntry(ns, name, cm));
        }

        private void serializeTo(Writer w) throws IOException {
            boolean b = false;
            for (Schema s : this.values()) {
                if (b) {
                    w.append('\u0000');
                }
                w.append(s.toString());
                b = true;
            }
        }
    }

    private static class QueueEntry {
        Namespace ns;
        String name;
        ClassMeta<?> cm;

        QueueEntry(Namespace ns, String name, ClassMeta<?> cm) {
            this.ns = ns;
            this.name = name;
            this.cm = cm;
        }
    }
}

