/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.UriContext;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.uon.UonSerializerSession;
import org.apache.juneau.urlencoding.UrlEncodingClassMeta;
import org.apache.juneau.urlencoding.UrlEncodingSerializerContext;

public class UrlEncodingSerializerSession
extends UonSerializerSession {
    private final boolean expandedParams;

    public UrlEncodingSerializerSession(UrlEncodingSerializerContext ctx, Boolean encode, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        super(ctx, encode, op, output, javaMethod, locale, timeZone, mediaType, uriContext);
        this.expandedParams = op == null || op.isEmpty() ? ctx.expandedParams : op.getBoolean("UrlEncoding.expandedParams", false);
    }

    public final boolean shouldUseExpandedParams(BeanPropertyMeta pMeta) {
        ClassMeta<?> cm = pMeta.getClassMeta();
        if (cm.isCollectionOrArray()) {
            if (this.expandedParams) {
                return true;
            }
            if (pMeta.getBeanMeta().getClassMeta().getExtendedMeta(UrlEncodingClassMeta.class).isExpandedParams()) {
                return true;
            }
        }
        return false;
    }

    public final boolean shouldUseExpandedParams(Object value) {
        if (value == null || !this.expandedParams) {
            return false;
        }
        ClassMeta<?> cm = this.getClassMetaForObject(value).getSerializedClassMeta();
        return cm.isCollectionOrArray() && this.expandedParams;
    }
}

