/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.UriContext;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.uon.UonSerializerContext;
import org.apache.juneau.uon.UonWriter;

public class UonSerializerSession
extends SerializerSession {
    private final boolean encodeChars;
    private final boolean addBeanTypeProperties;
    private final boolean plainTextParams;

    protected UonSerializerSession(UonSerializerContext ctx, Boolean encode, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        super(ctx, op, output, javaMethod, locale, timeZone, mediaType, uriContext);
        if (op == null || op.isEmpty()) {
            this.encodeChars = encode == null ? ctx.encodeChars : encode;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
            this.plainTextParams = ctx.plainTextParams;
        } else {
            this.encodeChars = encode == null ? op.getBoolean("UonSerializer.encodeChars", ctx.encodeChars) : encode;
            this.addBeanTypeProperties = op.getBoolean("MsgPackSerializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
            this.plainTextParams = op.getString("UonSerializer.paramFormat", "UON").equals("PLAINTEXT");
        }
    }

    public final boolean isEncodeChars() {
        return this.encodeChars;
    }

    @Override
    public final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    public boolean isPlainTextParams() {
        return this.plainTextParams;
    }

    @Override
    public final UonWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof UonWriter) {
            return (UonWriter)output;
        }
        return new UonWriter(this, super.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isEncodeChars(), this.isTrimStrings(), this.isPlainTextParams(), this.getUriResolver());
    }
}

