/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.uon.UonParserBuilder;
import org.apache.juneau.uon.UonParserContext;
import org.apache.juneau.uon.UonParserSession;
import org.apache.juneau.uon.UonReader;

@Consumes(value="text/uon")
public class UonParser
extends ReaderParser {
    public static final UonParser DEFAULT = new UonParser(PropertyStore.create());
    public static final UonParser DEFAULT_DECODING = new Decoding(PropertyStore.create());
    private static final AsciiSet escapedChars = new AsciiSet("~'\u0001\u0002");
    private static final char AMP = '\u0001';
    private static final char EQ = '\u0002';
    private final UonParserContext ctx = this.createContext(UonParserContext.class);
    private static final AsciiSet endCharsParam = new AsciiSet("\u0001");
    private static final AsciiSet endCharsNormal = new AsciiSet(",)\u0001");

    public UonParser(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public UonParserBuilder builder() {
        return new UonParserBuilder(this.propertyStore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T parseAnything(UonParserSession session, ClassMeta<T> eType, ParserReader r, Object outer, boolean isUrlParamValue, BeanPropertyMeta pMeta) throws Exception {
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<Object, Object> transform = eType.getPojoSwap();
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        Object o = null;
        int c = r.peekSkipWs();
        if (c == -1 || c == 1) {
            if (sType.isCollectionOrArray()) {
                o = sType.newInstance();
            } else if (sType.isString() || sType.isObject()) {
                o = "";
            } else if (sType.isPrimitive()) {
                o = sType.getPrimitiveDefault();
            }
        } else if (sType.isVoid()) {
            String string = UonParser.parseString(session, r, isUrlParamValue);
            if (string != null) {
                throw new ParseException(session, "Expected ''null'' for void value, but was ''{0}''.", string);
            }
        } else if (sType.isObject()) {
            if (c == 40) {
                ObjectMap objectMap = new ObjectMap(session);
                this.parseIntoMap(session, r, objectMap, this.string(), this.object(), pMeta);
                o = session.cast(objectMap, pMeta, eType);
            } else if (c == 64) {
                ObjectList objectList = new ObjectList(session);
                o = this.parseIntoCollection(session, r, objectList, sType, isUrlParamValue, pMeta);
            } else {
                String string = UonParser.parseString(session, r, isUrlParamValue);
                if (c != 39) {
                    if ("true".equals(string) || "false".equals(string)) {
                        o = Boolean.valueOf(string);
                    } else if (!"null".equals(string)) {
                        o = StringUtils.isNumeric(string) ? StringUtils.parseNumber(string, Number.class) : string;
                    }
                } else {
                    o = string;
                }
            }
        } else if (sType.isBoolean()) {
            o = UonParser.parseBoolean(session, r);
        } else if (sType.isCharSequence()) {
            o = UonParser.parseString(session, r, isUrlParamValue);
        } else if (sType.isChar()) {
            String string = UonParser.parseString(session, r, isUrlParamValue);
            o = string == null ? null : Character.valueOf(string.charAt(0));
        } else if (sType.isNumber()) {
            o = UonParser.parseNumber(session, r, sType.getInnerClass());
        } else if (sType.isMap()) {
            Map<String, Object> map = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(session);
            o = this.parseIntoMap(session, r, map, sType.getKeyType(), sType.getValueType(), pMeta);
        } else if (sType.isCollection()) {
            if (c == 40) {
                ObjectMap objectMap = new ObjectMap(session);
                this.parseIntoMap(session, r, objectMap, this.string(), this.object(), pMeta);
                if (objectMap.containsKey(session.getBeanTypePropertyName(sType))) {
                    o = session.cast(objectMap, pMeta, eType);
                } else {
                    Collection<Object> l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(session);
                    l.add(objectMap.cast(sType.getElementType()));
                    o = l;
                }
            } else {
                Collection<Object> collection = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(session);
                o = this.parseIntoCollection(session, r, collection, sType, isUrlParamValue, pMeta);
            }
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap<?> beanMap2 = session.newBeanMap(outer, sType.getInnerClass());
            beanMap2 = this.parseIntoBeanMap(session, r, beanMap2);
            o = beanMap2 == null ? null : beanMap2.getBean();
        } else if (sType.canCreateNewInstanceFromString(outer)) {
            String string = UonParser.parseString(session, r, isUrlParamValue);
            if (string != null) {
                o = sType.newInstanceFromString(outer, string);
            }
        } else if (sType.canCreateNewInstanceFromNumber(outer)) {
            o = sType.newInstanceFromNumber(session, outer, UonParser.parseNumber(session, r, sType.getNewInstanceFromNumberClass()));
        } else if (sType.isArray() || sType.isArgs()) {
            if (c == 40) {
                ObjectMap objectMap = new ObjectMap(session);
                this.parseIntoMap(session, r, objectMap, this.string(), this.object(), pMeta);
                if (objectMap.containsKey(session.getBeanTypePropertyName(sType))) {
                    o = session.cast(objectMap, pMeta, eType);
                } else {
                    ArrayList l = new ArrayList(1);
                    l.add(objectMap.cast(sType.getElementType()));
                    o = session.toArray(sType, l);
                }
            } else {
                ArrayList arrayList = (ArrayList)this.parseIntoCollection(session, r, new ArrayList(), sType, isUrlParamValue, pMeta);
                o = session.toArray(sType, arrayList);
            }
        } else if (c == 40) {
            ObjectMap objectMap = new ObjectMap(session);
            this.parseIntoMap(session, r, objectMap, this.string(), this.object(), pMeta);
            if (!objectMap.containsKey(session.getBeanTypePropertyName(sType))) throw new ParseException(session, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
            o = session.cast(objectMap, pMeta, eType);
        } else {
            if (c != 110) throw new ParseException(session, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
            r.read();
            UonParser.parseNull(session, r);
        }
        if (o == null && sType.isPrimitive()) {
            o = sType.getPrimitiveDefault();
        }
        if (transform != null && o != null) {
            o = transform.unswap(session, o, eType);
        }
        if (outer == null) return (T)o;
        this.setParent(eType, o, outer);
        return (T)o;
    }

    private <K, V> Map<K, V> parseIntoMap(UonParserSession session, ParserReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        int c;
        if (keyType == null) {
            keyType = this.string();
        }
        if ((c = r.read()) == -1 || c == 1) {
            return null;
        }
        if (c == 110) {
            return (Map)UonParser.parseNull(session, r);
        }
        if (c != 40) {
            throw new ParseException(session, "Expected '(' at beginning of object.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        Object currAttr = null;
        while (c != -1 && c != 1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == 41) {
                        return m;
                    }
                    if (Character.isWhitespace(c)) {
                        UonParser.skipSpace(r);
                    } else {
                        r.unread();
                        Object attr = UonParser.parseAttr(session, r, session.isDecodeChars());
                        currAttr = attr == null ? null : (Object)this.convertAttrToType(session, m, session.trim(attr.toString()), keyType);
                        state = 2;
                        c = 0;
                    }
                } else if (state == 2) {
                    if (c == 2 || c == 61) {
                        state = 3;
                    } else if (c == -1 || c == 44 || c == 41 || c == 1) {
                        if (currAttr == null) {
                            r.unread();
                            return null;
                        }
                        m.put(currAttr, null);
                        if (c == 41 || c == -1 || c == 1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    V value;
                    if (c == -1 || c == 44 || c == 41 || c == 1) {
                        value = this.convertAttrToType(session, m, "", valueType);
                        m.put(currAttr, value);
                        if (c == -1 || c == 41 || c == 1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        value = this.parseAnything(session, valueType, r.unread(), m, false, pMeta);
                        this.setName(valueType, value, currAttr);
                        m.put(currAttr, value);
                        state = 4;
                        c = 0;
                    }
                } else if (state == 4) {
                    if (c == 44) {
                        state = 1;
                    } else if (c == 41 || c == -1 || c == 1) {
                        return m;
                    }
                }
            }
            isInEscape = UonParser.isInEscape(c, r, isInEscape);
        }
        if (state == 1) {
            throw new ParseException(session, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException(session, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException(session, "Dangling '=' found in object entry", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException(session, "Could not find ')' marking end of object.", new Object[0]);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <E> Collection<E> parseIntoCollection(UonParserSession session, ParserReader r, Collection<E> l, ClassMeta<E> type, boolean isUrlParamValue, BeanPropertyMeta pMeta) throws Exception {
        boolean isInParens;
        int c = r.readSkipWs();
        if (c == -1 || c == 1) {
            return null;
        }
        if (c == 110) {
            return (Collection)UonParser.parseNull(session, r);
        }
        int argIndex = 0;
        boolean bl = isInParens = c == 64;
        if (!isInParens) {
            if (!isUrlParamValue) throw new ParseException(session, "Could not find '(' marking beginning of collection.", new Object[0]);
            r.unread();
        } else {
            r.read();
        }
        if (isInParens) {
            boolean S1 = true;
            int S2 = 2;
            int S3 = 3;
            int state = 1;
            while (c != -1 && c != 1) {
                c = r.read();
                if (state == 1 || state == 2) {
                    if (c == 41) {
                        if (state != 2) return l;
                        l.add(this.parseAnything(session, type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, false, pMeta));
                        r.read();
                        return l;
                    }
                    if (Character.isWhitespace(c)) {
                        UonParser.skipSpace(r);
                        continue;
                    }
                    l.add(this.parseAnything(session, type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, false, pMeta));
                    state = 3;
                    continue;
                }
                if (state != 3) continue;
                if (c == 44) {
                    state = 2;
                    continue;
                }
                if (c != 41) continue;
                return l;
            }
            if (state == 1 || state == 2) {
                throw new ParseException(session, "Could not find start of entry in array.", new Object[0]);
            }
            if (state != 3) return null;
            throw new ParseException(session, "Could not find end of entry in array.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int state = 1;
        while (c != -1 && c != 1) {
            c = r.read();
            if (state == 1) {
                if (Character.isWhitespace(c)) {
                    UonParser.skipSpace(r);
                    continue;
                }
                l.add(this.parseAnything(session, type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, false, pMeta));
                state = 2;
                continue;
            }
            if (state != 2) continue;
            if (c == 44) {
                state = 1;
                continue;
            }
            if (Character.isWhitespace(c)) {
                UonParser.skipSpace(r);
                continue;
            }
            if (c != 1 && c != -1) continue;
            r.unread();
            return l;
        }
        return null;
    }

    private <T> BeanMap<T> parseIntoBeanMap(UonParserSession session, ParserReader r, BeanMap<T> m) throws Exception {
        int c = r.readSkipWs();
        if (c == -1 || c == 1) {
            return null;
        }
        if (c == 110) {
            return (BeanMap)UonParser.parseNull(session, r);
        }
        if (c != 40) {
            throw new ParseException(session, "Expected '(' at beginning of object.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        String currAttr = "";
        int currAttrLine = -1;
        int currAttrCol = -1;
        while (c != -1 && c != 1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == 41 || c == -1 || c == 1) {
                        return m;
                    }
                    if (Character.isWhitespace(c)) {
                        UonParser.skipSpace(r);
                    } else {
                        r.unread();
                        currAttrLine = r.getLine();
                        currAttrCol = r.getColumn();
                        currAttr = UonParser.parseAttrName(session, r, session.isDecodeChars());
                        if (currAttr == null) {
                            return null;
                        }
                        state = 2;
                    }
                } else if (state == 2) {
                    if (c == 2 || c == 61) {
                        state = 3;
                    } else if (c == -1 || c == 44 || c == 41 || c == 1) {
                        m.put(currAttr, (Object)null);
                        if (c == 41 || c == -1 || c == 1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    BeanPropertyMeta pMeta;
                    if (c == -1 || c == 44 || c == 41 || c == 1) {
                        if (!currAttr.equals(session.getBeanTypePropertyName(m.getClassMeta()))) {
                            pMeta = m.getPropertyMeta(currAttr);
                            if (pMeta == null) {
                                session.onUnknownProperty(currAttr, m, currAttrLine, currAttrCol);
                            } else {
                                Object value = session.convertToType((Object)"", pMeta.getClassMeta());
                                pMeta.set(m, currAttr, value);
                            }
                        }
                        if (c == -1 || c == 41 || c == 1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        if (!currAttr.equals(session.getBeanTypePropertyName(m.getClassMeta()))) {
                            pMeta = m.getPropertyMeta(currAttr);
                            if (pMeta == null) {
                                session.onUnknownProperty(currAttr, m, currAttrLine, currAttrCol);
                                this.parseAnything(session, this.object(), r.unread(), m.getBean(false), false, null);
                            } else {
                                session.setCurrentProperty(pMeta);
                                ClassMeta<?> cm = pMeta.getClassMeta();
                                Object value = this.parseAnything(session, cm, r.unread(), m.getBean(false), false, pMeta);
                                this.setName(cm, value, currAttr);
                                pMeta.set(m, currAttr, value);
                                session.setCurrentProperty(null);
                            }
                        }
                        state = 4;
                    }
                } else if (state == 4) {
                    if (c == 44) {
                        state = 1;
                    } else if (c == 41 || c == -1 || c == 1) {
                        return m;
                    }
                }
            }
            isInEscape = UonParser.isInEscape(c, r, isInEscape);
        }
        if (state == 1) {
            throw new ParseException(session, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException(session, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException(session, "Could not find value following '=' on object.", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException(session, "Could not find ')' marking end of object.", new Object[0]);
        }
        return null;
    }

    private static Object parseNull(UonParserSession session, ParserReader r) throws Exception {
        String s = UonParser.parseString(session, r, false);
        if ("ull".equals(s)) {
            return null;
        }
        throw new ParseException(session, "Unexpected character sequence: ''{0}''", s);
    }

    protected static final Object parseAttr(UonParserSession session, ParserReader r, boolean encoded) throws Exception {
        String attr = UonParser.parseAttrName(session, r, encoded);
        return attr;
    }

    protected static String parseAttrName(UonParserSession session, ParserReader r, boolean encoded) throws Exception {
        int c = r.peekSkipWs();
        if (c == 39) {
            return UonParser.parsePString(session, r);
        }
        r.mark();
        boolean isInEscape = false;
        if (encoded) {
            while (c != -1) {
                c = r.read();
                if (!isInEscape) {
                    if (c == 1 || c == 2 || c == -1 || Character.isWhitespace(c)) {
                        String s;
                        if (c != -1) {
                            r.unread();
                        }
                        return "null".equals(s = r.getMarked()) ? null : s;
                    }
                } else if (c == 1) {
                    r.replace('&');
                } else if (c == 2) {
                    r.replace('=');
                }
                isInEscape = UonParser.isInEscape(c, r, isInEscape);
            }
        } else {
            while (c != -1) {
                c = r.read();
                if (!isInEscape && (c == 61 || c == -1 || Character.isWhitespace(c))) {
                    String s;
                    if (c != -1) {
                        r.unread();
                    }
                    return "null".equals(s = r.getMarked()) ? null : session.trim(s);
                }
                isInEscape = UonParser.isInEscape(c, r, isInEscape);
            }
        }
        throw new ParseException(session, "Unexpected condition.", new Object[0]);
    }

    private static final boolean isInEscape(int c, ParserReader r, boolean prevIsInEscape) throws Exception {
        if (c == 126 && !prevIsInEscape && escapedChars.contains(c = r.peek())) {
            r.delete();
            return true;
        }
        return false;
    }

    protected static String parseString(UonParserSession session, ParserReader r, boolean isUrlParamValue) throws Exception {
        AsciiSet endChars;
        int c = r.peekSkipWs();
        if (c == 39) {
            return UonParser.parsePString(session, r);
        }
        r.mark();
        boolean isInEscape = false;
        String s = null;
        AsciiSet asciiSet = endChars = isUrlParamValue ? endCharsParam : endCharsNormal;
        while (c != -1) {
            c = r.read();
            if (!isInEscape && endChars.contains(c)) {
                r.unread();
                c = -1;
            }
            if (c == -1) {
                s = r.getMarked();
            } else if (c == 2) {
                r.replace('=');
            } else if (Character.isWhitespace(c) && !isUrlParamValue) {
                s = r.getMarked(0, -1);
                UonParser.skipSpace(r);
                c = -1;
            }
            isInEscape = UonParser.isInEscape(c, r, isInEscape);
        }
        if (isUrlParamValue) {
            s = StringUtils.trim(s);
        }
        return "null".equals(s) ? null : session.trim(s);
    }

    static String parsePString(UonParserSession session, ParserReader r) throws Exception {
        r.read();
        r.mark();
        int c = 0;
        boolean isInEscape = false;
        while (c != -1) {
            c = r.read();
            if (!isInEscape && c == 39) {
                return session.trim(r.getMarked(0, -1));
            }
            if (c == 2) {
                r.replace('=');
            }
            isInEscape = UonParser.isInEscape(c, r, isInEscape);
        }
        throw new ParseException(session, "Unmatched parenthesis", new Object[0]);
    }

    private static Boolean parseBoolean(UonParserSession session, ParserReader r) throws Exception {
        String s = UonParser.parseString(session, r, false);
        if (s == null || s.equals("null")) {
            return null;
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new ParseException(session, "Unrecognized syntax for boolean.  ''{0}''.", s);
    }

    private static Number parseNumber(UonParserSession session, ParserReader r, Class<? extends Number> c) throws Exception {
        String s = UonParser.parseString(session, r, false);
        if (s == null) {
            return null;
        }
        return StringUtils.parseNumber(s, c);
    }

    private static void validateEnd(UonParserSession session, ParserReader r) throws Exception {
        int c;
        do {
            if ((c = r.read()) != -1) continue;
            return;
        } while (Character.isWhitespace(c));
        throw new ParseException(session, "Remainder after parse: ''{0}''.", Character.valueOf((char)c));
    }

    private static void skipSpace(ParserReader r) throws Exception {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (c > 2 && Character.isWhitespace(c)) continue;
            r.unread();
            return;
        }
    }

    protected final UonParserSession createParameterSession(Object input) {
        return new UonParserSession(this.ctx, input);
    }

    @Override
    public UonParserSession createSession(Object input, ObjectMap op, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new UonParserSession(this.ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        UonParserSession s = (UonParserSession)session;
        UonReader r = s.getReader();
        T o = this.parseAnything(s, type, r, s.getOuter(), true, null);
        UonParser.validateEnd(s, r);
        return o;
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        UonParserSession s = (UonParserSession)session;
        UonReader r = s.getReader();
        m = this.parseIntoMap(s, r, m, session.getClassMeta(keyType, new Type[0]), session.getClassMeta(valueType, new Type[0]), null);
        UonParser.validateEnd(s, r);
        return m;
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserSession session, Collection<E> c, Type elementType) throws Exception {
        UonParserSession s = (UonParserSession)session;
        UonReader r = s.getReader();
        c = this.parseIntoCollection(s, r, c, session.getClassMeta(elementType, new Type[0]), false, null);
        UonParser.validateEnd(s, r);
        return c;
    }

    public static class Decoding
    extends UonParser {
        public Decoding(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("UonParser.decodeChars", true);
        }
    }
}

