/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.UriResolver;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.transform.PojoSwap;

public class SerializerSession
extends BeanSession {
    private final int maxDepth;
    private final int initialDepth;
    private final int maxIndent;
    private final boolean detectRecursions;
    private final boolean ignoreRecursions;
    private final boolean useWhitespace;
    private final boolean addBeanTypeProperties;
    private final boolean trimNulls;
    private final boolean trimEmptyCollections;
    private final boolean trimEmptyMaps;
    private final boolean trimStrings;
    private final boolean sortCollections;
    private final boolean sortMaps;
    private final boolean abridged;
    private final char quoteChar;
    private final UriResolver uriResolver;
    public int indent;
    private final Map<Object, Object> set;
    private final LinkedList<StackElement> stack = new LinkedList();
    private boolean isBottom;
    private final Method javaMethod;
    private final Object output;
    private OutputStream outputStream;
    private Writer writer;
    private Writer flushOnlyWriter;
    private BeanPropertyMeta currentProperty;
    private ClassMeta<?> currentClass;
    private final SerializerListener listener;

    public SerializerSession(SerializerContext ctx, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        super(ctx, op, locale, timeZone, mediaType);
        Class<? extends SerializerListener> listenerClass;
        UriRelativity uriRelativity;
        UriResolution uriResolution;
        this.javaMethod = javaMethod;
        this.output = output;
        if (op == null || op.isEmpty()) {
            this.maxDepth = ctx.maxDepth;
            this.initialDepth = ctx.initialDepth;
            this.detectRecursions = ctx.detectRecursions;
            this.ignoreRecursions = ctx.ignoreRecursions;
            this.useWhitespace = ctx.useWhitespace;
            this.maxIndent = ctx.maxIndent;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
            this.trimNulls = ctx.trimNulls;
            this.trimEmptyCollections = ctx.trimEmptyCollections;
            this.trimEmptyMaps = ctx.trimEmptyMaps;
            this.trimStrings = ctx.trimStrings;
            this.quoteChar = ctx.quoteChar;
            this.sortCollections = ctx.sortCollections;
            this.sortMaps = ctx.sortMaps;
            this.abridged = ctx.abridged;
            uriResolution = ctx.uriResolution;
            uriRelativity = ctx.uriRelativity;
            listenerClass = ctx.listener;
        } else {
            this.maxDepth = op.getInt("Serializer.maxDepth", ctx.maxDepth);
            this.initialDepth = op.getInt("Serializer.initialDepth", ctx.initialDepth);
            this.detectRecursions = op.getBoolean("Serializer.detectRecursions", ctx.detectRecursions);
            this.ignoreRecursions = op.getBoolean("Serializer.ignoreRecursions", ctx.ignoreRecursions);
            this.useWhitespace = op.getBoolean("Serializer.useWhitespace", ctx.useWhitespace);
            this.maxIndent = op.getInt("Serializer.maxIndent", ctx.maxIndent);
            this.addBeanTypeProperties = op.getBoolean("Serializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
            this.trimNulls = op.getBoolean("Serializer.trimNullProperties", ctx.trimNulls);
            this.trimEmptyCollections = op.getBoolean("Serializer.trimEmptyLists", ctx.trimEmptyCollections);
            this.trimEmptyMaps = op.getBoolean("Serializer.trimEmptyMaps", ctx.trimEmptyMaps);
            this.trimStrings = op.getBoolean("Serializer.trimStrings", ctx.trimStrings);
            this.quoteChar = op.getString("Serializer.quoteChar", "" + ctx.quoteChar).charAt(0);
            this.sortCollections = op.getBoolean("Serializer.sortCollections", ctx.sortMaps);
            this.sortMaps = op.getBoolean("Serializer.sortMaps", ctx.sortMaps);
            this.abridged = op.getBoolean("Serializer.abridged", ctx.abridged);
            uriResolution = op.get(UriResolution.class, "Serializer.uriResolution", UriResolution.ROOT_RELATIVE);
            uriRelativity = op.get(UriRelativity.class, "Serializer.uriRelativity", UriRelativity.RESOURCE);
            listenerClass = op.get(Class.class, "Serializer.listener", ctx.listener);
        }
        this.uriResolver = new UriResolver(uriResolution, uriRelativity, uriContext == null ? ctx.uriContext : uriContext);
        this.listener = ClassUtils.newInstance(SerializerListener.class, listenerClass, new Object[0]);
        this.indent = this.initialDepth;
        this.set = this.detectRecursions || this.isDebug() ? new IdentityHashMap<Object, Object>() : Collections.emptyMap();
    }

    public OutputStream getOutputStream() throws Exception {
        if (this.output == null) {
            throw new SerializeException("Output cannot be null.", new Object[0]);
        }
        if (this.output instanceof OutputStream) {
            return (OutputStream)this.output;
        }
        if (this.output instanceof File) {
            if (this.outputStream == null) {
                this.outputStream = new BufferedOutputStream(new FileOutputStream((File)this.output));
            }
            return this.outputStream;
        }
        throw new SerializeException("Cannot convert object of type {0} to an OutputStream.", this.output.getClass().getName());
    }

    public Writer getWriter() throws Exception {
        if (this.output == null) {
            throw new SerializeException("Output cannot be null.", new Object[0]);
        }
        if (this.output instanceof Writer) {
            return (Writer)this.output;
        }
        if (this.output instanceof OutputStream) {
            if (this.flushOnlyWriter == null) {
                this.flushOnlyWriter = new OutputStreamWriter((OutputStream)this.output, IOUtils.UTF8);
            }
            return this.flushOnlyWriter;
        }
        if (this.output instanceof File) {
            if (this.writer == null) {
                this.writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream((File)this.output)));
            }
            return this.writer;
        }
        throw new SerializeException("Cannot convert object of type {0} to a Writer.", this.output.getClass().getName());
    }

    protected Object getOutput() {
        return this.output;
    }

    public void setCurrentProperty(BeanPropertyMeta currentProperty) {
        this.currentProperty = currentProperty;
    }

    public void setCurrentClass(ClassMeta<?> currentClass) {
        this.currentClass = currentClass;
    }

    public final Method getJavaMethod() {
        return this.javaMethod;
    }

    public final UriResolver getUriResolver() {
        return this.uriResolver;
    }

    public final int getMaxDepth() {
        return this.maxDepth;
    }

    public final int getInitialDepth() {
        return this.initialDepth;
    }

    public final boolean isDetectRecursions() {
        return this.detectRecursions;
    }

    public final boolean isIgnoreRecursions() {
        return this.ignoreRecursions;
    }

    public final boolean isUseWhitespace() {
        return this.useWhitespace;
    }

    public final int getMaxIndent() {
        return this.maxIndent;
    }

    public boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    public final char getQuoteChar() {
        return this.quoteChar;
    }

    public final boolean isTrimNulls() {
        return this.trimNulls;
    }

    public final boolean isTrimEmptyCollections() {
        return this.trimEmptyCollections;
    }

    public final boolean isTrimEmptyMaps() {
        return this.trimEmptyMaps;
    }

    public final boolean isTrimStrings() {
        return this.trimStrings;
    }

    public final boolean isSortCollections() {
        return this.sortCollections;
    }

    public final boolean isSortMaps() {
        return this.sortMaps;
    }

    public ClassMeta<?> push(String attrName, Object o, ClassMeta<?> eType) throws SerializeException {
        ClassMeta<?> cm;
        ++this.indent;
        this.isBottom = true;
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ClassMeta<?> classMeta = cm = eType != null && c == eType.getInnerClass() ? eType : this.getClassMeta(c);
        if (cm.isCharSequence() || cm.isNumber() || cm.isBoolean()) {
            return cm;
        }
        if (this.detectRecursions || this.isDebug()) {
            if (this.stack.size() > this.maxDepth) {
                return null;
            }
            if (this.willRecurse(attrName, o, cm)) {
                return null;
            }
            this.isBottom = false;
            this.stack.add(new StackElement(this.stack.size(), attrName, o, cm));
            if (this.isDebug()) {
                this.getLogger().info(this.getStack(false));
            }
            this.set.put(o, o);
        }
        return cm;
    }

    public boolean willRecurse(String attrName, Object o, ClassMeta<?> cm) throws SerializeException {
        if (!this.detectRecursions && !this.isDebug()) {
            return false;
        }
        if (!this.set.containsKey(o)) {
            return false;
        }
        if (this.ignoreRecursions && !this.isDebug()) {
            return true;
        }
        this.stack.add(new StackElement(this.stack.size(), attrName, o, cm));
        throw new SerializeException("Recursion occurred, stack={0}", this.getStack(true));
    }

    public void pop() {
        Object o;
        Object o2;
        --this.indent;
        if ((this.detectRecursions || this.isDebug()) && !this.isBottom && (o2 = this.set.remove(o = this.stack.removeLast().o)) == null) {
            this.onError(null, "Couldn't remove object of type ''{0}'' on attribute ''{1}'' from object stack.", o.getClass().getName(), this.stack);
        }
        this.isBottom = false;
    }

    public int getIndent() {
        return this.indent;
    }

    public void onBeanGetterException(BeanPropertyMeta p, Throwable t) {
        if (this.listener != null) {
            this.listener.onBeanGetterException(this, t, p);
        }
        String prefix = this.isDebug() ? this.getStack(false) + ": " : "";
        this.addWarning("{0}Could not call getValue() on property ''{1}'' of class ''{2}'', exception = {3}", prefix, p.getName(), p.getBeanMeta().getClassMeta(), t.getLocalizedMessage());
    }

    public final void onError(Throwable t, String msg, Object ... args) {
        if (this.listener != null) {
            this.listener.onError(this, t, StringUtils.format(msg, args));
        }
        super.addWarning(msg, args);
    }

    public final String trim(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (this.trimStrings) {
            s = s.trim();
        }
        return s;
    }

    public final Object generalize(Object o, ClassMeta<?> type) throws SerializeException {
        PojoSwap<?, ?> f;
        if (o == null) {
            return null;
        }
        PojoSwap<?, ?> pojoSwap = f = type == null || type.isObject() ? this.getClassMeta(o.getClass()).getPojoSwap() : type.getPojoSwap();
        if (f == null) {
            return o;
        }
        return f.swap(this, o);
    }

    public final boolean canIgnoreValue(ClassMeta<?> cm, String attrName, Object value) throws SerializeException {
        if (this.trimNulls && value == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (cm == null) {
            cm = this.object();
        }
        if (this.trimEmptyCollections) {
            if ((cm.isArray() || cm.isObject() && value.getClass().isArray()) && ((Object[])value).length == 0) {
                return true;
            }
            if ((cm.isCollection() || cm.isObject() && ClassUtils.isParentClass(Collection.class, value.getClass())) && ((Collection)value).isEmpty()) {
                return true;
            }
        }
        if (this.trimEmptyMaps && (cm.isMap() || cm.isObject() && ClassUtils.isParentClass(Map.class, value.getClass())) && ((Map)value).isEmpty()) {
            return true;
        }
        return this.trimNulls && this.willRecurse(attrName, value, cm);
    }

    public final <K, V> Map<K, V> sort(Map<K, V> m) {
        if (this.sortMaps && m != null && !m.isEmpty() && m.keySet().iterator().next() instanceof Comparable) {
            return new TreeMap<K, V>(m);
        }
        return m;
    }

    public final <E> Collection<E> sort(Collection<E> c) {
        if (this.sortCollections && c != null && !c.isEmpty() && c.iterator().next() instanceof Comparable) {
            return new TreeSet<E>(c);
        }
        return c;
    }

    public String resolveUri(Object uri) {
        return this.uriResolver.resolve(uri);
    }

    public String relativizeUri(Object relativeTo, Object uri) {
        return this.uriResolver.relativize(relativeTo, uri);
    }

    public String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o.getClass() == Class.class) {
            return ClassUtils.getReadableClassName((Class)o);
        }
        String s = o.toString();
        if (this.trimStrings) {
            s = s.trim();
        }
        return s;
    }

    @Override
    public boolean close() {
        if (super.close()) {
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                if (this.flushOnlyWriter != null) {
                    this.flushOnlyWriter.flush();
                }
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException e) {
                throw new BeanRuntimeException(e);
            }
            return true;
        }
        return false;
    }

    private String getStack(boolean full) {
        StringBuilder sb = new StringBuilder();
        for (StackElement e : this.stack) {
            if (full) {
                sb.append("\n\t");
                for (int i = 1; i < e.depth; ++i) {
                    sb.append("  ");
                }
                if (e.depth > 0) {
                    sb.append("->");
                }
                sb.append(e.toString(false));
                continue;
            }
            sb.append(" > ").append(e.toString(true));
        }
        return sb.toString();
    }

    public Map<String, Object> getLastLocation() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (this.currentClass != null) {
            m.put("currentClass", this.currentClass);
        }
        if (this.currentProperty != null) {
            m.put("currentProperty", this.currentProperty);
        }
        if (this.stack != null && !this.stack.isEmpty()) {
            m.put("stack", this.stack);
        }
        return m;
    }

    public BeanPropertyValue createBeanTypeNameProperty(BeanMap<?> m, String typeName) {
        BeanMeta<?> bm = m.getMeta();
        return new BeanPropertyValue(bm.getTypeProperty(), bm.getTypeProperty().getName(), typeName, null);
    }

    public String getBeanTypeName(ClassMeta<?> eType, ClassMeta<?> aType, BeanPropertyMeta pMeta) {
        if (eType == aType) {
            return null;
        }
        if (!this.isAddBeanTypeProperties()) {
            return null;
        }
        String eTypeTn = eType.getDictionaryName();
        String tn = aType.getDictionaryName();
        if (tn != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        BeanRegistry br = eType.getBeanRegistry();
        if (br != null && (tn = br.getTypeName(aType)) != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        BeanRegistry beanRegistry = br = pMeta == null ? null : pMeta.getBeanRegistry();
        if (br != null && (tn = br.getTypeName(aType)) != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        br = this.getBeanRegistry();
        if (br != null && (tn = br.getTypeName(aType)) != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        return null;
    }

    public ClassMeta<?> getExpectedRootType(Object o) {
        return this.abridged ? this.getClassMetaForObject(o) : this.object();
    }

    private static class StackElement {
        private int depth;
        private String name;
        private Object o;
        private ClassMeta<?> aType;

        private StackElement(int depth, String name, Object o, ClassMeta<?> aType) {
            this.depth = depth;
            this.name = name;
            this.o = o;
            this.aType = aType;
        }

        private String toString(boolean simple) {
            StringBuilder sb = new StringBuilder().append('[').append(this.depth).append(']');
            sb.append(StringUtils.isEmpty(this.name) ? "<noname>" : this.name).append(':');
            sb.append(this.aType.toString(simple));
            if (this.aType != this.aType.getSerializedClassMeta()) {
                sb.append('/').append(this.aType.getSerializedClassMeta().toString(simple));
            }
            return sb.toString();
        }
    }
}

