/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.CoreObject;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.serializer.SerializerSession;

public abstract class Serializer
extends CoreObject {
    private final MediaType[] mediaTypes;
    private final MediaType contentType;
    private final SerializerContext ctx = this.createContext(SerializerContext.class);

    Serializer(PropertyStore propertyStore) {
        super(propertyStore);
        Produces p = ReflectionUtils.getAnnotation(Produces.class, this.getClass());
        if (p == null) {
            throw new FormattedRuntimeException("Class ''{0}'' is missing the @Produces annotation", this.getClass());
        }
        String[] mt = StringUtils.split(p.value());
        this.mediaTypes = new MediaType[mt.length];
        for (int i = 0; i < mt.length; ++i) {
            this.mediaTypes[i] = MediaType.forString(mt[i]);
        }
        String ct = p.contentType().isEmpty() ? this.mediaTypes[0].toString() : p.contentType();
        this.contentType = ct.isEmpty() ? null : MediaType.forString(ct);
    }

    @Override
    public SerializerBuilder builder() {
        return new SerializerBuilder(this.propertyStore);
    }

    public abstract boolean isWriterSerializer();

    protected abstract void doSerialize(SerializerSession var1, Object var2) throws Exception;

    public abstract Object serialize(Object var1) throws SerializeException;

    public final void serialize(SerializerSession session, Object o) throws SerializeException {
        try {
            this.doSerialize(session, o);
        }
        catch (SerializeException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new SerializeException(session, "Stack overflow occurred.  This can occur when trying to serialize models containing loops.  It's recommended you use the SerializerContext.SERIALIZER_detectRecursions setting to help locate the loop.", new Object[0]).initCause(e);
        }
        catch (Exception e) {
            throw new SerializeException(session, e);
        }
        finally {
            session.close();
        }
    }

    public final void serialize(Object o, Object output) throws SerializeException {
        SerializerSession session = this.createSession(output);
        this.serialize(session, o);
    }

    public SerializerSession createSession(Object output, ObjectMap op, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        return new SerializerSession(this.ctx, op, output, javaMethod, locale, timeZone, mediaType, uriContext);
    }

    protected SerializerSession createSession(Object output) {
        return this.createSession(output, null, null, null, null, this.getPrimaryMediaType(), null);
    }

    protected static final List<Object> toList(Class<?> type, Object array) {
        Class<?> componentType = type.getComponentType();
        if (componentType.isPrimitive()) {
            int l = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(l);
            for (int i = 0; i < l; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }
        return Arrays.asList((Object[])array);
    }

    public MediaType[] getMediaTypes() {
        return this.mediaTypes;
    }

    public MediaType getPrimaryMediaType() {
        return this.mediaTypes == null || this.mediaTypes.length == 0 ? null : this.mediaTypes[0];
    }

    public ObjectMap getResponseHeaders(ObjectMap properties) {
        return ObjectMap.EMPTY_MAP;
    }

    public MediaType getResponseContentType() {
        return this.contentType;
    }
}

