/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.json.JsonParserContext;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSession;

public final class JsonParserSession
extends ParserSession {
    private ParserReader reader;

    public JsonParserSession(JsonParserContext ctx, ObjectMap op, Object input, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        super(ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
    }

    @Override
    public ParserReader getReader() throws Exception {
        if (this.reader == null) {
            Object input = this.getInput();
            if (input == null) {
                return null;
            }
            this.reader = input instanceof CharSequence ? new ParserReader((CharSequence)input) : new ParserReader(super.getReader());
        }
        return this.reader;
    }

    public final boolean isWhitespace(int cp) {
        if (this.isStrict()) {
            return cp <= 32 && (cp == 9 || cp == 10 || cp == 13 || cp == 32);
        }
        return Character.isWhitespace(cp);
    }

    public final boolean isCommentOrWhitespace(int cp) {
        if (cp == 47) {
            return true;
        }
        if (this.isStrict()) {
            return cp <= 32 && (cp == 9 || cp == 10 || cp == 13 || cp == 32);
        }
        return Character.isWhitespace(cp);
    }

    @Override
    public Map<String, Object> getLastLocation() {
        Map<String, Object> m = super.getLastLocation();
        if (this.reader != null) {
            m.put("line", this.reader.getLine());
            m.put("column", this.reader.getColumn());
        }
        return m;
    }
}

