/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserReader;

public final class StringUtils {
    private static final AsciiSet numberChars = new AsciiSet("-xX.+-#pP0123456789abcdefABCDEF");
    private static final AsciiSet firstNumberChars = new AsciiSet("+-.#0123456789");
    private static final AsciiSet octChars = new AsciiSet("01234567");
    private static final AsciiSet decChars = new AsciiSet("0123456789");
    private static final AsciiSet hexChars = new AsciiSet("0123456789abcdefABCDEF");
    private static final char[] base64m1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final AsciiSet unencodedChars = new AsciiSet("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()\\");
    private static final byte[] base64m2 = new byte[128];
    private static final Pattern fpRegex;
    private static final char[] HEX;

    public static Number parseNumber(ParserReader r, Class<? extends Number> type) throws Exception {
        return StringUtils.parseNumber(StringUtils.parseNumberString(r), type);
    }

    public static String parseNumberString(ParserReader r) throws Exception {
        r.mark();
        int c = 0;
        while ((c = r.read()) != -1) {
            if (numberChars.contains((char)c)) continue;
            r.unread();
            break;
        }
        return r.getMarked();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Number parseNumber(String s, Class<? extends Number> type) throws ParseException {
        if (s.isEmpty()) {
            s = "0";
        }
        if (type == null) {
            type = Number.class;
        }
        try {
            boolean isAutoDetect = type == Number.class;
            boolean isDecimal = false;
            if (isAutoDetect) {
                isDecimal = StringUtils.isDecimal(s);
                if (isDecimal) {
                    type = s.length() > 20 ? Double.class : (s.length() >= 10 ? Long.class : Integer.class);
                } else {
                    if (!StringUtils.isFloat(s)) {
                        throw new NumberFormatException(s);
                    }
                    type = Double.class;
                }
            }
            if (type == Double.class || type == Double.TYPE) {
                Double d = Double.valueOf(s);
                Float f = Float.valueOf(s);
                if (isAutoDetect && !isDecimal && d.toString().equals(f.toString())) {
                    return f;
                }
                return d;
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf(s);
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(s);
            }
            if (type == Long.class || type == Long.TYPE || type == AtomicLong.class) {
                try {
                    Long l = Long.decode(s);
                    if (type == AtomicLong.class) {
                        return new AtomicLong(l);
                    }
                    if (isAutoDetect && l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                        return l.intValue();
                    }
                    return l;
                }
                catch (NumberFormatException e) {
                    if (isAutoDetect) {
                        return Double.valueOf(s);
                    }
                    throw e;
                }
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return Integer.decode(s);
            }
            if (type == Short.class || type == Short.TYPE) {
                return Short.decode(s);
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return Byte.decode(s);
            }
            if (type == BigInteger.class) {
                return new BigInteger(s);
            }
            if (type == AtomicInteger.class) {
                return new AtomicInteger(Integer.decode(s));
            }
            throw new ParseException("Unsupported Number type: {0}", type.getName());
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid number: ''{0}'', class=''{1}''", s, type.getSimpleName()).initCause(e);
        }
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (!StringUtils.isFirstNumberChar(s.charAt(0))) {
            return false;
        }
        return StringUtils.isDecimal(s) || StringUtils.isFloat(s);
    }

    public static boolean isFirstNumberChar(char c) {
        return firstNumberChars.contains(c);
    }

    public static boolean isFloat(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (!firstNumberChars.contains(s.charAt(0))) {
            return s.equals("NaN") || s.equals("Infinity");
        }
        int i = 0;
        int length = s.length();
        char c = s.charAt(0);
        if (c == '+' || c == '-') {
            ++i;
        }
        if (i == length) {
            return false;
        }
        if ((c = s.charAt(i++)) == '.' || decChars.contains(c)) {
            return fpRegex.matcher(s).matches();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDecimal(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (!firstNumberChars.contains(s.charAt(0))) {
            return false;
        }
        int i = 0;
        int length = s.length();
        char c = s.charAt(0);
        boolean isPrefixed = false;
        if (c == '+' || c == '-') {
            isPrefixed = true;
            ++i;
        }
        if (i == length) {
            return false;
        }
        if ((c = s.charAt(i++)) == '0' && length > (isPrefixed ? 2 : 1)) {
            if ((c = s.charAt(i++)) == 'x' || c == 'X') {
                for (int j = i; j < length; ++j) {
                    if (hexChars.contains(s.charAt(j))) continue;
                    return false;
                }
                return true;
            } else {
                if (!octChars.contains(c)) return false;
                for (int j = i; j < length; ++j) {
                    if (octChars.contains(s.charAt(j))) continue;
                    return false;
                }
            }
            return true;
        } else if (c == '#') {
            for (int j = i; j < length; ++j) {
                if (hexChars.contains(s.charAt(j))) continue;
                return false;
            }
            return true;
        } else {
            if (!decChars.contains(c)) return false;
            for (int j = i; j < length; ++j) {
                if (decChars.contains(s.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        return sw.toString();
    }

    public static String join(Object[] tokens, String separator) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public static String join(int[] tokens, String d) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public static String join(Collection<?> tokens, String d) {
        if (tokens == null) {
            return null;
        }
        return StringUtils.join(tokens, d, new StringBuilder()).toString();
    }

    public static StringBuilder join(Collection<?> tokens, String d, StringBuilder sb) {
        if (tokens == null) {
            return sb;
        }
        Iterator<?> iter = tokens.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(d);
        }
        return sb;
    }

    public static String join(Object[] tokens, char d) {
        if (tokens == null) {
            return null;
        }
        return StringUtils.join(tokens, d, new StringBuilder()).toString();
    }

    public static StringBuilder join(Object[] tokens, char d, StringBuilder sb) {
        if (tokens == null) {
            return sb;
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(tokens[i]);
        }
        return sb;
    }

    public static String join(int[] tokens, char d) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public static String join(Collection<?> tokens, char d) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = tokens.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(d);
        }
        return sb.toString();
    }

    public static String[] split(String s) {
        return StringUtils.split(s, ',');
    }

    public static String[] split(String s, char c) {
        char[] unEscapeChars = new char[]{'\\', c};
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return new String[0];
        }
        if (s.indexOf(c) == -1) {
            return new String[]{s};
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == '\\') {
                ++escapeCount;
            } else if (sArray[i] == c && escapeCount % 2 == 0) {
                String s2 = new String(sArray, x1, i - x1);
                String s3 = StringUtils.unEscapeChars(s2, unEscapeChars);
                l.add(s3.trim());
                x1 = i + 1;
            }
            if (sArray[i] == '\\') continue;
            escapeCount = 0;
        }
        String s2 = new String(sArray, x1, sArray.length - x1);
        String s3 = StringUtils.unEscapeChars(s2, unEscapeChars);
        l.add(s3.trim());
        return l.toArray(new String[l.size()]);
    }

    public static String[] split(String[] s, char c) {
        if (s == null) {
            return null;
        }
        LinkedList<String> l = new LinkedList<String>();
        for (String ss : s) {
            if (ss == null || ss.indexOf(c) == -1) {
                l.add(ss);
                continue;
            }
            l.addAll(Arrays.asList(StringUtils.split(ss, c)));
        }
        return l.toArray(new String[l.size()]);
    }

    public static Map<String, String> splitMap(String s, char delim, char eq, boolean trim) {
        char[] unEscapeChars = new char[]{'\\', delim, eq};
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        int S1 = 1;
        int S2 = 2;
        int state = S1;
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        String key = null;
        for (int i = 0; i < sArray.length + 1; ++i) {
            char c;
            char c2 = c = i == sArray.length ? delim : sArray[i];
            if (c == '\\') {
                ++escapeCount;
            }
            if (escapeCount % 2 == 0) {
                if (state == S1) {
                    if (c == eq) {
                        key = s.substring(x1, i);
                        if (trim) {
                            key = StringUtils.trim(key);
                        }
                        key = StringUtils.unEscapeChars(key, unEscapeChars);
                        state = S2;
                        x1 = i + 1;
                    } else if (c == delim) {
                        key = s.substring(x1, i);
                        if (trim) {
                            key = StringUtils.trim(key);
                        }
                        key = StringUtils.unEscapeChars(key, unEscapeChars);
                        m.put(key, "");
                        state = S1;
                        x1 = i + 1;
                    }
                } else if (state == S2 && c == delim) {
                    String val = s.substring(x1, i);
                    if (trim) {
                        val = StringUtils.trim(val);
                    }
                    val = StringUtils.unEscapeChars(val, unEscapeChars);
                    m.put(key, val);
                    key = null;
                    x1 = i + 1;
                    state = S1;
                }
            }
            if (c == '\\') continue;
            escapeCount = 0;
        }
        return m;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isEmpty(Object s) {
        return s == null || s.toString().isEmpty();
    }

    public static String nullIfEmpty(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        return s;
    }

    public static String emptyIfNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String unEscapeChars(String s, char[] toEscape) {
        return StringUtils.unEscapeChars(s, toEscape, '\\');
    }

    public static String unEscapeChars(String s, char[] toEscape, char escapeChar) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0 || toEscape == null || toEscape.length == 0 || escapeChar == '\u0000') {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] sArray = s.toCharArray();
        for (int i = 0; i < sArray.length; ++i) {
            char c = sArray[i];
            if (c == escapeChar && i + 1 != sArray.length) {
                char c2 = sArray[i + 1];
                boolean isOneOf = false;
                for (int j = 0; j < toEscape.length && !isOneOf; ++j) {
                    isOneOf = c2 == toEscape[j];
                }
                if (isOneOf) {
                    ++i;
                } else if (c2 == escapeChar) {
                    sb.append(escapeChar);
                    ++i;
                }
            }
            sb.append(sArray[i]);
        }
        return sb.toString();
    }

    public static String decodeHex(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c < ' ' || c > '~') {
                sb.append("[" + Integer.toHexString(c) + "]");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean startsWith(String s, char c) {
        int i;
        if (s != null && (i = s.length()) > 0) {
            return s.charAt(0) == c;
        }
        return false;
    }

    public static boolean endsWith(String s, char c) {
        int i;
        if (s != null && (i = s.length()) > 0) {
            return s.charAt(i - 1) == c;
        }
        return false;
    }

    public static boolean endsWith(String s, char ... c) {
        int i;
        if (s != null && (i = s.length()) > 0) {
            char c2 = s.charAt(i - 1);
            for (char cc : c) {
                if (c2 != cc) continue;
                return true;
            }
        }
        return false;
    }

    public static final char[] toHex(int num) {
        char[] n = new char[4];
        int a = num % 16;
        n[3] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        int base = 16;
        for (int i = 1; i < 4; ++i) {
            a = num / base % 16;
            base <<= 4;
            n[3 - i] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        }
        return n;
    }

    public static boolean isEquals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static String base64EncodeToString(String in) {
        if (in == null) {
            return null;
        }
        return StringUtils.base64Encode(in.getBytes(IOUtils.UTF8));
    }

    public static String base64Encode(byte[] in) {
        int outLength = (in.length * 4 + 2) / 3;
        char[] out = new char[(in.length + 2) / 3 * 4];
        int iIn = 0;
        int iOut = 0;
        while (iIn < in.length) {
            int i0 = in[iIn++] & 0xFF;
            int i1 = iIn < in.length ? in[iIn++] & 0xFF : 0;
            int i2 = iIn < in.length ? in[iIn++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[iOut++] = base64m1[o0];
            out[iOut++] = base64m1[o1];
            out[iOut] = iOut < outLength ? base64m1[o2] : 61;
            int n = ++iOut < outLength ? base64m1[o3] : 61;
            out[iOut] = n;
            ++iOut;
        }
        return new String(out);
    }

    public static String base64DecodeToString(String in) {
        byte[] b = StringUtils.base64Decode(in);
        if (b == null) {
            return null;
        }
        return new String(b, IOUtils.UTF8);
    }

    public static byte[] base64Decode(String in) {
        int inLength;
        if (in == null) {
            return null;
        }
        byte[] bIn = in.getBytes(IOUtils.UTF8);
        if (bIn.length % 4 != 0) {
            ThrowableUtils.illegalArg("Invalid BASE64 string length.  Must be multiple of 4.", new Object[0]);
        }
        for (inLength = bIn.length; inLength > 0 && bIn[inLength - 1] == 61; --inLength) {
        }
        int outLength = inLength * 3 / 4;
        byte[] out = new byte[outLength];
        int iIn = 0;
        int iOut = 0;
        while (iIn < inLength) {
            byte i0 = bIn[iIn++];
            byte i1 = bIn[iIn++];
            int i2 = iIn < inLength ? bIn[iIn++] : 65;
            int i3 = iIn < inLength ? bIn[iIn++] : 65;
            byte b0 = base64m2[i0];
            byte b1 = base64m2[i1];
            byte b2 = base64m2[i2];
            byte b3 = base64m2[i3];
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[iOut++] = (byte)o0;
            if (iOut < outLength) {
                out[iOut++] = (byte)o1;
            }
            if (iOut >= outLength) continue;
            out[iOut++] = (byte)o2;
        }
        return out;
    }

    public static String generateUUID(int numchars) {
        Random r = new Random();
        StringBuilder sb = new StringBuilder(numchars);
        for (int i = 0; i < numchars; ++i) {
            int c = r.nextInt(36) + 97;
            if (c > 122) {
                c -= 75;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static Date parseISO8601Date(String date) throws IllegalArgumentException {
        if (StringUtils.isEmpty(date)) {
            return null;
        }
        if ((date = date.trim().replace(' ', 'T')).indexOf(44) != -1) {
            date = date.substring(0, date.indexOf(44));
        }
        if (date.matches("\\d{4}")) {
            date = date + "-01-01T00:00:00";
        } else if (date.matches("\\d{4}\\-\\d{2}")) {
            date = date + "-01T00:00:00";
        } else if (date.matches("\\d{4}\\-\\d{2}\\-\\d{2}")) {
            date = date + "T00:00:00";
        } else if (date.matches("\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}")) {
            date = date + ":00:00";
        } else if (date.matches("\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}\\:\\d{2}")) {
            date = date + ":00";
        }
        return DatatypeConverter.parseDateTime((String)date).getTime();
    }

    public static String replaceVars(String s, Map<String, Object> m) {
        if (s.indexOf(123) == -1) {
            return s;
        }
        int S1 = 1;
        int S2 = 2;
        int state = S1;
        boolean hasInternalVar = false;
        int x = 0;
        int depth = 0;
        int length = s.length();
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c == '{') {
                    state = S2;
                    x = i;
                    continue;
                }
                out.append(c);
                continue;
            }
            if (c == '{') {
                ++depth;
                hasInternalVar = true;
                continue;
            }
            if (c != '}') continue;
            if (depth > 0) {
                --depth;
                continue;
            }
            String key = s.substring(x + 1, i);
            key = hasInternalVar ? StringUtils.replaceVars(key, m) : key;
            hasInternalVar = false;
            if (!m.containsKey(key)) {
                out.append('{').append(key).append('}');
            } else {
                String v;
                Object val = m.get(key);
                if (val == null) {
                    val = "";
                }
                if ((v = val.toString()).indexOf(123) != -1) {
                    v = StringUtils.replaceVars(v, m);
                }
                out.append(v);
            }
            state = 1;
        }
        return out.toString();
    }

    public static boolean pathStartsWith(String path, String pathPrefix) {
        if (path == null || pathPrefix == null) {
            return false;
        }
        if (path.startsWith(pathPrefix)) {
            return path.length() == pathPrefix.length() || path.charAt(pathPrefix.length()) == '/';
        }
        return false;
    }

    public static boolean pathStartsWith(String path, String[] pathPrefixes) {
        for (String p : pathPrefixes) {
            if (!StringUtils.pathStartsWith(path, p)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeSequences(String s) {
        if (s.indexOf(92) == -1) {
            return s;
        }
        Pattern p = Pattern.compile("\\\\u(\\p{XDigit}{4})");
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer(s.length());
        while (m.find()) {
            String ch = String.valueOf((char)Integer.parseInt(m.group(1), 16));
            m.appendReplacement(sb, Matcher.quoteReplacement(ch));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String getField(int fieldNum, String s, char delim) {
        return StringUtils.getField(fieldNum, s, delim, "");
    }

    public static String getField(int fieldNum, String s, char delim, String def) {
        if (s == null || fieldNum < 0) {
            return def;
        }
        int start = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == delim && --fieldNum == 0) {
                start = i + 1;
            }
            if (fieldNum >= 0) continue;
            return s.substring(start, i);
        }
        if (start == 0) {
            return def;
        }
        return s.substring(start);
    }

    public static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public static String fromHexToUTF8(String hex) {
        ByteBuffer buff = ByteBuffer.allocate(hex.length() / 2);
        for (int i = 0; i < hex.length(); i += 2) {
            buff.put((byte)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        buff.rewind();
        Charset cs = Charset.forName("UTF-8");
        return cs.decode(buff).toString();
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            sb.append(HEX[v >>> 4]).append(HEX[v & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] fromHex(String hex) {
        ByteBuffer buff = ByteBuffer.allocate(hex.length() / 2);
        for (int i = 0; i < hex.length(); i += 2) {
            buff.put((byte)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        buff.rewind();
        return buff.array();
    }

    public static String repeat(int count, String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(pattern);
        }
        return sb.toString();
    }

    public static String trimStart(String s) {
        if (s != null) {
            while (s.length() > 0 && Character.isWhitespace(s.charAt(0))) {
                s = s.substring(1);
            }
        }
        return s;
    }

    public static String trimEnd(String s) {
        if (s != null) {
            while (s.length() > 0 && Character.isWhitespace(s.charAt(s.length() - 1))) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static boolean isOneOf(String s, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (!StringUtils.isEquals(s, values[i])) continue;
            return true;
        }
        return false;
    }

    public static String trimSlashes(String s) {
        if (s == null) {
            return null;
        }
        while (StringUtils.endsWith(s, '/')) {
            s = s.substring(0, s.length() - 1);
        }
        while (s.length() > 0 && s.charAt(0) == '/') {
            s = s.substring(1);
        }
        return s;
    }

    public static String trimTrailingSlashes(String s) {
        if (s == null) {
            return null;
        }
        while (StringUtils.endsWith(s, '/')) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static StringBuffer trimTrailingSlashes(StringBuffer s) {
        if (s == null) {
            return null;
        }
        while (s.length() > 0 && s.charAt(s.length() - 1) == '/') {
            s.setLength(s.length() - 1);
        }
        return s;
    }

    public static String urlDecode(String s) {
        if (s == null) {
            return s;
        }
        boolean needsDecode = false;
        for (int i = 0; i < s.length() && !needsDecode; ++i) {
            char c = s.charAt(i);
            if (c != '+' && c != '%') continue;
            needsDecode = true;
        }
        if (needsDecode) {
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        boolean needsEncode = false;
        for (int i = 0; i < s.length() && !needsEncode; needsEncode |= !unencodedChars.contains(s.charAt(i)), ++i) {
        }
        if (needsEncode) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    public static char firstNonWhitespaceChar(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return s.charAt(i);
            }
        }
        return '\u0000';
    }

    public static char charAt(String s, int i) {
        if (s == null) {
            return '\u0000';
        }
        if (i < 0 || i >= s.length()) {
            return '\u0000';
        }
        return s.charAt(i);
    }

    public static boolean isAbsoluteUri(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int state = S1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c >= 'a' && c <= 'z') {
                    state = S2;
                    continue;
                }
                return false;
            }
            if (state == S2) {
                if (c == ':') {
                    state = S3;
                    continue;
                }
                if (c >= 'a' && c <= 'z') continue;
                return false;
            }
            if (state == S3) {
                if (c == '/') {
                    state = S4;
                    continue;
                }
                return false;
            }
            if (state == S4) {
                if (c == '/') {
                    state = S5;
                    continue;
                }
                return false;
            }
            if (state != S5) continue;
            return true;
        }
        return false;
    }

    public static boolean isUri(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int state = S1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c >= 'a' && c <= 'z') {
                    state = S2;
                    continue;
                }
                return false;
            }
            if (state == S2) {
                if (c >= 'a' && c <= 'z') {
                    state = S3;
                    continue;
                }
                return false;
            }
            if (state == S3) {
                if (c == ':') {
                    state = S4;
                    continue;
                }
                if (c >= 'a' && c <= 'z') continue;
                return false;
            }
            if (state != S4) continue;
            return c == '/';
        }
        return false;
    }

    public static String getAuthorityUri(String s) {
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int S6 = 6;
        int state = S1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c >= 'a' && c <= 'z') {
                    state = S2;
                    continue;
                }
                return s;
            }
            if (state == S2) {
                if (c == ':') {
                    state = S3;
                    continue;
                }
                if (c >= 'a' && c <= 'z') continue;
                return s;
            }
            if (state == S3) {
                if (c == '/') {
                    state = S4;
                    continue;
                }
                return s;
            }
            if (state == S4) {
                if (c == '/') {
                    state = S5;
                    continue;
                }
                return s;
            }
            if (state == S5) {
                if (c != '/') {
                    state = S6;
                    continue;
                }
                return s;
            }
            if (state != S6 || c != '/') continue;
            return s.substring(0, i);
        }
        return s;
    }

    public static URI toURI(Object o) {
        if (o == null || o instanceof URI) {
            return (URI)o;
        }
        try {
            return new URI(o.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String firstNonEmpty(String ... s) {
        for (String ss : s) {
            if (StringUtils.isEmpty(ss)) continue;
            return ss;
        }
        return null;
    }

    public static int indexOf(String s, char ... c) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            for (char cc : c) {
                if (c2 != cc) continue;
                return i;
            }
        }
        return -1;
    }

    public static String format(String pattern, Object ... args) {
        if (args == null || args.length == 0) {
            return pattern;
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = StringUtils.convertToReadable(args[i]);
        }
        return MessageFormat.format(pattern, args);
    }

    private static Object convertToReadable(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClassMeta) {
            return ((ClassMeta)o).getReadableName();
        }
        ClassMeta<Object> cm = BeanContext.DEFAULT.getClassMetaForObject(o);
        if (cm.isMapOrBean() || cm.isCollectionOrArray()) {
            return JsonSerializer.DEFAULT_LAX.toString(o);
        }
        if (cm.isClass()) {
            return ((Class)o).getName();
        }
        if (cm.isMethod()) {
            return ((Method)o).toGenericString();
        }
        return o.toString();
    }

    static {
        for (int i = 0; i < 64; ++i) {
            StringUtils.base64m2[StringUtils.base64m1[i]] = (byte)i;
        }
        fpRegex = Pattern.compile("[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");
        HEX = "0123456789ABCDEF".toCharArray();
    }
}

