/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.ref.SoftReference;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.juneau.internal.StringUtils;

public final class DateUtils {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final String[] DEFAULT_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;
    private static final TimeZone GMT;

    public static Date parseDate(String dateValue) {
        return DateUtils.parseDate(dateValue, null, null);
    }

    public static Date parseDate(String dateValue, String[] dateFormats) {
        return DateUtils.parseDate(dateValue, dateFormats, null);
    }

    public static Date parseDate(String dateValue, String[] dateFormats, Date startDate) {
        String[] localDateFormats = dateFormats != null ? dateFormats : DEFAULT_PATTERNS;
        Date localStartDate = startDate != null ? startDate : DEFAULT_TWO_DIGIT_YEAR_START;
        String v = dateValue;
        if (v.length() > 1 && v.startsWith("'") && v.endsWith("'")) {
            v = v.substring(1, v.length() - 1);
        }
        for (String dateFormat : localDateFormats) {
            SimpleDateFormat dateParser = DateFormatHolder.formatFor(dateFormat);
            dateParser.set2DigitYearStart(localStartDate);
            ParsePosition pos = new ParsePosition(0);
            Date result = dateParser.parse(v, pos);
            if (pos.getIndex() == 0) continue;
            return result;
        }
        return null;
    }

    public static Calendar parseISO8601Calendar(String s) {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        return DatatypeConverter.parseDateTime((String)DateUtils.toValidISO8601DT(s));
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat formatter = DateFormatHolder.formatFor(pattern);
        return formatter.format(date);
    }

    public static void clearThreadLocal() {
        DateFormatHolder.clearThreadLocal();
    }

    public static final String toValidISO8601DT(String in) {
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int S6 = 6;
        int state = 1;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (state == 1) {
                if (c != '-') continue;
                state = 2;
                continue;
            }
            if (state == 2) {
                if (c != '-') continue;
                state = 3;
                continue;
            }
            if (state == 3) {
                if (c != 'T') continue;
                state = 4;
                continue;
            }
            if (state == 4) {
                if (c != ':') continue;
                state = 5;
                continue;
            }
            if (state != 5 || c != ':') continue;
            state = 6;
        }
        switch (state) {
            case 1: {
                return in + "-01-01T00:00:00";
            }
            case 2: {
                return in + "-01T00:00:00";
            }
            case 3: {
                return in + "T00:00:00";
            }
            case 4: {
                return in + ":00:00";
            }
            case 5: {
                return in + ":00";
            }
        }
        return in;
    }

    static {
        GMT = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
    }

    static final class DateFormatHolder {
        private static final ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>> THREADLOCAL_FORMATS = new ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>>(){

            @Override
            protected SoftReference<Map<String, SimpleDateFormat>> initialValue() {
                return new SoftReference<Map<String, SimpleDateFormat>>(new HashMap());
            }
        };

        DateFormatHolder() {
        }

        public static SimpleDateFormat formatFor(String pattern) {
            SimpleDateFormat format;
            SoftReference<Map<String, SimpleDateFormat>> ref = THREADLOCAL_FORMATS.get();
            Map<String, SimpleDateFormat> formats = ref.get();
            if (formats == null) {
                formats = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATS.set(new SoftReference<Map<String, SimpleDateFormat>>(formats));
            }
            if ((format = formats.get(pattern)) == null) {
                format = new SimpleDateFormat(pattern, Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                formats.put(pattern, format);
            }
            return format;
        }

        public static void clearThreadLocal() {
            THREADLOCAL_FORMATS.remove();
        }
    }
}

