/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import org.apache.juneau.http.Constants;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.Cache;

public class ContentType
extends MediaType {
    private static Cache<String, ContentType> cache = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);

    public static ContentType forString(String value) {
        if (value == null) {
            return null;
        }
        ContentType ct = cache.get(value);
        if (ct == null) {
            ct = cache.put(value, new ContentType(value));
        }
        return ct;
    }

    private ContentType(String s) {
        super(s);
    }

    public int findMatch(MediaType[] mediaTypes) {
        int matchQuant = 0;
        int matchIndex = -1;
        for (int i = 0; i < mediaTypes.length; ++i) {
            MediaType mt = mediaTypes[i];
            int matchQuant2 = mt.match(this);
            if (matchQuant2 <= matchQuant) continue;
            matchIndex = i;
        }
        return matchIndex;
    }
}

