/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.UriContext;
import org.apache.juneau.html.HtmlSerializerContext;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlUtils;

public class HtmlSerializerSession
extends XmlSerializerSession {
    private final AnchorText anchorText;
    private final boolean detectLinksInStrings;
    private final boolean lookForLabelParameters;
    private final boolean addKeyValueTableHeaders;
    private final boolean addBeanTypeProperties;
    private final Pattern urlPattern = Pattern.compile("http[s]?\\:\\/\\/.*");
    private final Pattern labelPattern;

    protected HtmlSerializerSession(HtmlSerializerContext ctx, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        super(ctx, op, output, javaMethod, locale, timeZone, mediaType, uriContext);
        String labelParameter;
        if (op == null || op.isEmpty()) {
            this.anchorText = Enum.valueOf(AnchorText.class, ctx.uriAnchorText);
            this.detectLinksInStrings = ctx.detectLinksInStrings;
            this.lookForLabelParameters = ctx.lookForLabelParameters;
            labelParameter = ctx.labelParameter;
            this.addKeyValueTableHeaders = ctx.addKeyValueTableHeaders;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
        } else {
            this.anchorText = Enum.valueOf(AnchorText.class, op.getString("HtmlSerializer.uriAnchorText", ctx.uriAnchorText));
            this.detectLinksInStrings = op.getBoolean("HtmlSerializer.detectLinksInStrings", ctx.detectLinksInStrings);
            this.lookForLabelParameters = op.getBoolean("HtmlSerializer.lookForLabelParameters", ctx.lookForLabelParameters);
            labelParameter = op.getString("HtmlSerializer.labelParameter", ctx.labelParameter);
            this.addKeyValueTableHeaders = op.getBoolean("HtmlSerializer.addKeyValueTableHeaders", ctx.addKeyValueTableHeaders);
            this.addBeanTypeProperties = op.getBoolean("MsgPackSerializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
        }
        this.labelPattern = Pattern.compile("[\\?\\&]" + Pattern.quote(labelParameter) + "=([^\\&]*)");
    }

    @Override
    public HtmlWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof HtmlWriter) {
            return (HtmlWriter)output;
        }
        return new HtmlWriter(super.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isTrimStrings(), this.getQuoteChar(), this.getUriResolver());
    }

    public boolean isUri(ClassMeta<?> cm, BeanPropertyMeta pMeta, Object o) {
        if (cm.isUri()) {
            return true;
        }
        if (pMeta != null && pMeta.isUri()) {
            return true;
        }
        return this.detectLinksInStrings && o instanceof CharSequence && this.urlPattern.matcher(o.toString()).matches();
    }

    public String getAnchorText(BeanPropertyMeta pMeta, Object o) {
        Matcher m;
        String s = o.toString();
        if (this.lookForLabelParameters && (m = this.labelPattern.matcher(s)).find()) {
            return XmlUtils.urlDecode(m.group(1));
        }
        switch (this.anchorText) {
            case LAST_TOKEN: {
                s = this.resolveUri(s);
                if (s.indexOf(47) != -1) {
                    s = s.substring(s.lastIndexOf(47) + 1);
                }
                if (s.indexOf(63) != -1) {
                    s = s.substring(0, s.indexOf(63));
                }
                if (s.indexOf(35) != -1) {
                    s = s.substring(0, s.indexOf(35));
                }
                if (s.isEmpty()) {
                    s = "/";
                }
                return XmlUtils.urlDecode(s);
            }
            case URI_ANCHOR: {
                if (s.indexOf(35) != -1) {
                    s = s.substring(s.lastIndexOf(35) + 1);
                }
                return XmlUtils.urlDecode(s);
            }
            case PROPERTY_NAME: {
                return pMeta == null ? s : pMeta.getName();
            }
            case URI: {
                return this.resolveUri(s);
            }
            case CONTEXT_RELATIVE: {
                return this.relativizeUri("context:/", s);
            }
            case SERVLET_RELATIVE: {
                return this.relativizeUri("servlet:/", s);
            }
            case PATH_RELATIVE: {
                return this.relativizeUri("request:/", s);
            }
        }
        return s;
    }

    public final boolean isAddKeyValueTableHeaders() {
        return this.addKeyValueTableHeaders;
    }

    @Override
    public final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    @Override
    public boolean isHtmlMode() {
        return true;
    }

    static enum AnchorText {
        PROPERTY_NAME,
        TO_STRING,
        URI,
        LAST_TOKEN,
        URI_ANCHOR,
        CONTEXT_RELATIVE,
        SERVLET_RELATIVE,
        PATH_RELATIVE;

    }
}

