/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.html.HtmlBeanPropertyMeta;
import org.apache.juneau.html.HtmlClassMeta;
import org.apache.juneau.html.HtmlLink;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.HtmlSchemaDocSerializer;
import org.apache.juneau.html.HtmlSerializerBuilder;
import org.apache.juneau.html.HtmlSerializerContext;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.annotation.XmlFormat;

@Produces(value="text/html")
public class HtmlSerializer
extends XmlSerializer {
    public static final HtmlSerializer DEFAULT = new HtmlSerializer(PropertyStore.create());
    public static final HtmlSerializer DEFAULT_SQ = new Sq(PropertyStore.create());
    public static final HtmlSerializer DEFAULT_SQ_READABLE = new SqReadable(PropertyStore.create());
    final HtmlSerializerContext ctx = this.createContext(HtmlSerializerContext.class);
    private volatile HtmlSchemaDocSerializer schemaSerializer;

    public HtmlSerializer(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public HtmlSerializerBuilder builder() {
        return new HtmlSerializerBuilder(this.propertyStore);
    }

    private HtmlWriter doSerialize(HtmlSerializerSession session, Object o, HtmlWriter w) throws Exception {
        this.serializeAnything(session, w, o, session.getExpectedRootType(o), null, session.getInitialDepth() - 1, null, true);
        return w;
    }

    protected ContentResult serializeAnything(HtmlSerializerSession session, HtmlWriter out, Object o, ClassMeta<?> eType, String name, int indent, BeanPropertyMeta pMeta, boolean isRoot) throws Exception {
        ClassMeta<Object> aType = null;
        ClassMeta<Object> wType = null;
        ClassMeta<Object> sType = this.object();
        if (eType == null) {
            eType = this.object();
        }
        if ((aType = session.push(name, o, eType)) == null) {
            o = null;
            aType = this.object();
        }
        session.indent += indent;
        ContentResult cr = ContentResult.CR_NORMAL;
        if (o == null || aType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.tag("null");
            cr = ContentResult.CR_SIMPLE;
        } else {
            Object o2;
            HtmlRender<?> render;
            PojoSwap<Object, ?> swap;
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
            }
            sType = aType.getSerializedClassMeta();
            String typeName = null;
            if (session.isAddBeanTypeProperties() && !eType.equals(aType)) {
                typeName = aType.getDictionaryName();
            }
            if ((swap = aType.getPojoSwap()) != null) {
                o = swap.swap(session, o);
                if (sType.isObject()) {
                    sType = session.getClassMetaForObject(o);
                }
            }
            HtmlClassMeta html = sType.getExtendedMeta(HtmlClassMeta.class);
            HtmlRender<?> htmlRender = render = pMeta == null ? null : pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).getRender();
            if (render == null) {
                render = html.getRender();
            }
            if (render != null && (o2 = render.getContent(session, o)) != o) {
                session.indent -= indent;
                session.pop();
                out.nl(session.indent);
                return this.serializeAnything(session, out, o2, null, typeName, indent, null, false);
            }
            if (html.isAsXml() || pMeta != null && pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isAsXml()) {
                super.serializeAnything(session, out, o, null, null, null, false, XmlFormat.MIXED, false, false, null);
            } else if (html.isAsPlainText() || pMeta != null && pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isAsPlainText()) {
                out.write(o == null ? "null" : o.toString());
                cr = ContentResult.CR_SIMPLE;
            } else if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
                out.tag("null");
                cr = ContentResult.CR_SIMPLE;
            } else if (sType.isNumber()) {
                if (eType.isNumber() && !isRoot) {
                    out.append(o);
                } else {
                    out.sTag("number").append(o).eTag("number");
                }
                cr = ContentResult.CR_SIMPLE;
            } else if (sType.isBoolean()) {
                if (eType.isBoolean() && !isRoot) {
                    out.append(o);
                } else {
                    out.sTag("boolean").append(o).eTag("boolean");
                }
                cr = ContentResult.CR_SIMPLE;
            } else if (sType.isMap() || wType != null && wType.isMap()) {
                out.nlIf(!isRoot, indent + 1);
                if (o instanceof BeanMap) {
                    this.serializeBeanMap(session, out, (BeanMap)o, eType, pMeta);
                } else {
                    this.serializeMap(session, out, (Map)o, sType, eType.getKeyType(), eType.getValueType(), typeName, pMeta);
                }
            } else if (sType.isBean()) {
                BeanMap<Object> m = session.toBeanMap(o);
                Class<?> c = o.getClass();
                if (c.isAnnotationPresent(HtmlLink.class)) {
                    HtmlLink h = o.getClass().getAnnotation(HtmlLink.class);
                    Object urlProp = m.get(h.hrefProperty());
                    Object nameProp = m.get(h.nameProperty());
                    out.oTag("a").attrUri("href", urlProp).append('>').text(nameProp).eTag("a");
                    cr = ContentResult.CR_SIMPLE;
                } else {
                    out.nlIf(!isRoot, indent + 2);
                    this.serializeBeanMap(session, out, m, eType, pMeta);
                }
            } else if (sType.isCollection() || sType.isArray() || wType != null && wType.isCollection()) {
                out.nlIf(!isRoot, indent + 1);
                this.serializeCollection(session, out, o, sType, eType, name, pMeta);
            } else if (session.isUri(sType, pMeta, o)) {
                String label = session.getAnchorText(pMeta, o);
                out.oTag("a").attrUri("href", o).append('>');
                out.text(label);
                out.eTag("a");
                cr = ContentResult.CR_SIMPLE;
            } else {
                if (isRoot) {
                    out.sTag("string").text(session.toString(o)).eTag("string");
                } else {
                    out.text(session.toString(o));
                }
                cr = ContentResult.CR_SIMPLE;
            }
        }
        session.pop();
        session.indent -= indent;
        return cr;
    }

    private void serializeMap(HtmlSerializerSession session, HtmlWriter out, Map m, ClassMeta<?> sType, ClassMeta<?> eKeyType, ClassMeta<?> eValueType, String typeName, BeanPropertyMeta ppMeta) throws Exception {
        ClassMeta<Object> keyType = eKeyType == null ? session.string() : eKeyType;
        ClassMeta<Object> valueType = eValueType == null ? session.object() : eValueType;
        ClassMeta<Map> aType = session.getClassMetaForObject(m);
        int i = session.getIndent();
        out.oTag(i, "table");
        if (typeName != null && ppMeta != null && ppMeta.getClassMeta() != aType) {
            out.attr(session.getBeanTypePropertyName(sType), typeName);
        }
        out.append(">").nl(i + 1);
        if (!(!session.isAddKeyValueTableHeaders() || aType.getExtendedMeta(HtmlClassMeta.class).isNoTableHeaders() || ppMeta != null && ppMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isNoTableHeaders())) {
            out.sTag(i + 1, "tr").nl(i + 2);
            out.sTag(i + 2, "th").append("key").eTag("th").nl(i + 3);
            out.sTag(i + 2, "th").append("value").eTag("th").nl(i + 3);
            out.ie(i + 1).eTag("tr").nl(i + 2);
        }
        for (Map.Entry e : m.entrySet()) {
            Object key = session.generalize(e.getKey(), keyType);
            Object value = null;
            try {
                value = e.getValue();
            }
            catch (StackOverflowError t) {
                throw t;
            }
            catch (Throwable t) {
                session.onError(t, "Could not call getValue() on property ''{0}'', {1}", e.getKey(), t.getLocalizedMessage());
            }
            String link = HtmlSerializer.getLink(ppMeta);
            String style = HtmlSerializer.getStyle(session, ppMeta, value);
            out.sTag(i + 1, "tr").nl(i + 2);
            out.oTag(i + 2, "td");
            if (style != null) {
                out.attr("style", style);
            }
            out.cTag();
            if (link != null) {
                out.oTag(i + 3, "a").attrUri("href", link.replace("{#}", StringUtils.toString(value))).cTag();
            }
            ContentResult cr = this.serializeAnything(session, out, key, keyType, null, 2, null, false);
            if (link != null) {
                out.eTag("a");
            }
            if (cr == ContentResult.CR_NORMAL) {
                out.i(i + 2);
            }
            out.eTag("td").nl(i + 2);
            out.sTag(i + 2, "td");
            cr = this.serializeAnything(session, out, value, valueType, key == null ? "_x0000_" : session.toString(key), 2, null, false);
            if (cr == ContentResult.CR_NORMAL) {
                out.ie(i + 2);
            }
            out.eTag("td").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        }
        out.ie(i).eTag("table").nl(i);
    }

    private void serializeBeanMap(HtmlSerializerSession session, HtmlWriter out, BeanMap<?> m, ClassMeta<?> eType, BeanPropertyMeta ppMeta) throws Exception {
        int i = session.getIndent();
        out.oTag(i, "table");
        String typeName = m.getMeta().getDictionaryName();
        if (typeName != null && eType != m.getClassMeta()) {
            out.attr(session.getBeanTypePropertyName(m.getClassMeta()), typeName);
        }
        out.append('>').nl(i);
        if (!(!session.isAddKeyValueTableHeaders() || m.getClassMeta().getExtendedMeta(HtmlClassMeta.class).isNoTableHeaders() || ppMeta != null && ppMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isNoTableHeaders())) {
            out.sTag(i + 1, "tr").nl(i + 1);
            out.sTag(i + 2, "th").append("key").eTag("th").nl(i + 2);
            out.sTag(i + 2, "th").append("value").eTag("th").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        }
        for (BeanPropertyValue p : m.getValues(session.isTrimNulls(), new BeanPropertyValue[0])) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.onBeanGetterException(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            String link = cMeta.isCollectionOrArray() ? null : HtmlSerializer.getLink(pMeta);
            out.sTag(i + 1, "tr").nl(i + 1);
            out.sTag(i + 2, "td").text(key).eTag("td").nl(i + 2);
            out.oTag(i + 2, "td");
            String style = HtmlSerializer.getStyle(session, pMeta, value);
            if (style != null) {
                out.attr("style", style);
            }
            out.cTag();
            try {
                ContentResult cr;
                if (link != null) {
                    out.oTag(i + 3, "a").attrUri("href", m.resolveVars(link)).cTag();
                }
                if ((cr = this.serializeAnything(session, out, value, cMeta, key, 2, pMeta, false)) == ContentResult.CR_NORMAL) {
                    out.i(i + 2);
                }
                if (link != null) {
                    out.eTag("a");
                }
            }
            catch (SerializeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                session.onBeanGetterException(pMeta, e);
            }
            out.eTag("td").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        }
        out.ie(i).eTag("table").nl(i);
    }

    /*
     * WARNING - void declaration
     */
    private void serializeCollection(HtmlSerializerSession session, HtmlWriter out, Object in, ClassMeta<?> sType, ClassMeta<?> eType, String name, BeanPropertyMeta ppMeta) throws Exception {
        ClassMeta<Object> seType = sType.getElementType();
        if (seType == null) {
            seType = session.object();
        }
        Collection<Object> c = sType.isCollection() ? (List<Object>)in : HtmlSerializer.toList(sType.getInnerClass(), in);
        int i = session.getIndent();
        if (c.isEmpty()) {
            out.appendln(i, "<ul></ul>");
            return;
        }
        String type2 = null;
        if (sType != eType) {
            type2 = sType.getDictionaryName();
        }
        if (type2 == null) {
            type2 = "array";
        }
        c = session.sort(c);
        HtmlBeanPropertyMeta hbpMeta = ppMeta == null ? null : ppMeta.getExtendedMeta(HtmlBeanPropertyMeta.class);
        String btpn = session.getBeanTypePropertyName(eType);
        Object[] th = HtmlSerializer.getTableHeaders(session, c, hbpMeta);
        if (th != null) {
            out.oTag(i, "table").attr(btpn, type2).append('>').nl(i + 1);
            out.sTag(i + 1, "tr").nl(i + 2);
            for (Object key : th) {
                out.sTag(i + 2, "th");
                out.text(session.convertToType(key, String.class));
                out.eTag("th").nl(i + 2);
            }
            out.ie(i + 1).eTag("tr").nl(i + 1);
            for (Object e : c) {
                BeanMap<void> m2;
                void var16_20;
                ClassMeta<Object> cm = session.getClassMetaForObject(e);
                if (cm != null && cm.getPojoSwap() != null) {
                    PojoSwap f = cm.getPojoSwap();
                    Object obj = f.swap(session, e);
                    cm = cm.getSerializedClassMeta();
                }
                out.oTag(i + 1, "tr");
                String typeName = cm == null ? null : cm.getDictionaryName();
                String typeProperty = session.getBeanTypePropertyName(cm);
                if (typeName != null && eType.getElementType() != cm) {
                    out.attr(typeProperty, typeName);
                }
                out.cTag().nl(i + 2);
                if (cm == null) {
                    this.serializeAnything(session, out, var16_20, null, null, 1, null, false);
                } else if (cm.isMap() && !cm.isBeanMap()) {
                    m2 = session.sort((Map)var16_20);
                    for (Object k : th) {
                        out.sTag(i + 2, "td");
                        ContentResult cr = this.serializeAnything(session, out, m2.get(k), eType.getElementType(), session.toString(k), 2, null, false);
                        if (cr == ContentResult.CR_NORMAL) {
                            out.i(i + 2);
                        }
                        out.eTag("td").nl(i + 2);
                    }
                } else {
                    m2 = null;
                    m2 = var16_20 instanceof BeanMap ? (BeanMap<void>)var16_20 : session.toBeanMap(var16_20);
                    for (Object k : th) {
                        ContentResult cr;
                        BeanMapEntry p = m2.getProperty(session.toString(k));
                        BeanPropertyMeta pMeta = p.getMeta();
                        String link = pMeta.getClassMeta().isCollectionOrArray() ? null : HtmlSerializer.getLink(pMeta);
                        Object value = p.getValue();
                        String style = HtmlSerializer.getStyle(session, pMeta, value);
                        out.oTag(i + 2, "td");
                        if (style != null) {
                            out.attr("style", style);
                        }
                        out.cTag();
                        if (link != null) {
                            out.oTag("a").attrUri("href", m2.resolveVars(link)).cTag();
                        }
                        if ((cr = this.serializeAnything(session, out, value, pMeta.getClassMeta(), p.getKey().toString(), 2, pMeta, false)) == ContentResult.CR_NORMAL) {
                            out.i(i + 2);
                        }
                        if (link != null) {
                            out.eTag("a");
                        }
                        out.eTag("td").nl(i + 2);
                    }
                }
                out.ie(i + 1).eTag("tr").nl(i + 1);
            }
            out.ie(i).eTag("table").nl(i);
        } else {
            out.oTag(i, "ul");
            if (!type2.equals("array")) {
                out.attr(btpn, type2);
            }
            out.append('>').nl(i + 1);
            for (Object object : c) {
                out.oTag(i + 1, "li");
                String style = HtmlSerializer.getStyle(session, ppMeta, object);
                String link = HtmlSerializer.getLink(ppMeta);
                if (style != null) {
                    out.attr("style", style);
                }
                out.cTag();
                if (link != null) {
                    out.oTag(i + 2, "a").attrUri("href", link.replace("{#}", StringUtils.toString(object))).cTag();
                }
                ContentResult cr = this.serializeAnything(session, out, object, eType.getElementType(), name, 1, null, false);
                if (link != null) {
                    out.eTag("a");
                }
                if (cr == ContentResult.CR_NORMAL) {
                    out.ie(i + 1);
                }
                out.eTag("li").nl(i + 1);
            }
            out.ie(i).eTag("ul").nl(i);
        }
    }

    private static HtmlRender<?> getRender(HtmlSerializerSession session, BeanPropertyMeta pMeta, Object value) {
        if (pMeta == null) {
            return null;
        }
        HtmlBeanPropertyMeta hpMeta = pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class);
        HtmlRender render = hpMeta.getRender();
        if (render != null) {
            return render;
        }
        ClassMeta<Object> cMeta = session.getClassMetaForObject(value);
        render = cMeta == null ? null : cMeta.getExtendedMeta(HtmlClassMeta.class).getRender();
        return render;
    }

    private static String getStyle(HtmlSerializerSession session, BeanPropertyMeta pMeta, Object value) {
        HtmlRender<?> render = HtmlSerializer.getRender(session, pMeta, value);
        return render == null ? null : render.getStyle(session, value);
    }

    private static String getLink(BeanPropertyMeta pMeta) {
        return pMeta == null ? null : pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).getLink();
    }

    /*
     * WARNING - void declaration
     */
    private static Object[] getTableHeaders(SerializerSession session, Collection c, HtmlBeanPropertyMeta hbpMeta) throws Exception {
        Object[] th;
        if (c.size() == 0) {
            return null;
        }
        c = session.sort(c);
        HashSet<ClassMeta<Object>> prevC = new HashSet<ClassMeta<Object>>();
        Object o1 = null;
        for (Object o : c) {
            if (o == null) continue;
            o1 = o;
            break;
        }
        if (o1 == null) {
            return null;
        }
        ClassMeta<Object> cm = session.getClassMetaForObject(o1);
        if (cm.getPojoSwap() != null) {
            PojoSwap<Object, ?> f = cm.getPojoSwap();
            o1 = f.swap(session, o1);
            cm = cm.getSerializedClassMeta();
        }
        if (cm == null || !cm.isMapOrBean()) {
            return null;
        }
        if (cm.getInnerClass().isAnnotationPresent(HtmlLink.class)) {
            return null;
        }
        HtmlClassMeta h = cm.getExtendedMeta(HtmlClassMeta.class);
        if (h.isNoTables() || hbpMeta != null && hbpMeta.isNoTables()) {
            return null;
        }
        if (h.isNoTableHeaders() || hbpMeta != null && hbpMeta.isNoTableHeaders()) {
            return new Object[0];
        }
        if (session.canIgnoreValue(cm, null, o1)) {
            return null;
        }
        if (cm.isMap() && !cm.isBeanMap()) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (Object o : c) {
                if (session.canIgnoreValue(cm, null, o)) continue;
                if (!cm.isInstance(o)) {
                    return null;
                }
                Map m = session.sort((Map)o);
                for (Map.Entry<String, Object> entry : m.entrySet()) {
                    if (entry.getValue() == null) continue;
                    set.add(entry.getKey() == null ? null : entry.getKey());
                }
            }
            th = set.toArray(new Object[set.size()]);
        } else {
            LinkedHashMap<String, Boolean> m = new LinkedHashMap<String, Boolean>();
            for (Object o : c) {
                if (session.canIgnoreValue(cm, null, o)) continue;
                if (!cm.isInstance(o)) {
                    return null;
                }
                BeanMap bm = o instanceof BeanMap ? (BeanMap)o : session.toBeanMap(o);
                for (Map.Entry<String, Object> entry : bm.entrySet()) {
                    String key = entry.getKey();
                    if (entry.getValue() != null) {
                        m.put(key, true);
                        continue;
                    }
                    if (m.containsKey(key)) continue;
                    m.put(key, false);
                }
            }
            Object[] i = m.values().iterator();
            while (i.hasNext()) {
                if (((Boolean)i.next()).booleanValue()) continue;
                i.remove();
            }
            th = m.keySet().toArray(new Object[m.size()]);
        }
        prevC.add(cm);
        boolean isSortable = true;
        for (Object o : th) {
            isSortable &= o instanceof Comparable;
        }
        AbstractSet s = isSortable ? new TreeSet() : new LinkedHashSet();
        s.addAll(Arrays.asList(th));
        for (Object o : c) {
            void var13_22;
            if (o == null) continue;
            cm = session.getClassMetaForObject(o);
            if (cm != null && cm.getPojoSwap() != null) {
                PojoSwap<Object, ?> f = cm.getPojoSwap();
                o = f.swap(session, o);
                cm = cm.getSerializedClassMeta();
            }
            if (prevC.contains(cm)) continue;
            if (cm == null || !cm.isMap() && !cm.isBean()) {
                return null;
            }
            if (cm.getInnerClass().isAnnotationPresent(HtmlLink.class)) {
                return null;
            }
            if (session.canIgnoreValue(cm, null, o)) {
                return null;
            }
            if (cm.isMap() && !cm.isBeanMap()) {
                Map m = (Map)o;
                if (th.length != m.keySet().size()) {
                    return null;
                }
                for (Object k : m.keySet()) {
                    if (s.contains(k.toString())) continue;
                    return null;
                }
                continue;
            }
            BeanMap bm = o instanceof BeanMap ? (BeanMap)o : session.toBeanMap(o);
            boolean bl = false;
            for (String k : bm.keySet()) {
                if (!s.contains(k)) {
                    return null;
                }
                ++var13_22;
            }
            if (s.size() == var13_22) continue;
            return null;
        }
        return th;
    }

    @Override
    public HtmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = new HtmlSchemaDocSerializer(this.propertyStore, this.getOverrideProperties());
        }
        return this.schemaSerializer;
    }

    @Override
    public HtmlSerializerSession createSession(Object output, ObjectMap op, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        return new HtmlSerializerSession(this.ctx, op, output, javaMethod, locale, timeZone, mediaType, uriContext);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        HtmlSerializerSession s = (HtmlSerializerSession)session;
        this.doSerialize(s, o, s.getWriter());
    }

    static enum ContentResult {
        CR_SIMPLE,
        CR_NORMAL;

    }

    public static class SqReadable
    extends HtmlSerializer {
        public SqReadable(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Serializer.quoteChar", Character.valueOf('\'')).append("Serializer.useWhitespace", true);
        }
    }

    public static class Sq
    extends HtmlSerializer {
        public Sq(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Serializer.quoteChar", Character.valueOf('\''));
        }
    }
}

