/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.UriContext;
import org.apache.juneau.html.HtmlDocSerializerContext;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ClassUtils;

public final class HtmlDocSerializerSession
extends HtmlSerializerSession {
    private final String header;
    private final String nav;
    private final String aside;
    private final String footer;
    private final String noResultsMessage;
    private final String[] style;
    private final String[] stylesheet;
    private final String[] script;
    private final String[] links;
    private final boolean nowrap;
    private final HtmlDocTemplate template;

    protected HtmlDocSerializerSession(HtmlDocSerializerContext ctx, ObjectMap op, Object output, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        super(ctx, op, output, javaMethod, locale, timeZone, mediaType, uriContext);
        if (op == null || op.isEmpty()) {
            this.header = ctx.header;
            this.nav = ctx.nav;
            this.aside = ctx.aside;
            this.footer = ctx.footer;
            this.links = ctx.links;
            this.style = ctx.style;
            this.stylesheet = ctx.stylesheet;
            this.script = ctx.script;
            this.nowrap = ctx.nowrap;
            this.noResultsMessage = ctx.noResultsMessage;
            this.template = ClassUtils.newInstance(HtmlDocTemplate.class, ctx.template, new Object[0]);
        } else {
            this.header = op.getString("HtmlDocSerializer.header", ctx.nav);
            this.nav = op.getString("HtmlDocSerializer.nav", ctx.nav);
            this.aside = op.getString("HtmlDocSerializer.aside", ctx.aside);
            this.footer = op.getString("HtmlDocSerializer.footer", ctx.footer);
            this.links = op.getStringArray("HtmlDocSerializer.links.list", ctx.links);
            this.style = op.getStringArray("HtmlDocSerializer.style.list", ctx.style);
            this.stylesheet = op.getStringArray("HtmlDocSerializer.stylesheet", ctx.stylesheet);
            this.script = op.getStringArray("HtmlDocSerializer.script.list", ctx.script);
            this.nowrap = op.getBoolean("HtmlDocSerializer.nowrap", ctx.nowrap);
            this.noResultsMessage = op.getString("HtmlDocSerializer.noResultsMessage", ctx.noResultsMessage);
            this.template = ClassUtils.newInstance(HtmlDocTemplate.class, op.get("HtmlDocSerializer.template", ctx.template), new Object[0]);
        }
    }

    public final String[] getStyle() {
        return this.style;
    }

    public final String[] getStylesheet() {
        return this.stylesheet;
    }

    public final String[] getScript() {
        return this.script;
    }

    public final boolean isNoWrap() {
        return this.nowrap;
    }

    public final String getHeader() {
        return this.header;
    }

    public final String[] getLinks() {
        return this.links;
    }

    public final HtmlDocTemplate getTemplate() {
        return this.template;
    }

    public final String getNav() {
        return this.nav;
    }

    public final String getAside() {
        return this.aside;
    }

    public final String getFooter() {
        return this.footer;
    }

    public final String getNoResultsMessage() {
        return this.noResultsMessage;
    }

    @Override
    public HtmlWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof HtmlWriter) {
            return (HtmlWriter)output;
        }
        return new HtmlWriter(super.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isTrimStrings(), this.getQuoteChar(), this.getUriResolver());
    }
}

