/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.html.HtmlDocSerializerContext;
import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.serializer.SerializerSession;

@Produces(value="text/html")
public class HtmlDocSerializer
extends HtmlStrippedDocSerializer {
    public static final HtmlDocSerializer DEFAULT = new HtmlDocSerializer(PropertyStore.create());
    final HtmlDocSerializerContext ctx = this.createContext(HtmlDocSerializerContext.class);

    public HtmlDocSerializer(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public HtmlDocSerializerSession createSession(Object output, ObjectMap op, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        return new HtmlDocSerializerSession(this.ctx, op, output, javaMethod, locale, timeZone, mediaType, uriContext);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        HtmlDocSerializerSession s = (HtmlDocSerializerSession)session;
        HtmlWriter w = s.getWriter();
        HtmlDocTemplate t = s.getTemplate();
        w.sTag("html").nl(0);
        w.sTag(1, "head").nl(1);
        t.head(s, w, this, o);
        w.eTag(1, "head").nl(1);
        w.sTag(1, "body").nl(1);
        t.body(s, w, this, o);
        w.eTag(1, "body").nl(1);
        w.eTag("html").nl(0);
    }

    public void parentSerialize(SerializerSession session, Object o) throws Exception {
        super.doSerialize(session, o);
    }
}

