/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.jsonschema;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.dto.jsonschema.Schema;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;

public abstract class SchemaMap
extends ConcurrentHashMap<URI, Schema> {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema get(Object uri) {
        URI u = StringUtils.toURI(uri);
        Schema s = (Schema)super.get(u);
        if (s != null) {
            return s;
        }
        SchemaMap schemaMap = this;
        synchronized (schemaMap) {
            s = this.load(u);
            if (s != null) {
                s.setSchemaMap(this);
                this.put(u, s);
            }
            return s;
        }
    }

    public SchemaMap add(Schema ... schemas) {
        for (Schema schema : schemas) {
            if (schema.getId() == null) {
                throw new RuntimeException("Schema with no ID passed to SchemaMap.add(Schema...)");
            }
            this.put(schema.getId(), schema);
            schema.setSchemaMap(this);
        }
        return this;
    }

    public Schema load(URI uri) {
        Reader r = this.getReader(uri);
        if (r == null) {
            return null;
        }
        try {
            Schema schema = JsonParser.DEFAULT.parse((Object)r, Schema.class);
            return schema;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Reader getReader(URI uri) {
        return null;
    }
}

