/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.jsonschema;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.dto.jsonschema.JsonType;
import org.apache.juneau.dto.jsonschema.JsonTypeArray;
import org.apache.juneau.dto.jsonschema.SchemaArray;
import org.apache.juneau.dto.jsonschema.SchemaMap;
import org.apache.juneau.dto.jsonschema.SchemaProperty;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;

@Bean(typeName="schema", properties="id,$schema,$ref, title,description,type,definitions,properties,patternProperties,dependencies,items,multipleOf,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,additionalItems,maxItems,minItems,uniqueItems,maxProperties,minProperties,required,additionalProperties,enum,allOf,anyOf,oneOf,not")
public class Schema {
    private String name;
    private URI id;
    private URI schemaVersion;
    private String title;
    private String description;
    private JsonType typeJsonType;
    private JsonTypeArray typeJsonTypeArray;
    private Map<String, Schema> definitions;
    private Map<String, Schema> properties;
    private Map<String, Schema> patternProperties;
    private Map<String, Schema> dependencies;
    private Schema itemsSchema;
    private SchemaArray itemsSchemaArray;
    private Number multipleOf;
    private Number maximum;
    private Boolean exclusiveMaximum;
    private Number minimum;
    private Boolean exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private String pattern;
    private Boolean additionalItemsBoolean;
    private SchemaArray additionalItemsSchemaArray;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private Integer maxProperties;
    private Integer minProperties;
    private List<String> required;
    private Boolean additionalPropertiesBoolean;
    private Schema additionalPropertiesSchema;
    private List<String> _enum;
    private List<Schema> allOf;
    private List<Schema> anyOf;
    private List<Schema> oneOf;
    private Schema not;
    private URI ref;
    private SchemaMap schemaMap;
    private Schema master = this;

    @BeanIgnore
    public String getName() {
        return this.name;
    }

    @BeanIgnore
    public Schema setName(String name) {
        this.name = name;
        return this;
    }

    public URI getId() {
        return this.id;
    }

    public Schema setId(Object id) {
        this.id = StringUtils.toURI(id);
        return this;
    }

    @BeanProperty(value="$schema")
    public URI getSchemaVersionUri() {
        return this.schemaVersion;
    }

    @BeanProperty(value="$schema")
    public Schema setSchemaVersionUri(Object schemaVersion) {
        this.schemaVersion = StringUtils.toURI(schemaVersion);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Schema setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Schema setDescription(String description) {
        this.description = description;
        return this;
    }

    @BeanProperty(swap=JsonTypeOrJsonTypeArraySwap.class)
    public Object getType() {
        if (this.typeJsonType != null) {
            return this.typeJsonType;
        }
        return this.typeJsonTypeArray;
    }

    @BeanIgnore
    public JsonType getTypeAsJsonType() {
        return this.typeJsonType;
    }

    @BeanIgnore
    public JsonTypeArray getTypeAsJsonTypeArray() {
        return this.typeJsonTypeArray;
    }

    public Schema setType(Object type) {
        this.typeJsonType = null;
        this.typeJsonTypeArray = null;
        if (type != null) {
            if (type instanceof JsonType) {
                this.typeJsonType = (JsonType)((Object)type);
            } else if (type instanceof JsonTypeArray) {
                this.typeJsonTypeArray = (JsonTypeArray)type;
            } else {
                throw new BeanRuntimeException(SchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  SimpleType, SimpleTypeArray", type.getClass().getName());
            }
        }
        return this;
    }

    public Schema addTypes(JsonType ... types) {
        if (this.typeJsonTypeArray == null) {
            this.typeJsonTypeArray = new JsonTypeArray();
        }
        this.typeJsonTypeArray.addAll(types);
        return this;
    }

    public Map<String, Schema> getDefinitions() {
        return this.definitions;
    }

    public Schema setDefinitions(Map<String, Schema> definitions) {
        this.definitions = definitions;
        if (definitions != null) {
            this.setMasterOn(definitions.values());
        }
        return this;
    }

    public Schema addDefinition(String name, Schema definition) {
        if (this.definitions == null) {
            this.definitions = new LinkedHashMap<String, Schema>();
        }
        this.definitions.put(name, definition);
        this.setMasterOn(definition);
        return this;
    }

    public Map<String, Schema> getProperties() {
        return this.properties;
    }

    public Schema getProperty(String name) {
        return this.getProperty(name, false);
    }

    public Schema getProperty(String name, boolean resolve) {
        if (this.properties == null) {
            return null;
        }
        Schema s = this.properties.get(name);
        if (s == null) {
            return null;
        }
        if (resolve) {
            s = s.resolve();
        }
        return s;
    }

    public Schema setProperties(Map<String, Schema> properties) {
        this.properties = properties;
        if (properties != null) {
            for (Map.Entry<String, Schema> e : properties.entrySet()) {
                Schema value = e.getValue();
                this.setMasterOn(value);
                value.setName(e.getKey());
            }
        }
        return this;
    }

    public Schema addProperties(Schema ... properties) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Schema>();
        }
        for (Schema p : properties) {
            if (p.getName() == null) {
                throw new BeanRuntimeException(Schema.class, "Invalid property passed to Schema.addProperties().  Property name was null.", new Object[0]);
            }
            this.setMasterOn(p);
            this.properties.put(p.getName(), p);
        }
        return this;
    }

    public Map<String, Schema> getPatternProperties() {
        return this.patternProperties;
    }

    public Schema setPatternProperties(Map<String, Schema> patternProperties) {
        this.patternProperties = patternProperties;
        if (patternProperties != null) {
            for (Map.Entry<String, Schema> e : patternProperties.entrySet()) {
                Schema s = e.getValue();
                this.setMasterOn(s);
                s.setName(e.getKey());
            }
        }
        return this;
    }

    public Schema addPatternProperties(SchemaProperty ... properties) {
        if (this.patternProperties == null) {
            this.patternProperties = new LinkedHashMap<String, Schema>();
        }
        for (SchemaProperty p : properties) {
            if (p.getName() == null) {
                throw new BeanRuntimeException(Schema.class, "Invalid property passed to Schema.addProperties().  Property name was null.", new Object[0]);
            }
            this.setMasterOn(p);
            this.patternProperties.put(p.getName(), p);
        }
        return this;
    }

    public Map<String, Schema> getDependencies() {
        return this.dependencies;
    }

    public Schema setDependencies(Map<String, Schema> dependencies) {
        this.dependencies = dependencies;
        if (dependencies != null) {
            this.setMasterOn(dependencies.values());
        }
        return this;
    }

    public Schema addDependency(String name, Schema dependency) {
        if (this.dependencies == null) {
            this.dependencies = new LinkedHashMap<String, Schema>();
        }
        this.dependencies.put(name, dependency);
        this.setMasterOn(dependency);
        return this;
    }

    @BeanProperty(swap=SchemaOrSchemaArraySwap.class)
    public Object getItems() {
        if (this.itemsSchema != null) {
            return this.itemsSchema;
        }
        return this.itemsSchemaArray;
    }

    @BeanIgnore
    public Schema getItemsAsSchema() {
        return this.itemsSchema;
    }

    @BeanIgnore
    public SchemaArray getItemsAsSchemaArray() {
        return this.itemsSchemaArray;
    }

    public Schema setItems(Object items) {
        this.itemsSchema = null;
        this.itemsSchemaArray = null;
        if (items != null) {
            if (items instanceof Schema) {
                this.itemsSchema = (Schema)items;
                this.setMasterOn(this.itemsSchema);
            } else if (items instanceof SchemaArray) {
                this.itemsSchemaArray = (SchemaArray)items;
                this.setMasterOn(this.itemsSchemaArray);
            } else {
                throw new BeanRuntimeException(SchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  Schema, SchemaArray", items.getClass().getName());
            }
        }
        return this;
    }

    public Schema addItems(Schema ... items) {
        if (this.itemsSchemaArray == null) {
            this.itemsSchemaArray = new SchemaArray();
        }
        this.itemsSchemaArray.addAll(items);
        this.setMasterOn(items);
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public Schema setMultipleOf(Number multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Schema setMaximum(Number maximum) {
        this.maximum = maximum;
        return this;
    }

    public Boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Schema setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Schema setMinimum(Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public Boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public Schema setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Schema setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Schema setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Schema setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @BeanProperty(swap=BooleanOrSchemaArraySwap.class)
    public Object getAdditionalItems() {
        if (this.additionalItemsBoolean != null) {
            return this.additionalItemsBoolean;
        }
        return this.additionalItemsSchemaArray;
    }

    @BeanIgnore
    public Boolean getAdditionalItemsAsBoolean() {
        return this.additionalItemsBoolean;
    }

    @BeanIgnore
    public List<Schema> getAdditionalItemsAsSchemaArray() {
        return this.additionalItemsSchemaArray;
    }

    public Schema setAdditionalItems(Object additionalItems) {
        this.additionalItemsBoolean = null;
        this.additionalItemsSchemaArray = null;
        if (additionalItems != null) {
            if (additionalItems instanceof Boolean) {
                this.additionalItemsBoolean = (Boolean)additionalItems;
            } else if (additionalItems instanceof SchemaArray) {
                this.additionalItemsSchemaArray = (SchemaArray)additionalItems;
                this.setMasterOn(this.additionalItemsSchemaArray);
            } else {
                throw new BeanRuntimeException(SchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  Boolean, SchemaArray", additionalItems.getClass().getName());
            }
        }
        return this;
    }

    public Schema addAdditionalItems(Schema ... additionalItems) {
        if (this.additionalItemsSchemaArray == null) {
            this.additionalItemsSchemaArray = new SchemaArray();
        }
        this.additionalItemsSchemaArray.addAll(additionalItems);
        this.setMasterOn(additionalItems);
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Schema setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Schema setMinItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public Schema setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Schema setMaxProperties(Integer maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Schema setMinProperties(Integer minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public Schema setRequired(List<String> required) {
        this.required = required;
        return this;
    }

    public Schema addRequired(List<String> required) {
        if (this.required == null) {
            this.required = new LinkedList<String>();
        }
        for (String r : required) {
            this.required.add(r);
        }
        return this;
    }

    public Schema addRequired(String ... required) {
        if (this.required == null) {
            this.required = new LinkedList<String>();
        }
        for (String r : required) {
            this.required.add(r);
        }
        return this;
    }

    public Schema addRequired(SchemaProperty ... properties) {
        if (this.required == null) {
            this.required = new LinkedList<String>();
        }
        for (SchemaProperty p : properties) {
            this.required.add(p.getName());
        }
        return this;
    }

    @BeanProperty(swap=BooleanOrSchemaSwap.class)
    public Object getAdditionalProperties() {
        if (this.additionalPropertiesBoolean != null) {
            return this.additionalItemsBoolean;
        }
        return this.additionalPropertiesSchema;
    }

    @BeanIgnore
    public Boolean getAdditionalPropertiesAsBoolean() {
        return this.additionalPropertiesBoolean;
    }

    @BeanIgnore
    public Schema getAdditionalPropertiesAsSchema() {
        return this.additionalPropertiesSchema;
    }

    @BeanProperty(beanDictionary={Schema.class})
    public Schema setAdditionalProperties(Object additionalProperties) {
        this.additionalPropertiesBoolean = null;
        this.additionalPropertiesSchema = null;
        if (additionalProperties != null) {
            if (additionalProperties instanceof Boolean) {
                this.additionalPropertiesBoolean = (Boolean)additionalProperties;
            } else if (additionalProperties instanceof Schema) {
                this.additionalPropertiesSchema = (Schema)additionalProperties;
                this.setMasterOn(this.additionalPropertiesSchema);
            } else {
                throw new BeanRuntimeException(SchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  Boolean, Schema", additionalProperties.getClass().getName());
            }
        }
        return this;
    }

    public List<String> getEnum() {
        return this._enum;
    }

    public Schema setEnum(List<String> _enum) {
        this._enum = _enum;
        return this;
    }

    public Schema addEnum(String ... _enum) {
        if (this._enum == null) {
            this._enum = new LinkedList<String>();
        }
        for (String e : _enum) {
            this._enum.add(e);
        }
        return this;
    }

    public List<Schema> getAllOf() {
        return this.allOf;
    }

    public Schema setAllOf(List<Schema> allOf) {
        this.allOf = allOf;
        this.setMasterOn(allOf);
        return this;
    }

    public Schema addAllOf(Schema ... allOf) {
        if (this.allOf == null) {
            this.allOf = new LinkedList<Schema>();
        }
        this.setMasterOn(allOf);
        for (Schema s : allOf) {
            this.allOf.add(s);
        }
        return this;
    }

    public List<Schema> getAnyOf() {
        return this.anyOf;
    }

    public Schema setAnyOf(List<Schema> anyOf) {
        this.anyOf = anyOf;
        this.setMasterOn(anyOf);
        return this;
    }

    public Schema addAnyOf(Schema ... anyOf) {
        if (this.anyOf == null) {
            this.anyOf = new LinkedList<Schema>();
        }
        this.setMasterOn(anyOf);
        for (Schema s : anyOf) {
            this.anyOf.add(s);
        }
        return this;
    }

    public List<Schema> getOneOf() {
        return this.oneOf;
    }

    public Schema setOneOf(List<Schema> oneOf) {
        this.oneOf = oneOf;
        this.setMasterOn(oneOf);
        return this;
    }

    public Schema addOneOf(Schema ... oneOf) {
        if (this.oneOf == null) {
            this.oneOf = new LinkedList<Schema>();
        }
        this.setMasterOn(oneOf);
        for (Schema s : oneOf) {
            this.oneOf.add(s);
        }
        return this;
    }

    public Schema getNot() {
        return this.not;
    }

    public Schema setNot(Schema not) {
        this.not = not;
        this.setMasterOn(not);
        return this;
    }

    @BeanProperty(value="$ref")
    public URI getRef() {
        return this.ref;
    }

    @BeanProperty(value="$ref")
    public Schema setRef(Object ref) {
        this.ref = StringUtils.toURI(ref);
        return this;
    }

    private void setMasterOn(Schema s) {
        if (s != null) {
            s.setMaster(this);
        }
    }

    private void setMasterOn(Schema[] ss) {
        if (ss != null) {
            for (Schema s : ss) {
                this.setMasterOn(s);
            }
        }
    }

    private void setMasterOn(Collection<Schema> ss) {
        if (ss != null) {
            for (Schema s : ss) {
                this.setMasterOn(s);
            }
        }
    }

    private void setMasterOn(SchemaArray ss) {
        if (ss != null) {
            for (Schema s : ss) {
                this.setMasterOn(s);
            }
        }
    }

    protected void setMaster(Schema master) {
        this.master = master;
        if (this.definitions != null) {
            for (Schema s : this.definitions.values()) {
                s.setMaster(master);
            }
        }
        if (this.properties != null) {
            for (Schema s : this.properties.values()) {
                s.setMaster(master);
            }
        }
        if (this.patternProperties != null) {
            for (Schema s : this.patternProperties.values()) {
                s.setMaster(master);
            }
        }
        if (this.dependencies != null) {
            for (Schema s : this.dependencies.values()) {
                s.setMaster(master);
            }
        }
        if (this.itemsSchema != null) {
            this.itemsSchema.setMaster(master);
        }
        if (this.itemsSchemaArray != null) {
            for (Schema s : this.itemsSchemaArray) {
                s.setMaster(master);
            }
        }
        if (this.additionalItemsSchemaArray != null) {
            for (Schema s : this.additionalItemsSchemaArray) {
                s.setMaster(master);
            }
        }
        if (this.additionalPropertiesSchema != null) {
            this.additionalPropertiesSchema.setMaster(master);
        }
        if (this.allOf != null) {
            for (Schema s : this.allOf) {
                s.setMaster(master);
            }
        }
        if (this.anyOf != null) {
            for (Schema s : this.anyOf) {
                s.setMaster(master);
            }
        }
        if (this.oneOf != null) {
            for (Schema s : this.oneOf) {
                s.setMaster(master);
            }
        }
        if (this.not != null) {
            this.not.setMaster(master);
        }
    }

    public Schema resolve() {
        if (this.ref == null || this.master.schemaMap == null) {
            return this;
        }
        return this.master.schemaMap.get(this.ref);
    }

    public Schema setSchemaMap(SchemaMap schemaMap) {
        this.schemaMap = schemaMap;
        return this;
    }

    public static class BooleanOrSchemaSwap
    extends PojoSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Object> cm = o instanceof Boolean ? session.getClassMeta(Boolean.class) : session.getClassMeta(Schema.class);
            return session.convertToType(o, cm);
        }
    }

    public static class BooleanOrSchemaArraySwap
    extends PojoSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Serializable> cm = o instanceof Collection ? session.getClassMeta(SchemaArray.class) : session.getClassMeta(Boolean.class);
            return session.convertToType(o, cm);
        }
    }

    public static class SchemaOrSchemaArraySwap
    extends PojoSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Object> cm = o instanceof Collection ? session.getClassMeta(SchemaArray.class) : session.getClassMeta(Schema.class);
            return session.convertToType(o, cm);
        }
    }

    public static class JsonTypeOrJsonTypeArraySwap
    extends PojoSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Object> cm = o instanceof Collection ? session.getClassMeta(JsonTypeArray.class) : session.getClassMeta(JsonType.class);
            return session.convertToType(o, cm);
        }
    }
}

