/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.Context;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Overrideable;
import org.apache.juneau.internal.JuneauLogger;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.serializer.SerializeException;

public abstract class Session {
    private JuneauLogger logger;
    private final ObjectMap properties;
    private final Context ctx;
    private Map<String, Object> cache;
    private boolean closed;
    private List<String> warnings;

    protected Session(Context ctx, ObjectMap op) {
        this.ctx = ctx;
        this.properties = op != null ? op : ObjectMap.EMPTY_MAP;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String def) {
        Object v = this.properties.get(key);
        if (v == null) {
            v = this.ctx.getPropertyStore().getProperty(key, String.class, null);
        }
        if (v == null) {
            v = def;
        }
        return StringUtils.toString(v);
    }

    public <T> T getProperty(Class<T> type, String key) {
        return this.getProperty(type, key, null);
    }

    public <T> T getProperty(Class<T> type, String key, T def) {
        T t = this.properties.get(type, key);
        if (t == null) {
            t = this.ctx.getPropertyStore().getProperty(key, type, def);
        }
        return t;
    }

    public void addToCache(String key, Object val) {
        if (this.cache == null) {
            this.cache = new TreeMap<String, Object>();
        }
        this.cache.put(key, val);
    }

    public void addToCache(Map<String, Object> cacheObjects) {
        if (cacheObjects != null) {
            if (this.cache == null) {
                this.cache = new TreeMap<String, Object>();
            }
            this.cache.putAll(cacheObjects);
        }
    }

    public <T> T getFromCache(Class<T> c, String key) {
        return (T)(this.cache == null ? null : this.cache.get(key));
    }

    public final void addWarning(String msg, Object ... args) {
        if (this.warnings == null) {
            this.warnings = new LinkedList<String>();
        }
        this.getLogger().warning(msg, args);
        this.warnings.add(this.warnings.size() + 1 + ": " + StringUtils.format(msg, args));
    }

    public boolean hasWarnings() {
        return this.warnings != null && this.warnings.size() > 0;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    protected JuneauLogger getLogger() {
        if (this.logger == null) {
            this.logger = JuneauLogger.getLogger(this.getClass());
        }
        return this.logger;
    }

    @Overrideable
    public ObjectMap asMap() {
        return new ObjectMap();
    }

    public String toString() {
        try {
            return this.asMap().toString(JsonSerializer.DEFAULT_LAX_READABLE);
        }
        catch (SerializeException e) {
            return e.getLocalizedMessage();
        }
    }

    public boolean close() throws BeanRuntimeException {
        if (this.closed) {
            return false;
        }
        this.closed = true;
        return true;
    }

    protected void finalize() throws Throwable {
    }
}

