/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.transform.BeanFilterBuilder;
import org.apache.juneau.transform.InterfaceBeanFilterBuilder;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.transform.SurrogateSwap;

public class BeanContext
extends Context {
    public static final String BEAN_beansRequireDefaultConstructor = "BeanContext.beansRequireDefaultConstructor";
    public static final String BEAN_beansRequireSerializable = "BeanContext.beansRequireSerializable";
    public static final String BEAN_beansRequireSettersForGetters = "BeanContext.beansRequireSettersForGetters";
    public static final String BEAN_beansRequireSomeProperties = "BeanContext.beansRequireSomeProperties";
    public static final String BEAN_beanMapPutReturnsOldValue = "BeanContext.beanMapPutReturnsOldValue";
    public static final String BEAN_beanConstructorVisibility = "BeanContext.beanConstructorVisibility";
    public static final String BEAN_beanClassVisibility = "BeanContext.beanClassVisibility";
    public static final String BEAN_beanFieldVisibility = "BeanContext.beanFieldVisibility";
    public static final String BEAN_methodVisibility = "BeanContext.methodVisibility";
    public static final String BEAN_useJavaBeanIntrospector = "BeanContext.useJavaBeanIntrospector";
    public static final String BEAN_useInterfaceProxies = "BeanContext.useInterfaceProxies";
    public static final String BEAN_ignoreUnknownBeanProperties = "BeanContext.ignoreUnknownBeanProperties";
    public static final String BEAN_ignoreUnknownNullBeanProperties = "BeanContext.ignoreUnknownNullBeanProperties";
    public static final String BEAN_ignorePropertiesWithoutSetters = "BeanContext.ignorePropertiesWithoutSetters";
    public static final String BEAN_ignoreInvocationExceptionsOnGetters = "BeanContext.ignoreInvocationExceptionsOnGetters";
    public static final String BEAN_ignoreInvocationExceptionsOnSetters = "BeanContext.ignoreInvocationExceptionsOnSetters";
    public static final String BEAN_sortProperties = "BeanContext.sortProperties";
    public static final String BEAN_notBeanPackages = "BeanContext.notBeanPackages.set";
    public static final String BEAN_notBeanPackages_add = "BeanContext.notBeanPackages.set.add";
    public static final String BEAN_notBeanPackages_remove = "BeanContext.notBeanPackages.set.remove";
    public static final String BEAN_notBeanClasses = "BeanContext.notBeanClasses.set";
    public static final String BEAN_notBeanClasses_add = "BeanContext.notBeanClasses.set.add";
    public static final String BEAN_notBeanClasses_remove = "BeanContext.notBeanClasses.set.remove";
    public static final String BEAN_beanFilters = "BeanContext.beanFilters.list";
    public static final String BEAN_beanFilters_add = "BeanContext.beanFilters.list.add";
    public static final String BEAN_beanFilters_remove = "BeanContext.beanFilters.list.remove";
    public static final String BEAN_pojoSwaps = "BeanContext.pojoSwaps.list";
    public static final String BEAN_pojoSwaps_add = "BeanContext.pojoSwaps.list.add";
    public static final String BEAN_pojoSwaps_remove = "BeanContext.pojoSwaps.list.remove";
    public static final String BEAN_implClasses = "BeanContext.implClasses.map";
    public static final String BEAN_implClasses_put = "BeanContext.implClasses.map.put";
    public static final String BEAN_includeProperties = "BeanContext.includeProperties.map";
    public static final String BEAN_includeProperties_put = "BeanContext.includeProperties.map.put";
    public static final String BEAN_excludeProperties = "BeanContext.excludeProperties.map";
    public static final String BEAN_excludeProperties_put = "BeanContext.excludeProperties.map.put";
    public static final String BEAN_beanDictionary = "BeanContext.beanDictionary.list";
    public static final String BEAN_beanDictionary_add = "BeanContext.beanDictionary.list.add";
    public static final String BEAN_beanDictionary_remove = "BeanContext.beanDictionary.list.remove";
    public static final String BEAN_beanTypePropertyName = "BeanContext.beanTypePropertyName";
    public static final String BEAN_defaultParser = "BeanContext.defaultParser";
    public static final String BEAN_locale = "BeanContext.locale";
    public static final String BEAN_timeZone = "BeanContext.timeZone";
    public static final String BEAN_mediaType = "BeanContext.mediaType";
    public static final String BEAN_debug = "BeanContext.debug";
    private static final String[] DEFAULT_NOTBEAN_PACKAGES = new String[]{"java.lang", "java.lang.annotation", "java.lang.ref", "java.lang.reflect", "java.io", "java.net", "java.nio.*", "java.util.*"};
    private static final Class<?>[] DEFAULT_NOTBEAN_CLASSES = new Class[]{Map.class, Collection.class, Reader.class, Writer.class, InputStream.class, OutputStream.class, Throwable.class};
    private static final ConcurrentHashMap<Integer, Map<Class, ClassMeta>> cmCacheCache = new ConcurrentHashMap();
    public static final BeanContext DEFAULT = PropertyStore.create().getContext(BeanContext.class);
    public static final BeanContext DEFAULT_SORTED = PropertyStore.create().setProperty("BeanContext.sortProperties", true).getContext(BeanContext.class);
    final boolean beansRequireDefaultConstructor;
    final boolean beansRequireSerializable;
    final boolean beansRequireSettersForGetters;
    final boolean beansRequireSomeProperties;
    final boolean beanMapPutReturnsOldValue;
    final boolean useInterfaceProxies;
    final boolean ignoreUnknownBeanProperties;
    final boolean ignoreUnknownNullBeanProperties;
    final boolean ignorePropertiesWithoutSetters;
    final boolean ignoreInvocationExceptionsOnGetters;
    final boolean ignoreInvocationExceptionsOnSetters;
    final boolean useJavaBeanIntrospector;
    final boolean sortProperties;
    final boolean debug;
    final Visibility beanConstructorVisibility;
    final Visibility beanClassVisibility;
    final Visibility beanMethodVisibility;
    final Visibility beanFieldVisibility;
    final Class<?>[] notBeanClasses;
    final Class<?>[] beanDictionaryClasses;
    final String[] notBeanPackageNames;
    final String[] notBeanPackagePrefixes;
    final BeanFilter[] beanFilters;
    final PojoSwap<?, ?>[] pojoSwaps;
    final BeanRegistry beanRegistry;
    final Map<Class<?>, Class<?>> implClasses;
    final Class<?>[] implKeyClasses;
    final Class<?>[] implValueClasses;
    final ClassLoader classLoader;
    final Locale locale;
    final TimeZone timeZone;
    final MediaType mediaType;
    final Map<String, String[]> includeProperties;
    final Map<String, String[]> excludeProperties;
    final Map<Class, ClassMeta> cmCache;
    final ClassMeta<Object> cmObject;
    final ClassMeta<String> cmString;
    final ClassMeta<Class> cmClass;
    final ReaderParser defaultParser;
    final String beanTypePropertyName;
    final int hashCode;

    static final void loadDefaults(PropertyStore config) {
        config.setProperty(BEAN_notBeanPackages, DEFAULT_NOTBEAN_PACKAGES);
        config.setProperty(BEAN_notBeanClasses, DEFAULT_NOTBEAN_CLASSES);
    }

    public BeanContext(PropertyStore ps) {
        super(ps);
        PropertyStore.PropertyMap pm = ps.getPropertyMap("BeanContext");
        this.hashCode = pm.hashCode();
        this.classLoader = ps.classLoader;
        this.defaultParser = ps.defaultParser;
        this.beansRequireDefaultConstructor = pm.get(BEAN_beansRequireDefaultConstructor, Boolean.TYPE, false);
        this.beansRequireSerializable = pm.get(BEAN_beansRequireSerializable, Boolean.TYPE, false);
        this.beansRequireSettersForGetters = pm.get(BEAN_beansRequireSettersForGetters, Boolean.TYPE, false);
        this.beansRequireSomeProperties = pm.get(BEAN_beansRequireSomeProperties, Boolean.TYPE, true);
        this.beanMapPutReturnsOldValue = pm.get(BEAN_beanMapPutReturnsOldValue, Boolean.TYPE, false);
        this.useInterfaceProxies = pm.get(BEAN_useInterfaceProxies, Boolean.TYPE, true);
        this.ignoreUnknownBeanProperties = pm.get(BEAN_ignoreUnknownBeanProperties, Boolean.TYPE, false);
        this.ignoreUnknownNullBeanProperties = pm.get(BEAN_ignoreUnknownNullBeanProperties, Boolean.TYPE, true);
        this.ignorePropertiesWithoutSetters = pm.get(BEAN_ignorePropertiesWithoutSetters, Boolean.TYPE, true);
        this.ignoreInvocationExceptionsOnGetters = pm.get(BEAN_ignoreInvocationExceptionsOnGetters, Boolean.TYPE, false);
        this.ignoreInvocationExceptionsOnSetters = pm.get(BEAN_ignoreInvocationExceptionsOnSetters, Boolean.TYPE, false);
        this.useJavaBeanIntrospector = pm.get(BEAN_useJavaBeanIntrospector, Boolean.TYPE, false);
        this.sortProperties = pm.get(BEAN_sortProperties, Boolean.TYPE, false);
        this.beanTypePropertyName = pm.get(BEAN_beanTypePropertyName, String.class, "_type");
        this.debug = ps.getProperty(BEAN_debug, Boolean.TYPE, false);
        this.beanConstructorVisibility = pm.get(BEAN_beanConstructorVisibility, Visibility.class, Visibility.PUBLIC);
        this.beanClassVisibility = pm.get(BEAN_beanClassVisibility, Visibility.class, Visibility.PUBLIC);
        this.beanMethodVisibility = pm.get(BEAN_methodVisibility, Visibility.class, Visibility.PUBLIC);
        this.beanFieldVisibility = pm.get(BEAN_beanFieldVisibility, Visibility.class, Visibility.PUBLIC);
        this.notBeanClasses = pm.get(BEAN_notBeanClasses, Class[].class, new Class[0]);
        LinkedList<String> l1 = new LinkedList<String>();
        LinkedList<String> l2 = new LinkedList<String>();
        for (String s : pm.get(BEAN_notBeanPackages, String[].class, new String[0])) {
            if (s.endsWith(".*")) {
                l2.add(s.substring(0, s.length() - 2));
                continue;
            }
            l1.add(s);
        }
        this.notBeanPackageNames = l1.toArray(new String[l1.size()]);
        this.notBeanPackagePrefixes = l2.toArray(new String[l2.size()]);
        LinkedList<BeanFilter> lbf = new LinkedList<BeanFilter>();
        for (Class c : pm.get(BEAN_beanFilters, Class[].class, new Class[0])) {
            if (ClassUtils.isParentClass(BeanFilter.class, c)) {
                lbf.add(ClassUtils.newInstance(BeanFilter.class, c, new Object[0]));
                continue;
            }
            if (ClassUtils.isParentClass(BeanFilterBuilder.class, c)) {
                lbf.add(ClassUtils.newInstance(BeanFilterBuilder.class, c, new Object[0]).build());
                continue;
            }
            lbf.add(new InterfaceBeanFilterBuilder(c).build());
        }
        this.beanFilters = lbf.toArray(new BeanFilter[0]);
        LinkedList<PojoSwap> lpf = new LinkedList<PojoSwap>();
        for (Class c : pm.get(BEAN_pojoSwaps, Class[].class, new Class[0])) {
            if (ClassUtils.isParentClass(PojoSwap.class, c)) {
                lpf.add(ClassUtils.newInstance(PojoSwap.class, c, new Object[0]));
                continue;
            }
            lpf.addAll(SurrogateSwap.findPojoSwaps(c));
        }
        this.pojoSwaps = lpf.toArray(new PojoSwap[0]);
        this.implClasses = new TreeMap(new ClassUtils.ClassComparator());
        Map<Class, Class> m = pm.getMap(BEAN_implClasses, Class.class, Class.class, null);
        if (m != null) {
            for (Map.Entry<Class, Class> e : m.entrySet()) {
                this.implClasses.put(e.getKey(), e.getValue());
            }
        }
        this.implKeyClasses = this.implClasses.keySet().toArray(new Class[0]);
        this.implValueClasses = this.implClasses.values().toArray(new Class[0]);
        Map<String, String[]> m2 = pm.getMap(BEAN_includeProperties, String.class, String[].class, null);
        this.includeProperties = m2 == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(m2);
        m2 = pm.getMap(BEAN_excludeProperties, String.class, String[].class, null);
        this.excludeProperties = m2 == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(m2);
        this.locale = pm.get(BEAN_locale, Locale.class, null);
        this.timeZone = pm.get(BEAN_timeZone, TimeZone.class, null);
        this.mediaType = pm.get(BEAN_mediaType, MediaType.class, null);
        if (!cmCacheCache.containsKey(this.hashCode)) {
            ConcurrentHashMap<Class, ClassMeta<Object>> cm = new ConcurrentHashMap<Class, ClassMeta<Object>>();
            cm.putIfAbsent(String.class, new ClassMeta<String>(String.class, this, null, null, this.findPojoSwap(String.class), this.findChildPojoSwaps(String.class)));
            cm.putIfAbsent(Object.class, new ClassMeta<Object>(Object.class, this, null, null, this.findPojoSwap(Object.class), this.findChildPojoSwaps(Object.class)));
            cmCacheCache.putIfAbsent(this.hashCode, cm);
        }
        this.cmCache = cmCacheCache.get(this.hashCode);
        this.cmString = this.cmCache.get(String.class);
        this.cmObject = this.cmCache.get(Object.class);
        this.cmClass = this.cmCache.get(Class.class);
        this.beanDictionaryClasses = pm.get(BEAN_beanDictionary, Class[].class, new Class[0]);
        this.beanRegistry = new BeanRegistry(this, null, new Class[0]);
    }

    public BeanSession createSession(ObjectMap op, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new BeanSession(this, op, locale, timeZone, mediaType);
    }

    public BeanSession createSession() {
        return new BeanSession(this, null, this.locale, this.timeZone, this.mediaType);
    }

    public final boolean hasSameCache(BeanContext bc) {
        return bc.cmCache == this.cmCache;
    }

    protected final boolean isNotABean(Class<?> c) {
        if (c.isArray() || c.isPrimitive() || c.isEnum() || c.isAnnotation()) {
            return true;
        }
        Package p = c.getPackage();
        if (p != null) {
            for (String string : this.notBeanPackageNames) {
                if (!p.getName().equals(string)) continue;
                return true;
            }
            for (String string : this.notBeanPackagePrefixes) {
                if (!p.getName().startsWith(string)) continue;
                return true;
            }
        }
        for (Class<?> clazz : this.notBeanClasses) {
            if (!ClassUtils.isParentClass(clazz, c)) continue;
            return true;
        }
        return false;
    }

    public boolean isBean(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClassMetaForObject(o).isBean();
    }

    protected static void dumpCacheStats() {
        try {
            int ctCount = 0;
            for (Map<Class, ClassMeta> cm : cmCacheCache.values()) {
                ctCount += cm.size();
            }
            System.out.println(StringUtils.format("ClassMeta cache: {0} instances in {1} caches", ctCount, cmCacheCache.size()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final <T> BeanMeta<T> getBeanMeta(Class<T> c) {
        if (c == null) {
            return null;
        }
        return this.getClassMeta(c).getBeanMeta();
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.getClassMeta(type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> ClassMeta<T> getClassMeta(Class<T> type, boolean waitForInit) {
        if (type.isArray() && this.findPojoSwap(type) == null) {
            return new ClassMeta<T>(type, this, this.findImplClass(type), this.findBeanFilter(type), this.findPojoSwap(type), this.findChildPojoSwaps(type));
        }
        if (this.cmCache == null) {
            return null;
        }
        ClassMeta<T> cm = this.cmCache.get(type);
        if (cm == null) {
            BeanContext beanContext = this;
            synchronized (beanContext) {
                cm = this.cmCache.get(type);
                if (cm == null) {
                    cm = new ClassMeta<T>(type, this, this.findImplClass(type), this.findBeanFilter(type), this.findPojoSwap(type), this.findChildPojoSwaps(type));
                }
            }
        }
        if (waitForInit) {
            cm.waitForInit();
        }
        return cm;
    }

    public final <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        ClassMeta cm;
        if (type == null) {
            return null;
        }
        ClassMeta classMeta = cm = type instanceof Class ? this.getClassMeta((Class)type) : this.resolveClassMeta(type, null);
        if (args.length == 0) {
            return cm;
        }
        ClassMeta[] cma = new ClassMeta[args.length + 1];
        cma[0] = cm;
        for (int i = 0; i < Array.getLength(args); ++i) {
            Type arg = (Type)Array.get(args, i);
            cma[i + 1] = arg instanceof Class ? this.getClassMeta((Class)arg) : this.resolveClassMeta(arg, null);
        }
        return this.getTypedClassMeta(cma, 0);
    }

    private ClassMeta<?> getTypedClassMeta(ClassMeta<?>[] c, int pos) {
        ClassMeta cm;
        if ((cm = c[pos++]).isCollection()) {
            ClassMeta<Object> ce = c.length == pos ? this.object() : this.getTypedClassMeta(c, pos);
            return ce.isObject() ? cm : new ClassMeta(cm, null, null, ce);
        }
        if (cm.isMap()) {
            ClassMeta<Object> ck = c.length == pos ? this.object() : c[pos++];
            ClassMeta<Object> cv = c.length == pos ? this.object() : this.getTypedClassMeta(c, pos);
            return ck.isObject() && cv.isObject() ? cm : new ClassMeta(cm, ck, cv, null);
        }
        return cm;
    }

    final ClassMeta resolveClassMeta(Type o, Map<Class<?>, Class<?>[]> typeVarImpls) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClassMeta) {
            ClassMeta cm = (ClassMeta)o;
            if (cm.getBeanContext() == this) {
                return cm;
            }
            if (cm.isMap()) {
                return this.getClassMeta(cm.innerClass, cm.getKeyType(), cm.getValueType());
            }
            if (cm.isCollection()) {
                return this.getClassMeta(cm.innerClass, cm.getElementType());
            }
            return this.getClassMeta(cm.innerClass);
        }
        Class c = this.resolve(o, typeVarImpls);
        if (c == null) {
            return this.object();
        }
        ClassMeta rawType = this.getClassMeta(c);
        if (rawType.isMap() || rawType.isCollection()) {
            ClassMeta[] params = this.findParameters(o, c);
            if (params == null) {
                return rawType;
            }
            if (rawType.isMap()) {
                if (params.length != 2) {
                    return rawType;
                }
                if (params[0].isObject() && params[1].isObject()) {
                    return rawType;
                }
                return new ClassMeta(rawType, params[0], params[1], null);
            }
            if (rawType.isCollection()) {
                if (params.length != 1) {
                    return rawType;
                }
                if (params[0].isObject()) {
                    return rawType;
                }
                return new ClassMeta(rawType, null, null, params[0]);
            }
        }
        return rawType;
    }

    final Class resolve(Type t, Map<Class<?>, Class<?>[]> typeVarImpls) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof GenericArrayType) {
            Type gatct = ((GenericArrayType)t).getGenericComponentType();
            if (gatct instanceof Class) {
                return Array.newInstance((Class)gatct, 0).getClass();
            }
            if (gatct instanceof ParameterizedType) {
                return Array.newInstance((Class)((ParameterizedType)gatct).getRawType(), 0).getClass();
            }
            if (gatct instanceof GenericArrayType) {
                return Array.newInstance(this.resolve(gatct, typeVarImpls), 0).getClass();
            }
            return null;
        }
        if (t instanceof TypeVariable && typeVarImpls != null) {
            TypeVariable tv = (TypeVariable)t;
            String varName = tv.getName();
            int varIndex = -1;
            Class gc = (Class)tv.getGenericDeclaration();
            TypeVariable<Class<T>>[] tvv = gc.getTypeParameters();
            for (int i = 0; i < tvv.length; ++i) {
                if (!tvv[i].getName().equals(varName)) continue;
                varIndex = i;
            }
            if (varIndex != -1) {
                if (!typeVarImpls.containsKey(gc)) {
                    return null;
                }
                return typeVarImpls.get(gc)[varIndex];
            }
        }
        return null;
    }

    final ClassMeta[] findParameters(Type o, Class c) {
        ParameterizedType pt;
        if (o == null) {
            o = c;
        }
        if (!(o instanceof ParameterizedType)) {
            block0: while (!((o = c.getGenericSuperclass()) instanceof ParameterizedType)) {
                for (Type t : c.getGenericInterfaces()) {
                    o = t;
                    if (o instanceof ParameterizedType) break block0;
                }
                if ((c = c.getSuperclass()) != null) continue;
            }
        }
        if (o instanceof ParameterizedType && !(pt = (ParameterizedType)o).getRawType().equals(Enum.class)) {
            LinkedList<ClassMeta> l = new LinkedList<ClassMeta>();
            for (Type pt2 : pt.getActualTypeArguments()) {
                if (pt2 instanceof WildcardType || pt2 instanceof TypeVariable) {
                    return null;
                }
                l.add(this.resolveClassMeta(pt2, null));
            }
            if (l.isEmpty()) {
                return null;
            }
            return l.toArray(new ClassMeta[l.size()]);
        }
        return null;
    }

    public final <T> ClassMeta<T> getClassMetaForObject(T o) {
        if (o == null) {
            return null;
        }
        return this.getClassMeta(o.getClass());
    }

    protected final <T> ClassMeta<T> resolveClassMeta(BeanProperty p, Type t, Map<Class<?>, Class<?>[]> typeVarImpls) {
        ClassMeta cm;
        ClassMeta cm2 = cm = this.resolveClassMeta(t, typeVarImpls);
        if (p != null) {
            if (p.type() != Object.class) {
                cm2 = this.resolveClassMeta(p.type(), typeVarImpls);
            }
            if (cm2.isMap()) {
                Class<?>[] pParams;
                Class<?>[] classArray;
                if (p.params().length == 0) {
                    Class[] classArray2 = new Class[2];
                    classArray2[0] = Object.class;
                    classArray = classArray2;
                    classArray2[1] = Object.class;
                } else {
                    classArray = pParams = p.params();
                }
                if (pParams.length != 2) {
                    throw new FormattedRuntimeException("Invalid number of parameters specified for Map (must be 2): {0}", pParams.length);
                }
                ClassMeta<?> keyType = this.resolveType(pParams[0], cm2.getKeyType(), cm.getKeyType());
                ClassMeta<?> valueType = this.resolveType(pParams[1], cm2.getValueType(), cm.getValueType());
                if (keyType.isObject() && valueType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2, keyType, valueType, null);
            }
            if (cm2.isCollection()) {
                Class<?>[] pParams;
                Class<?>[] classArray;
                if (p.params().length == 0) {
                    Class[] classArray3 = new Class[1];
                    classArray = classArray3;
                    classArray3[0] = Object.class;
                } else {
                    classArray = pParams = p.params();
                }
                if (pParams.length != 1) {
                    throw new FormattedRuntimeException("Invalid number of parameters specified for Collection (must be 1): {0}", pParams.length);
                }
                ClassMeta<?> elementType = this.resolveType(pParams[0], cm2.getElementType(), cm.getElementType());
                if (elementType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2, null, null, elementType);
            }
            return cm2;
        }
        return cm;
    }

    private ClassMeta<?> resolveType(Type ... t) {
        for (Type tt : t) {
            if (tt == null) continue;
            ClassMeta cm = this.getClassMeta(tt, new Type[0]);
            if (tt == this.cmObject) continue;
            return cm;
        }
        return this.cmObject;
    }

    private final <T> PojoSwap findPojoSwap(Class<T> c) {
        if (c != null) {
            for (PojoSwap<?, ?> f : this.pojoSwaps) {
                if (!ClassUtils.isParentClass(f.getNormalClass(), c)) continue;
                return f;
            }
        }
        return null;
    }

    private final PojoSwap[] findChildPojoSwaps(Class<?> c) {
        if (c == null || this.pojoSwaps.length == 0) {
            return null;
        }
        ArrayList l = null;
        for (PojoSwap<?, ?> f : this.pojoSwaps) {
            if (!ClassUtils.isParentClass(c, f.getNormalClass())) continue;
            if (l == null) {
                l = new ArrayList();
            }
            l.add(f);
        }
        return l == null ? null : l.toArray(new PojoSwap[l.size()]);
    }

    private final <T> BeanFilter findBeanFilter(Class<T> c) {
        if (c != null) {
            for (BeanFilter f : this.beanFilters) {
                if (!ClassUtils.isParentClass(f.getBeanClass(), c)) continue;
                return f;
            }
        }
        return null;
    }

    protected final String getBeanTypePropertyName() {
        return this.beanTypePropertyName;
    }

    protected final BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    protected final <T> Constructor<? extends T> getImplClassConstructor(Class<T> c, Visibility v) {
        if (this.implClasses.isEmpty()) {
            return null;
        }
        for (Class<T> cc = c; cc != null; cc = cc.getSuperclass()) {
            Class<?> implClass = this.implClasses.get(cc);
            if (implClass != null) {
                return ClassUtils.findNoArgConstructor(implClass, v);
            }
            for (Class<?> ic : cc.getInterfaces()) {
                implClass = this.implClasses.get(ic);
                if (implClass == null) continue;
                return ClassUtils.findNoArgConstructor(implClass, v);
            }
        }
        return null;
    }

    private final <T> Class<? extends T> findImplClass(Class<T> c) {
        if (this.implClasses.isEmpty()) {
            return null;
        }
        for (Class<T> cc = c; cc != null; cc = cc.getSuperclass()) {
            Class<?> implClass = this.implClasses.get(cc);
            if (implClass != null) {
                return implClass;
            }
            for (Class<?> ic : cc.getInterfaces()) {
                implClass = this.implClasses.get(ic);
                if (implClass == null) continue;
                return implClass;
            }
        }
        return null;
    }

    public String[] getIncludeProperties(Class<?> c) {
        if (this.includeProperties.isEmpty()) {
            return null;
        }
        String[] s = null;
        Iterator<Class<?>> i = ClassUtils.getParentClasses(c, false, true);
        while (i.hasNext()) {
            Class<?> c2 = i.next();
            s = this.includeProperties.get(c2.getName());
            if (s != null) {
                return s;
            }
            s = this.includeProperties.get(c2.getSimpleName());
            if (s == null) continue;
            return s;
        }
        return this.includeProperties.get("*");
    }

    public String[] getExcludeProperties(Class<?> c) {
        if (this.excludeProperties.isEmpty()) {
            return null;
        }
        String[] s = null;
        Iterator<Class<?>> i = ClassUtils.getParentClasses(c, false, true);
        while (i.hasNext()) {
            Class<?> c2 = i.next();
            s = this.excludeProperties.get(c2.getName());
            if (s != null) {
                return s;
            }
            s = this.excludeProperties.get(c2.getSimpleName());
            if (s == null) continue;
            return s;
        }
        return this.excludeProperties.get("*");
    }

    protected final ClassMeta<Object> object() {
        return this.cmObject;
    }

    protected final ClassMeta<String> string() {
        return this.cmString;
    }

    protected final ClassMeta<Class> _class() {
        return this.cmClass;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BeanContext) {
            return ((BeanContext)o).hashCode == this.hashCode;
        }
        return false;
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("BeanContext", new ObjectMap().append("id", System.identityHashCode(this)).append("beansRequireDefaultConstructor", this.beansRequireDefaultConstructor).append("beansRequireSerializable", this.beansRequireSerializable).append("beansRequireSettersForGetters", this.beansRequireSettersForGetters).append("beansRequireSomeProperties", this.beansRequireSomeProperties).append("beanMapPutReturnsOldValue", this.beanMapPutReturnsOldValue).append("beanConstructorVisibility", (Object)this.beanConstructorVisibility).append("beanClassVisibility", (Object)this.beanClassVisibility).append("beanMethodVisibility", (Object)this.beanMethodVisibility).append("beanFieldVisibility", (Object)this.beanFieldVisibility).append("useInterfaceProxies", this.useInterfaceProxies).append("ignoreUnknownBeanProperties", this.ignoreUnknownBeanProperties).append("ignoreUnknownNullBeanProperties", this.ignoreUnknownNullBeanProperties).append("ignorePropertiesWithoutSetters", this.ignorePropertiesWithoutSetters).append("ignoreInvocationExceptionsOnGetters", this.ignoreInvocationExceptionsOnGetters).append("ignoreInvocationExceptionsOnSetters", this.ignoreInvocationExceptionsOnSetters).append("useJavaBeanIntrospector", this.useJavaBeanIntrospector).append("beanFilters", this.beanFilters).append("pojoSwaps", this.pojoSwaps).append("notBeanClasses", this.notBeanClasses).append("implClasses", this.implClasses).append("sortProperties", this.sortProperties).append("locale", this.locale).append("timeZone", this.timeZone).append("mediaType", this.mediaType).append("includeProperties", this.includeProperties).append("excludeProperties", this.excludeProperties));
    }
}

