/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.StringSwap;

public class XMLGregorianCalendarSwap
extends StringSwap<XMLGregorianCalendar> {
    private DatatypeFactory dtf;

    public XMLGregorianCalendarSwap() {
        try {
            this.dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String swap(BeanSession session, XMLGregorianCalendar b) throws SerializeException {
        return b.toXMLFormat();
    }

    @Override
    public XMLGregorianCalendar unswap(BeanSession session, String s, ClassMeta<?> hint) throws ParseException {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        return this.dtf.newXMLGregorianCalendar(s);
    }
}

