/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.io.IOException;
import java.io.Reader;
import org.apache.juneau.BeanSession;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.XmlParser;

public class ReaderSwap
extends PojoSwap<Reader, Object> {
    private ReaderParser parser;

    public ReaderSwap(ReaderParser parser) {
        this.parser = parser;
    }

    @Override
    public Object swap(BeanSession session, Reader o) throws SerializeException {
        try {
            if (this.parser == null) {
                return IOUtils.read(o);
            }
            return this.parser.parse((Object)o, Object.class);
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
        catch (Exception e) {
            throw new SerializeException("ReaderSwap could not transform object of type ''{0}''", o == null ? null : o.getClass().getName()).initCause(e);
        }
    }

    public static class PlainText
    extends ReaderSwap {
        public PlainText() {
            super(null);
        }
    }

    public static class Html
    extends ReaderSwap {
        public Html() {
            super(HtmlParser.DEFAULT);
        }
    }

    public static class Xml
    extends ReaderSwap {
        public Xml() {
            super(XmlParser.DEFAULT);
        }
    }

    public static class Json
    extends ReaderSwap {
        public Json() {
            super(JsonParser.DEFAULT);
        }
    }
}

