/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;

public abstract class PojoSwap<T, S> {
    public static final PojoSwap NULL = new PojoSwap(null, null){};
    private final Class<T> normalClass;
    private final Class<?> swapClass;
    private ClassMeta<?> swapClassMeta;

    protected PojoSwap() {
        this.normalClass = ClassUtils.resolveParameterType(PojoSwap.class, 0, this.getClass());
        this.swapClass = ClassUtils.resolveParameterType(PojoSwap.class, 1, this.getClass());
    }

    protected PojoSwap(Class<T> normalClass, Class<?> swapClass) {
        this.normalClass = normalClass;
        this.swapClass = swapClass;
    }

    public S swap(BeanSession session, T o) throws SerializeException {
        throw new SerializeException("Swap method not implemented on PojoSwap ''{0}''", this.getClass().getName());
    }

    public T unswap(BeanSession session, S f, ClassMeta<?> hint) throws ParseException {
        throw new ParseException("Unswap method not implemented on PojoSwap ''{0}''", this.getClass().getName());
    }

    public Class<T> getNormalClass() {
        return this.normalClass;
    }

    public Class<?> getSwapClass() {
        return this.swapClass;
    }

    public ClassMeta<?> getSwapClassMeta(BeanContext beanContext) {
        if (this.swapClassMeta == null) {
            this.swapClassMeta = beanContext.getClassMeta(this.swapClass);
        }
        return this.swapClassMeta;
    }

    public boolean isNormalObject(Object o) {
        if (o == null) {
            return false;
        }
        return ClassUtils.isParentClass(this.normalClass, o.getClass());
    }

    public boolean isSwappedObject(Object o) {
        if (o == null) {
            return false;
        }
        return ClassUtils.isParentClass(this.swapClass, o.getClass());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '<' + this.getNormalClass().getSimpleName() + "," + this.getSwapClass().getSimpleName() + '>';
    }
}

