/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.soap;

import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlWriter;

@Produces(value="text/xml+soap", contentType="text/xml")
public final class SoapXmlSerializer
extends XmlSerializer {
    public SoapXmlSerializer(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        XmlSerializerSession s = (XmlSerializerSession)session;
        XmlWriter w = s.getWriter();
        w.append("<?xml").attr("version", "1.0").attr("encoding", "UTF-8").appendln("?>");
        w.oTag("soap", "Envelope").attr("xmlns", "soap", (Object)s.getProperty("SoapXmlSerializer.SOAPAction", "http://www.w3.org/2003/05/soap-envelope")).appendln(">");
        w.sTag(1, "soap", "Body").nl(1);
        s.indent += 2;
        super.doSerialize(s, o);
        w.ie(1).eTag("soap", "Body").nl(1);
        w.eTag("soap", "Envelope").nl(0);
    }

    @Override
    public ObjectMap getResponseHeaders(ObjectMap properties) {
        return new ObjectMap((Map<?, ?>)super.getResponseHeaders(properties)).append("SOAPAction", properties.getString("SoapXmlSerializer.SOAPAction", "http://www.w3.org/2003/05/soap-envelope"));
    }
}

