/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.serializer.SerializerListener;

public class SerializerContext
extends BeanContext {
    public static final String SERIALIZER_maxDepth = "Serializer.maxDepth";
    public static final String SERIALIZER_initialDepth = "Serializer.initialDepth";
    public static final String SERIALIZER_detectRecursions = "Serializer.detectRecursions";
    public static final String SERIALIZER_ignoreRecursions = "Serializer.ignoreRecursions";
    public static final String SERIALIZER_useWhitespace = "Serializer.useWhitespace";
    public static final String SERIALIZER_maxIndent = "Serializer.maxIndent";
    public static final String SERIALIZER_addBeanTypeProperties = "Serializer.addBeanTypeProperties";
    public static final String SERIALIZER_quoteChar = "Serializer.quoteChar";
    public static final String SERIALIZER_trimNullProperties = "Serializer.trimNullProperties";
    public static final String SERIALIZER_trimEmptyCollections = "Serializer.trimEmptyLists";
    public static final String SERIALIZER_trimEmptyMaps = "Serializer.trimEmptyMaps";
    public static final String SERIALIZER_trimStrings = "Serializer.trimStrings";
    public static final String SERIALIZER_uriContext = "Serializer.uriContext";
    public static final String SERIALIZER_uriResolution = "Serializer.uriResolution";
    public static final String SERIALIZER_uriRelativity = "Serializer.uriRelativity";
    public static final String SERIALIZER_sortCollections = "Serializer.sortCollections";
    public static final String SERIALIZER_sortMaps = "Serializer.sortMaps";
    public static final String SERIALIZER_abridged = "Serializer.abridged";
    public static final String SERIALIZER_listener = "Serializer.listener";
    final int maxDepth;
    final int initialDepth;
    final int maxIndent;
    final boolean detectRecursions;
    final boolean ignoreRecursions;
    final boolean useWhitespace;
    final boolean addBeanTypeProperties;
    final boolean trimNulls;
    final boolean trimEmptyCollections;
    final boolean trimEmptyMaps;
    final boolean trimStrings;
    final boolean sortCollections;
    final boolean sortMaps;
    final boolean abridged;
    final char quoteChar;
    final UriContext uriContext;
    final UriResolution uriResolution;
    final UriRelativity uriRelativity;
    final Class<? extends SerializerListener> listener;

    public SerializerContext(PropertyStore ps) {
        super(ps);
        this.maxDepth = ps.getProperty(SERIALIZER_maxDepth, Integer.TYPE, 100);
        this.initialDepth = ps.getProperty(SERIALIZER_initialDepth, Integer.TYPE, 0);
        this.detectRecursions = ps.getProperty(SERIALIZER_detectRecursions, Boolean.TYPE, false);
        this.ignoreRecursions = ps.getProperty(SERIALIZER_ignoreRecursions, Boolean.TYPE, false);
        this.useWhitespace = ps.getProperty(SERIALIZER_useWhitespace, Boolean.TYPE, false);
        this.maxIndent = ps.getProperty(SERIALIZER_maxIndent, Integer.TYPE, 100);
        this.addBeanTypeProperties = ps.getProperty(SERIALIZER_addBeanTypeProperties, Boolean.TYPE, true);
        this.trimNulls = ps.getProperty(SERIALIZER_trimNullProperties, Boolean.TYPE, true);
        this.trimEmptyCollections = ps.getProperty(SERIALIZER_trimEmptyCollections, Boolean.TYPE, false);
        this.trimEmptyMaps = ps.getProperty(SERIALIZER_trimEmptyMaps, Boolean.TYPE, false);
        this.trimStrings = ps.getProperty(SERIALIZER_trimStrings, Boolean.TYPE, false);
        this.sortCollections = ps.getProperty(SERIALIZER_sortCollections, Boolean.TYPE, false);
        this.sortMaps = ps.getProperty(SERIALIZER_sortMaps, Boolean.TYPE, false);
        this.abridged = ps.getProperty(SERIALIZER_abridged, Boolean.TYPE, false);
        this.quoteChar = ps.getProperty(SERIALIZER_quoteChar, String.class, "\"").charAt(0);
        this.uriContext = ps.getProperty(SERIALIZER_uriContext, UriContext.class, UriContext.DEFAULT);
        this.uriResolution = ps.getProperty(SERIALIZER_uriResolution, UriResolution.class, UriResolution.NONE);
        this.uriRelativity = ps.getProperty(SERIALIZER_uriRelativity, UriRelativity.class, UriRelativity.RESOURCE);
        this.listener = ps.getProperty(SERIALIZER_listener, Class.class, null);
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("SerializerContext", new ObjectMap().append("maxDepth", this.maxDepth).append("initialDepth", this.initialDepth).append("detectRecursions", this.detectRecursions).append("ignoreRecursions", this.ignoreRecursions).append("useWhitespace", this.useWhitespace).append("maxIndent", this.maxIndent).append("addBeanTypeProperties", this.addBeanTypeProperties).append("trimNulls", this.trimNulls).append("trimEmptyCollections", this.trimEmptyCollections).append("trimEmptyMaps", this.trimEmptyMaps).append("trimStrings", this.trimStrings).append("sortCollections", this.sortCollections).append("sortMaps", this.sortMaps).append("parserKnowsRootTypes", this.abridged).append("quoteChar", Character.valueOf(this.quoteChar)).append("uriContext", this.uriContext).append("uriResolution", (Object)this.uriResolution).append("uriRelativity", (Object)this.uriRelativity).append("listener", this.listener));
    }
}

