/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.widget;

import java.io.IOException;
import java.util.Locale;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.utils.ResourceFinder;

public abstract class Widget {
    private final ResourceFinder resourceFinder = new ResourceFinder(this.getClass());

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getHtml(RestRequest req) throws Exception {
        return null;
    }

    public String getScript(RestRequest req) throws Exception {
        return null;
    }

    public String getStyle(RestRequest req) throws Exception {
        return null;
    }

    protected String getResourceAsString(String name) throws IOException {
        return this.resourceFinder.getResourceAsString(name);
    }

    protected String getResourceAsString(String name, Locale locale) throws IOException {
        return this.resourceFinder.getResourceAsString(name, locale);
    }

    protected String loadScript(String name) throws IOException {
        String s = this.getResourceAsString(name);
        if (s != null) {
            s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
        }
        return s;
    }

    protected String loadStyle(String name) throws IOException {
        String s = this.getResourceAsString(name);
        if (s != null) {
            s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
        }
        return s;
    }

    protected String loadHtml(String name) throws IOException {
        String s = this.getResourceAsString(name);
        if (s != null) {
            s = s.replaceAll("(?s)<!--(.*?)-->\\s*", "");
        }
        return s;
    }
}

