/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.AMap;

public final class RestUtils {
    private static Map<Integer, String> httpMsgs = new AMap<Integer, String>().append(200, "OK").append(201, "Created").append(202, "Accepted").append(203, "Non-Authoritative Information").append(204, "No Content").append(205, "Reset Content").append(206, "Partial Content").append(300, "Multiple Choices").append(301, "Moved Permanently").append(302, "Temporary Redirect").append(303, "See Other").append(304, "Not Modified").append(305, "Use Proxy").append(307, "Temporary Redirect").append(400, "Bad Request").append(401, "Unauthorized").append(402, "Payment Required").append(403, "Forbidden").append(404, "Not Found").append(405, "Method Not Allowed").append(406, "Not Acceptable").append(407, "Proxy Authentication Required").append(408, "Request Time-Out").append(409, "Conflict").append(410, "Gone").append(411, "Length Required").append(412, "Precondition Failed").append(413, "Request Entity Too Large").append(414, "Request-URI Too Large").append(415, "Unsupported Media Type").append(500, "Internal Server Error").append(501, "Not Implemented").append(502, "Bad Gateway").append(503, "Service Unavailable").append(504, "Gateway Timeout").append(505, "HTTP Version Not Supported");
    private static final Pattern INDEXED_LINK_PATTERN = Pattern.compile("(?s)(\\S*)\\[(\\d+)\\]\\:(.*)");

    public static String getHttpResponseText(int rc) {
        return httpMsgs.get(rc);
    }

    public static String getPathInfoUndecoded(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        int l = contextPath.length() + servletPath.length();
        if (requestURI.length() == l) {
            return null;
        }
        return requestURI.substring(l);
    }

    public static StringBuffer trimPathInfo(StringBuffer requestURI, String contextPath, String servletPath) {
        if (servletPath.equals("/")) {
            servletPath = "";
        }
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        try {
            int sc = 0;
            for (int i = 0; i < requestURI.length(); ++i) {
                int c = requestURI.charAt(i);
                if (c == 47) {
                    int j;
                    if (++sc != 3) continue;
                    if (servletPath.isEmpty()) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    for (j = 0; j < contextPath.length(); ++j) {
                        if (requestURI.charAt(i) != contextPath.charAt(j)) {
                            throw new Exception("case=1");
                        }
                        ++i;
                    }
                    for (j = 0; j < servletPath.length(); ++j) {
                        if (requestURI.charAt(i) != servletPath.charAt(j)) {
                            throw new Exception("case=2");
                        }
                        ++i;
                    }
                    int n = c = requestURI.length() == i ? 47 : (int)requestURI.charAt(i);
                    if (c == 47 || c == 63) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    throw new Exception("case=3");
                }
                if (c != 63) continue;
                if (sc != 2) {
                    throw new Exception("case=4");
                }
                if (servletPath.isEmpty()) {
                    requestURI.setLength(i);
                    return requestURI;
                }
                throw new Exception("case=5");
            }
            if (servletPath.isEmpty()) {
                return requestURI;
            }
            throw new Exception("case=6");
        }
        catch (Exception e) {
            throw new FormattedRuntimeException(e, "Could not find servlet path in request URI.  URI=''{0}'', servletPath=''{1}''", requestURI, servletPath);
        }
    }

    static String[] parseHeader(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim().toLowerCase(Locale.ENGLISH);
        String val = s.substring(i + 1).trim();
        return new String[]{name, val};
    }

    static String[] parseKeyValuePair(String s) {
        int i = -1;
        for (int j = 0; j < s.length() && i < 0; ++j) {
            s.indexOf(58);
            char c = s.charAt(j);
            if (c != '=' && c != ':') continue;
            i = j;
        }
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim();
        String val = s.substring(i + 1).trim();
        return new String[]{name, val};
    }

    static String resolveNewlineSeparatedAnnotation(String[] value, String fromParent) {
        if (value.length == 0) {
            return fromParent;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String v : value) {
            if (!"INHERIT".equals(v)) {
                l.add(v);
                continue;
            }
            if (fromParent == null) continue;
            l.addAll(Arrays.asList(fromParent));
        }
        return StringUtils.join(l, '\n');
    }

    static String[] resolveLinks(String[] links, String[] parentLinks) {
        if (links.length == 0) {
            return parentLinks;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String l : links) {
            if ("INHERIT".equals(l)) {
                list.addAll(Arrays.asList(parentLinks));
                continue;
            }
            if (l.indexOf(91) != -1 && INDEXED_LINK_PATTERN.matcher(l).matches()) {
                Matcher lm = INDEXED_LINK_PATTERN.matcher(l);
                lm.matches();
                String key = lm.group(1);
                int index = Math.min(list.size(), Integer.parseInt(lm.group(2)));
                String remainder = lm.group(3);
                list.add(index, key.isEmpty() ? remainder : key + ":" + remainder);
                continue;
            }
            list.add(l);
        }
        return list.toArray(new String[list.size()]);
    }
}

