/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.UriResolver;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.http.HttpMethod;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.MediaTypeRange;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.rest.CallMethod;
import org.apache.juneau.rest.ReaderResource;
import org.apache.juneau.rest.RequestBody;
import org.apache.juneau.rest.RequestFormData;
import org.apache.juneau.rest.RequestHeaders;
import org.apache.juneau.rest.RequestPathMatch;
import org.apache.juneau.rest.RequestQuery;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.utils.MessageBundle;

public final class RestRequest
extends HttpServletRequestWrapper {
    private final RestContext context;
    private final String method;
    private final String stylesheet;
    private RequestBody body;
    private Method javaMethod;
    private ObjectMap properties;
    private SerializerGroup serializerGroup;
    private ParserGroup parserGroup;
    private final boolean debug;
    private UrlEncodingParser urlEncodingParser;
    private BeanSession beanSession;
    private VarResolverSession varSession;
    private final RequestQuery queryParams;
    private RequestFormData formData;
    private Map<String, String> defFormData;
    private RequestPathMatch pathParams;
    private boolean isPost;
    private UriContext uriContext;
    private String charset;
    private String defaultCharset;
    private RequestHeaders headers;
    private ConfigFile cf;
    private Swagger swagger;
    private Swagger fileSwagger;
    private Map<String, Widget> widgets;

    RestRequest(RestContext context, HttpServletRequest req) throws ServletException {
        super(req);
        this.context = context;
        try {
            String b;
            this.isPost = req.getMethod().equalsIgnoreCase("POST");
            this.queryParams = new RequestQuery();
            if (this.isPost) {
                context.getUrlEncodingParser().parseIntoSimpleMap(this.getQueryString(), this.queryParams);
            } else {
                this.queryParams.putAll(req.getParameterMap());
            }
            String _method = super.getMethod();
            String m = this.getQuery().getString("method");
            if (context.allowMethodParam(m)) {
                _method = m;
            }
            this.method = _method;
            this.stylesheet = this.getQuery().getString("stylesheet");
            this.headers = new RequestHeaders();
            Enumeration e = this.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.headers.put(name, super.getHeaders(name));
            }
            this.body = new RequestBody(this);
            if (context.isAllowBodyParam() && (b = this.getQuery().getString("body")) != null) {
                this.headers.put("Content-Type", UonSerializer.DEFAULT.getResponseContentType());
                this.body.load(b.getBytes(IOUtils.UTF8));
            }
            if (context.isAllowHeaderParams()) {
                this.headers.setQueryParams(this.queryParams);
            }
            this.debug = "true".equals(this.getQuery().getString("debug", "false")) || "true".equals(this.getHeaders().getString("Debug", "false"));
            this.pathParams = new RequestPathMatch();
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    final void init(Method javaMethod, ObjectMap properties, Map<String, String> defHeader, Map<String, String> defQuery, Map<String, String> defFormData, String defaultCharset, SerializerGroup mSerializers, ParserGroup mParsers, UrlEncodingParser mUrlEncodingParser, BeanContext beanContext, EncoderGroup encoders, Map<String, Widget> widgets) {
        this.javaMethod = javaMethod;
        this.properties = properties;
        this.urlEncodingParser = mUrlEncodingParser;
        this.beanSession = beanContext.createSession();
        this.pathParams.setParser(this.urlEncodingParser).setBeanSession(this.beanSession);
        this.queryParams.addDefault(defQuery).setParser(this.urlEncodingParser).setBeanSession(this.beanSession);
        this.headers.addDefault(defHeader).addDefault(this.context.getDefaultRequestHeaders()).setParser(this.urlEncodingParser).setBeanSession(this.beanSession);
        this.body.setEncoders(encoders).setParsers(mParsers).setHeaders(this.headers).setBeanSession(this.beanSession).setUrlEncodingParser(mUrlEncodingParser);
        this.serializerGroup = mSerializers;
        this.parserGroup = mParsers;
        this.defaultCharset = defaultCharset;
        this.defFormData = defFormData;
        this.widgets = widgets;
        if (this.debug) {
            String msg = "\n=== HTTP Request (incoming) ====================================================" + this.toString() + "\n=== END ========================================================================";
            this.context.getLogger().log(Level.WARNING, msg, new Object[0]);
        }
    }

    public String getDescription() {
        String qs = this.getQueryString();
        return "HTTP " + this.getMethod() + " " + this.getRequestURI() + (qs == null ? "" : "?" + qs);
    }

    public Object getAttribute(String name, Object def) {
        Object o = super.getAttribute(name);
        return o == null ? def : o;
    }

    public RestRequest attr(String name, Object value) {
        this.setAttribute(name, value);
        return this;
    }

    public Object resolveProperty(CallMethod cm, String category, String name) {
        char c = category.charAt(0);
        if (c == 'A') {
            if ("Attribute".equals(category)) {
                return this.getAttribute(name);
            }
        } else if (c == 'F') {
            if ("FormData".equals(category)) {
                return this.getFormData(name);
            }
        } else if (c == 'H') {
            if ("Header".equals(category)) {
                return this.getHeader(name);
            }
            if ("HtmlDocSerializer".equals(category) && cm != null) {
                char c2 = StringUtils.charAt(name, 0);
                if (c2 == 'a') {
                    if ("aside".equals(name)) {
                        return cm.htmlAside == null ? null : this.resolveVars(cm.htmlAside);
                    }
                } else if (c2 == 'f') {
                    if ("footer".equals(name)) {
                        return cm.htmlFooter == null ? null : this.resolveVars(cm.htmlFooter);
                    }
                } else if (c2 == 'h') {
                    if ("header".equals(name)) {
                        return cm.htmlHeader == null ? null : this.resolveVars(cm.htmlHeader);
                    }
                } else if (c2 == 'l') {
                    if ("links.list".equals(name)) {
                        if (cm.htmlLinks == null || cm.htmlLinks.length == 0) {
                            return null;
                        }
                        try {
                            ArrayList<String> la = new ArrayList<String>();
                            for (String l : cm.htmlLinks) {
                                if (l.startsWith("{")) {
                                    ObjectMap m = new ObjectMap(l);
                                    for (Map.Entry<String, Object> e : m.entrySet()) {
                                        la.add(this.resolveVars(e.getKey()) + ":" + this.resolveVars(StringUtils.toString(e.getValue())));
                                    }
                                    continue;
                                }
                                la.add(this.resolveVars(l));
                            }
                            return la;
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                    }
                } else if (c2 == 'n') {
                    if ("nav".equals(name)) {
                        return cm.htmlNav == null ? null : this.resolveVars(cm.htmlNav);
                    }
                    if ("noResultsMessage".equals(name)) {
                        return cm.htmlNoResultsMessage == null ? null : this.resolveVars(cm.htmlNoResultsMessage);
                    }
                    if ("nowrap".equals(name)) {
                        return cm.htmlNoWrap;
                    }
                } else if (c2 == 's') {
                    if ("script.list".equals(name)) {
                        LinkedHashSet<String> l = new LinkedHashSet<String>();
                        if (cm.htmlScript != null) {
                            l.add(this.resolveVars(cm.htmlScript));
                        }
                        for (Widget w : this.getWidgets().values()) {
                            String script;
                            try {
                                script = w.getScript(this);
                            }
                            catch (Exception e) {
                                script = e.getLocalizedMessage();
                            }
                            if (script == null) continue;
                            l.add(this.resolveVars(script));
                        }
                        return l;
                    }
                    if ("style.list".equals(name)) {
                        LinkedHashSet<String> l = new LinkedHashSet<String>();
                        if (cm.htmlStyle != null) {
                            l.add(this.resolveVars(cm.htmlStyle));
                        }
                        for (Widget w : this.getWidgets().values()) {
                            String style;
                            try {
                                style = w.getStyle(this);
                            }
                            catch (Exception e) {
                                style = e.getLocalizedMessage();
                            }
                            if (style == null) continue;
                            l.add(this.resolveVars(style));
                        }
                        return l;
                    }
                    if ("stylesheet".equals(name)) {
                        String s = this.getStylesheet();
                        if (s == null || StringUtils.isAbsoluteUri(s)) {
                            s = cm.htmlStylesheet;
                        }
                        return s == null ? null : this.resolveVars(s);
                    }
                } else if (c2 == 't' && "template".equals(name)) {
                    return cm.htmlTemplate;
                }
            }
        } else if (c == 'P') {
            if ("Path".equals(category)) {
                return this.getPath(name);
            }
        } else if (c == 'Q') {
            if ("Query".equals(category)) {
                return this.getQuery(name);
            }
        } else if (c == 'R' && "Request".equals(category)) {
            char c2 = StringUtils.charAt(name, 0);
            if (c == 'c') {
                if ("contextPath".equals(name)) {
                    return this.getContextPath();
                }
            } else if (c2 == 'm') {
                if ("method".equals(name)) {
                    return this.getMethod();
                }
                if ("methodDescription".equals(name)) {
                    return this.getMethodDescription();
                }
                if ("methodSummary".equals(name)) {
                    return this.getMethodSummary();
                }
            } else if (c2 == 'p') {
                if ("pathInfo".equals(name)) {
                    return this.getPathInfo();
                }
            } else if (c2 == 'r') {
                if ("requestParentURI".equals(name)) {
                    return this.getUriContext().getRootRelativePathInfoParent();
                }
                if ("requestURI".equals(name)) {
                    return this.getRequestURI();
                }
            } else if (c2 == 's') {
                if ("servletClass".equals(name)) {
                    return this.getContext().getResource().getClass().getName();
                }
                if ("servletClassSimple".equals(name)) {
                    return this.getContext().getResource().getClass().getSimpleName();
                }
                if ("servletDescription".equals(name)) {
                    return this.getServletDescription();
                }
                if ("servletParentURI".equals(name)) {
                    return this.getUriContext().getRootRelativeServletPathParent();
                }
                if ("servletPath".equals(name)) {
                    return this.getServletPath();
                }
                if ("servletTitle".equals(name)) {
                    return this.getServletTitle();
                }
                if ("servletURI".equals(name)) {
                    return this.getUriContext().getRootRelativeServletPath();
                }
                if ("siteName".equals(name)) {
                    return this.getSiteName();
                }
            }
        }
        return null;
    }

    RestRequest setProperties(ObjectMap properties) {
        this.properties = properties;
        return this;
    }

    public ObjectMap getProperties() {
        return this.properties;
    }

    public RestRequest prop(String name, Object value) {
        this.properties.append(name, value);
        return this;
    }

    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.getHeaders().getString(name);
    }

    public Enumeration<String> getHeaders(String name) {
        String[] v = (String[])this.headers.get(name);
        if (v == null || v.length == 0) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(Arrays.asList(v));
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.parserGroup.getSupportedMediaTypes();
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public String getCharacterEncoding() {
        if (this.charset == null) {
            int i;
            String h = this.getHeader("Content-Type");
            if (h != null && (i = h.indexOf(";charset=")) > 0) {
                this.charset = h.substring(i + 9).trim();
            }
            if (this.charset == null) {
                this.charset = this.defaultCharset;
            }
            if (!Charset.isSupported(this.charset)) {
                throw new RestException(415, "Unsupported charset in header ''Content-Type'': ''{0}''", h);
            }
        }
        return this.charset;
    }

    public Locale getLocale() {
        MediaTypeRange[] mr;
        String h = this.headers.getString("Accept-Language");
        if (h != null && (mr = MediaTypeRange.parse(h)).length > 0) {
            return RestRequest.toLocale(mr[0].getMediaType().getType());
        }
        return super.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        MediaTypeRange[] mr;
        String h = this.headers.getString("Accept-Language");
        if (h != null && (mr = MediaTypeRange.parse(h)).length > 0) {
            ArrayList<Locale> l = new ArrayList<Locale>(mr.length);
            for (MediaTypeRange r : mr) {
                l.add(RestRequest.toLocale(r.getMediaType().getType()));
            }
            return Collections.enumeration(l);
        }
        return super.getLocales();
    }

    public RequestQuery getQuery() {
        return this.queryParams;
    }

    public String getQuery(String name) {
        return this.getQuery().getString(name);
    }

    public RequestFormData getFormData() {
        try {
            if (this.formData == null) {
                this.formData = new RequestFormData();
                this.formData.setParser(this.urlEncodingParser).setBeanSession(this.beanSession);
                if (!this.body.isLoaded()) {
                    this.formData.putAll(this.getParameterMap());
                } else {
                    Map m = (Map)this.urlEncodingParser.parse(this.body.getReader(), (Type)((Object)Map.class), new Type[]{String.class, String.class});
                    for (Map.Entry e : m.entrySet()) {
                        this.formData.put((String)e.getKey(), e.getValue());
                    }
                }
            }
            this.formData.addDefault(this.defFormData);
            return this.formData;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    public String getFormData(String name) {
        return this.getFormData().getString(name);
    }

    public RequestPathMatch getPathMatch() {
        return this.pathParams;
    }

    public String getPath(String name) {
        return (String)this.getPathMatch().get(name);
    }

    public RequestBody getBody() {
        return this.body;
    }

    public BufferedReader getReader() throws IOException {
        return this.getBody().getReader();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.getBody().getInputStream();
    }

    ServletInputStream getRawInputStream() throws IOException {
        return super.getInputStream();
    }

    public UriContext getUriContext() {
        if (this.uriContext == null) {
            String scheme = this.getScheme();
            int port = this.getServerPort();
            StringBuilder authority = new StringBuilder(this.getScheme()).append("://").append(this.getServerName());
            if (!(port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
                authority.append(':').append(port);
            }
            this.uriContext = new UriContext(authority.toString(), super.getContextPath(), super.getServletPath(), super.getPathInfo());
        }
        return this.uriContext;
    }

    public UriResolver getUriResolver(UriResolution resolution, UriRelativity relativity) {
        return new UriResolver(resolution, relativity, this.getUriContext());
    }

    public UriResolver getUriResolver() {
        return new UriResolver(UriResolution.ROOT_RELATIVE, UriRelativity.RESOURCE, this.getUriContext());
    }

    public URI getUri(boolean includeQuery, Map<String, ?> addQueryParams) {
        String uri = this.getRequestURI();
        if (includeQuery || addQueryParams != null) {
            StringBuilder sb = new StringBuilder(uri);
            RequestQuery rq = this.queryParams.copy();
            if (addQueryParams != null) {
                for (Map.Entry<String, ?> e : addQueryParams.entrySet()) {
                    rq.put(e.getKey(), e.getValue());
                }
            }
            if (!rq.isEmpty()) {
                sb.append('?').append(rq.toQueryString());
            }
            uri = sb.toString();
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSiteName() {
        return this.context.getInfoProvider().getSiteName(this);
    }

    public String getServletTitle() {
        return this.context.getInfoProvider().getTitle(this);
    }

    public String getServletDescription() {
        return this.context.getInfoProvider().getDescription(this);
    }

    public String getMethodSummary() {
        return this.context.getInfoProvider().getMethodSummary(this.javaMethod.getName(), this);
    }

    public String getMethodDescription() {
        return this.context.getInfoProvider().getMethodDescription(this.javaMethod.getName(), this);
    }

    protected String getStylesheet() {
        return this.stylesheet;
    }

    public SerializerGroup getSerializerGroup() {
        return this.serializerGroup;
    }

    public ParserGroup getParserGroup() {
        return this.parserGroup;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpMethod getHttpMethod() {
        return HttpMethod.forString(this.method);
    }

    public int getContentLength() {
        return this.getBody().getContentLength();
    }

    int getRawContentLength() {
        return super.getContentLength();
    }

    public boolean isPlainText() {
        return "true".equals(this.getQuery().getString("plainText", "false"));
    }

    public String getMessage(String key, Object ... args) {
        return this.context.getMessages().getString(this.getLocale(), key, args);
    }

    public MessageBundle getResourceBundle() {
        return this.context.getMessages().getBundle(this.getLocale());
    }

    public RestContext getContext() {
        return this.context;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public BeanSession getBeanSession() {
        return this.beanSession;
    }

    public VarResolverSession getVarResolverSession() {
        if (this.varSession == null) {
            this.varSession = this.context.getVarResolver().createSession(this.context.getCallHandler().getSessionObjects(this));
        }
        return this.varSession;
    }

    public String resolveVars(String input) {
        return this.getVarResolverSession().resolve(input);
    }

    public ReaderResource getReaderResource(String name, boolean resolveVars, MediaType mediaType) throws IOException {
        String s = this.context.getResourceAsString(name, this.getLocale());
        if (s == null) {
            return null;
        }
        ReaderResource.Builder b = new ReaderResource.Builder().mediaType(mediaType).contents(s);
        if (resolveVars) {
            b.varResolver(this.getVarResolverSession());
        }
        return b.build();
    }

    public ReaderResource getReaderResource(String name, boolean resolveVars) throws IOException {
        return this.getReaderResource(name, resolveVars, MediaType.forString(this.context.getMediaTypeForName(name)));
    }

    public ReaderResource getReaderResource(String name) throws IOException {
        return this.getReaderResource(name, false, MediaType.forString(this.context.getMediaTypeForName(name)));
    }

    public ConfigFile getConfigFile() {
        if (this.cf == null) {
            this.cf = this.context.getConfigFile().getResolving(this.getVarResolverSession());
        }
        return this.cf;
    }

    public Swagger getSwagger() {
        if (this.swagger == null) {
            this.swagger = this.context.getInfoProvider().getSwagger(this);
        }
        return this.swagger;
    }

    public Map<String, Widget> getWidgets() {
        return this.widgets;
    }

    protected Swagger getSwaggerFromFile() {
        if (this.fileSwagger == null) {
            this.fileSwagger = this.context.getInfoProvider().getSwaggerFromFile(this.getLocale());
        }
        if (this.fileSwagger == null) {
            this.fileSwagger = Swagger.NULL;
        }
        return this.fileSwagger == Swagger.NULL ? null : this.fileSwagger;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n").append(this.getDescription()).append("\n");
        sb.append("---Headers---\n");
        Enumeration e = this.getHeaderNames();
        while (e.hasMoreElements()) {
            String string = (String)e.nextElement();
            sb.append("\t").append(string).append(": ").append(this.getHeader(string)).append("\n");
        }
        sb.append("---Default Servlet Headers---\n");
        for (Map.Entry entry : this.context.getDefaultRequestHeaders().entrySet()) {
            sb.append("\t").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
        }
        if (this.javaMethod == null) {
            sb.append("***init() not called yet!***\n");
        } else if (this.method.equals("PUT") || this.method.equals("POST")) {
            try {
                sb.append("---Body UTF-8---\n");
                sb.append(this.body.asString()).append("\n");
                sb.append("---Body Hex---\n");
                sb.append(this.body.asHex()).append("\n");
            }
            catch (Exception e1) {
                sb.append(e1.getLocalizedMessage());
                this.context.getLogger().log(Level.WARNING, e1, "Error occurred while trying to read debug input.", new Object[0]);
            }
        }
        return sb.toString();
    }

    private static Locale toLocale(String lang) {
        String country = "";
        int i = lang.indexOf(45);
        if (i > -1) {
            country = lang.substring(i + 1).trim();
            lang = lang.substring(0, i).trim();
        }
        return new Locale(lang, country);
    }

    void setJavaMethod(Method method) {
        this.javaMethod = method;
    }
}

