/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.Pair;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.rest.CallMethod;
import org.apache.juneau.rest.CallRouter;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestConfig;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestParam;
import org.apache.juneau.rest.RestParamDefaults;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.StreamResource;
import org.apache.juneau.rest.UrlPathPattern;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.FormData;
import org.apache.juneau.rest.annotation.HasFormData;
import org.apache.juneau.rest.annotation.HasQuery;
import org.apache.juneau.rest.annotation.Header;
import org.apache.juneau.rest.annotation.Messages;
import org.apache.juneau.rest.annotation.Method;
import org.apache.juneau.rest.annotation.Path;
import org.apache.juneau.rest.annotation.PathRemainder;
import org.apache.juneau.rest.annotation.Properties;
import org.apache.juneau.rest.annotation.Query;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.vars.LocalizationVar;
import org.apache.juneau.rest.vars.RequestVar;
import org.apache.juneau.rest.vars.SerializedRequestAttrVar;
import org.apache.juneau.rest.vars.ServletInitParamVar;
import org.apache.juneau.rest.vars.UrlEncodeVar;
import org.apache.juneau.rest.vars.UrlVar;
import org.apache.juneau.rest.vars.WidgetVar;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.utils.MessageBundle;
import org.apache.juneau.utils.ResourceFinder;

public final class RestContext
extends Context {
    public static final String REST_allowHeaderParams = "RestServlet.allowHeaderParams";
    public static final String REST_allowMethodParam = "RestServlet.allowMethodParam";
    public static final String REST_allowBodyParam = "RestServlet.allowBodyParam";
    public static final String REST_renderResponseStackTraces = "RestServlet.renderResponseStackTraces";
    public static final String REST_useStackTraceHashes = "RestServlet.useStackTraceHashes";
    public static final String REST_defaultCharset = "RestServlet.defaultCharset";
    public static final String REST_paramFormat = "RestServlet.paramFormat";
    private final Object resource;
    private final RestConfig config;
    private final boolean allowHeaderParams;
    private final boolean allowBodyParam;
    private final boolean renderResponseStackTraces;
    private final boolean useStackTraceHashes;
    private final String defaultCharset;
    private final String paramFormat;
    private final String clientVersionHeader;
    private final String fullPath;
    private final String htmlHeader;
    private final String htmlNav;
    private final String htmlAside;
    private final String htmlStyle;
    private final String htmlStylesheet;
    private final String htmlScript;
    private final String htmlFooter;
    private final String htmlNoResultsMessage;
    private final String[] htmlLinks;
    private final boolean htmlNoWrap;
    private final HtmlDocTemplate htmlTemplate;
    private final Map<String, Widget> htmlWidgets;
    private final Set<String> allowMethodParams;
    private final ObjectMap properties;
    private final Class<?>[] beanFilters;
    private final Class<?>[] pojoSwaps;
    private final Map<Class<?>, RestParam> paramResolvers;
    private final SerializerGroup serializers;
    private final ParserGroup parsers;
    private final UrlEncodingSerializer urlEncodingSerializer;
    private final UrlEncodingParser urlEncodingParser;
    private final EncoderGroup encoders;
    private final MediaType[] supportedContentTypes;
    private final MediaType[] supportedAcceptTypes;
    private final Map<String, String> defaultRequestHeaders;
    private final Map<String, Object> defaultResponseHeaders;
    private final BeanContext beanContext;
    private final RestConverter[] converters;
    private final RestGuard[] guards;
    private final ResponseHandler[] responseHandlers;
    private final MimetypesFileTypeMap mimetypesFileTypeMap;
    private final StreamResource favIcon;
    private final Map<String, String> staticFilesMap;
    private final String[] staticFilesPrefixes;
    private final MessageBundle msgs;
    private final ConfigFile configFile;
    private final VarResolver varResolver;
    private final Map<String, CallRouter> callRouters;
    private final Map<String, CallMethod> callMethods;
    private final Map<String, RestContext> childResources;
    private final RestLogger logger;
    private final RestCallHandler callHandler;
    private final RestInfoProvider infoProvider;
    private final RestException initException;
    private final RestContext parentContext;
    private final Map<String, StreamResource> staticFilesCache = new ConcurrentHashMap<String, StreamResource>();
    private final ResourceFinder resourceFinder;
    private final ConcurrentHashMap<Integer, AtomicInteger> stackTraceHashes = new ConcurrentHashMap();

    public RestContext(Object resource, RestConfig config) throws Exception {
        super(null);
        RestException _initException = null;
        try {
            this.resource = resource;
            this.config = config;
            this.resourceFinder = new ResourceFinder(resource.getClass());
            this.parentContext = config.parentContext;
            Builder b = new Builder(resource, config);
            this.allowHeaderParams = b.allowHeaderParams;
            this.allowBodyParam = b.allowBodyParam;
            this.renderResponseStackTraces = b.renderResponseStackTraces;
            this.useStackTraceHashes = b.useStackTraceHashes;
            this.allowMethodParams = Collections.unmodifiableSet(b.allowMethodParams);
            this.defaultCharset = b.defaultCharset;
            this.paramFormat = b.paramFormat;
            this.varResolver = b.varResolver;
            this.configFile = b.configFile;
            this.properties = b.properties;
            this.beanFilters = b.beanFilters;
            this.pojoSwaps = b.pojoSwaps;
            this.paramResolvers = Collections.unmodifiableMap(b.paramResolvers);
            this.serializers = b.serializers;
            this.parsers = b.parsers;
            this.urlEncodingSerializer = b.urlEncodingSerializer;
            this.urlEncodingParser = b.urlEncodingParser;
            this.encoders = b.encoders;
            this.supportedContentTypes = ArrayUtils.toObjectArray(b.supportedContentTypes, MediaType.class);
            this.supportedAcceptTypes = ArrayUtils.toObjectArray(b.supportedAcceptTypes, MediaType.class);
            this.clientVersionHeader = b.clientVersionHeader;
            this.defaultRequestHeaders = Collections.unmodifiableMap(b.defaultRequestHeaders);
            this.defaultResponseHeaders = Collections.unmodifiableMap(b.defaultResponseHeaders);
            this.beanContext = b.beanContext;
            this.converters = b.converters.toArray(new RestConverter[b.converters.size()]);
            this.guards = b.guards.toArray(new RestGuard[b.guards.size()]);
            this.responseHandlers = ArrayUtils.toObjectArray(b.responseHandlers, ResponseHandler.class);
            this.mimetypesFileTypeMap = b.mimetypesFileTypeMap;
            this.favIcon = b.favIcon;
            this.staticFilesMap = Collections.unmodifiableMap(b.staticFilesMap);
            this.staticFilesPrefixes = b.staticFilesPrefixes;
            this.msgs = b.messageBundle;
            this.childResources = Collections.synchronizedMap(new LinkedHashMap());
            this.logger = b.logger;
            this.fullPath = b.fullPath;
            this.htmlWidgets = Collections.unmodifiableMap(b.htmlWidgets);
            this.htmlHeader = b.htmlHeader;
            this.htmlLinks = b.htmlLinks;
            this.htmlNav = b.htmlNav;
            this.htmlAside = b.htmlAside;
            this.htmlStyle = b.htmlStyle;
            this.htmlStylesheet = b.htmlStylesheet;
            this.htmlScript = b.htmlScript;
            this.htmlFooter = b.htmlFooter;
            this.htmlNoWrap = b.htmlNoWrap;
            this.htmlNoResultsMessage = b.htmlNoResultsMessage;
            this.htmlTemplate = b.htmlTemplate;
            LinkedList<String> methodsFound = new LinkedList<String>();
            LinkedHashMap<String, CallRouter.Builder> routers = new LinkedHashMap<String, CallRouter.Builder>();
            LinkedHashMap<String, CallMethod> _javaRestMethods = new LinkedHashMap<String, CallMethod>();
            for (java.lang.reflect.Method method : resource.getClass().getMethods()) {
                if (!method.isAnnotationPresent(RestMethod.class)) continue;
                RestMethod a = method.getAnnotation(RestMethod.class);
                methodsFound.add(method.getName() + "," + a.name() + "," + a.path());
                try {
                    if (!Modifier.isPublic(method.getModifiers())) {
                        throw new RestServletException("@RestMethod method {0}.{1} must be defined as public.", this.getClass().getName(), method.getName());
                    }
                    CallMethod sm = new CallMethod(resource, method, this);
                    String httpMethod = sm.getHttpMethod();
                    if ("PROXY".equals(httpMethod)) {
                        ClassMeta interfaceClass = this.beanContext.getClassMeta(method.getGenericReturnType(), new Type[0]);
                        final Map<String, java.lang.reflect.Method> remoteableMethods = interfaceClass.getRemoteableMethods();
                        if (remoteableMethods.isEmpty()) {
                            throw new RestException(500, "Method {0} returns an interface {1} that doesn't define any remoteable methods.", ClassUtils.getMethodSignature(method), interfaceClass.getReadableName());
                        }
                        sm = new CallMethod(resource, method, this){

                            @Override
                            int invoke(String pathInfo, RestRequest req, RestResponse res) throws RestException {
                                int rc = super.invoke(pathInfo, req, res);
                                if (rc != 200) {
                                    return rc;
                                }
                                Object o = res.getOutput();
                                if ("GET".equals(req.getMethod())) {
                                    res.setOutput(ClassUtils.getMethodInfo(remoteableMethods.values()));
                                    return 200;
                                }
                                if ("POST".equals(req.getMethod())) {
                                    java.lang.reflect.Method m;
                                    if (pathInfo.indexOf(47) != -1) {
                                        pathInfo = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
                                    }
                                    if ((m = (java.lang.reflect.Method)remoteableMethods.get(pathInfo = StringUtils.urlDecode(pathInfo))) != null) {
                                        try {
                                            Parser p = req.getBody().getParser();
                                            BufferedReader input = p.isReaderParser() ? req.getReader() : req.getInputStream();
                                            Object output = m.invoke(o, p.parseArgs(input, m.getGenericParameterTypes()));
                                            res.setOutput(output);
                                            return 200;
                                        }
                                        catch (Exception e) {
                                            throw new RestException(500, (Throwable)e);
                                        }
                                    }
                                }
                                return 404;
                            }
                        };
                        _javaRestMethods.put(method.getName(), sm);
                        RestContext.addToRouter(routers, "GET", sm);
                        RestContext.addToRouter(routers, "POST", sm);
                        continue;
                    }
                    _javaRestMethods.put(method.getName(), sm);
                    RestContext.addToRouter(routers, httpMethod, sm);
                }
                catch (RestServletException e) {
                    throw new RestServletException("Problem occurred trying to serialize methods on class {0}, methods={1}", this.getClass().getName(), JsonSerializer.DEFAULT_LAX.serialize(methodsFound)).initCause((Throwable)((Object)e));
                }
            }
            this.callMethods = Collections.unmodifiableMap(_javaRestMethods);
            LinkedHashMap<String, CallRouter> _callRouters = new LinkedHashMap<String, CallRouter>();
            for (CallRouter.Builder crb : routers.values()) {
                _callRouters.put(crb.getHttpMethodName(), crb.build());
            }
            this.callRouters = Collections.unmodifiableMap(_callRouters);
            RestResourceResolver rrr = RestContext.resolve(RestResourceResolver.class, config.resourceResolver, new Object[0]);
            for (Object o : config.childResources) {
                String path = null;
                Object r = null;
                if (o instanceof Pair) {
                    Pair p = (Pair)o;
                    path = (String)p.first();
                    r = p.second();
                } else if (o instanceof Class) {
                    Class c = (Class)o;
                    if (c == config.resourceClass) continue;
                    r = c;
                } else {
                    r = o;
                }
                RestConfig childConfig = null;
                if (o instanceof Class) {
                    Class oc = (Class)o;
                    childConfig = new RestConfig(config.inner, oc, this);
                    r = rrr.resolve(oc, childConfig);
                } else {
                    r = o;
                    childConfig = new RestConfig(config.inner, o.getClass(), this);
                }
                if (r instanceof RestServlet) {
                    RestServlet rs = (RestServlet)((Object)r);
                    rs.init(childConfig);
                    if (rs.getContext() == null) {
                        throw new RestException(500, "Servlet {0} not initialized.  init(RestConfig) was not called.  This can occur if you've overridden this method but didn't call super.init(RestConfig).", ((Object)((Object)rs)).getClass().getName());
                    }
                    path = childConfig.path;
                    this.childResources.put(path, rs.getContext());
                    continue;
                }
                java.lang.reflect.Method m2 = ClassUtils.findPublicMethod(r.getClass(), "init", Void.class, RestConfig.class);
                if (m2 != null) {
                    m2.invoke(r, childConfig);
                }
                RestContext rc2 = new RestContext(r, childConfig);
                m2 = ClassUtils.findPublicMethod(r.getClass(), "init", Void.class, RestContext.class);
                if (m2 != null) {
                    m2.invoke(r, rc2);
                }
                path = childConfig.path;
                this.childResources.put(path, rc2);
            }
            this.callHandler = config.callHandler == null ? new RestCallHandler(this) : RestContext.resolve(RestCallHandler.class, config.callHandler, this);
            this.infoProvider = config.infoProvider == null ? new RestInfoProvider(this) : RestContext.resolve(RestInfoProvider.class, config.infoProvider, this);
        }
        catch (RestException e) {
            _initException = e;
            throw e;
        }
        catch (Exception e) {
            _initException = new RestException(500, (Throwable)e);
            throw e;
        }
        finally {
            this.initException = _initException;
        }
    }

    private static void addToRouter(Map<String, CallRouter.Builder> routers, String httpMethodName, CallMethod cm) throws RestServletException {
        if (!routers.containsKey(httpMethodName)) {
            routers.put(httpMethodName, new CallRouter.Builder(httpMethodName));
        }
        routers.get(httpMethodName).add(cm);
    }

    public VarResolver getVarResolver() {
        return this.varResolver;
    }

    public ConfigFile getConfigFile() {
        return this.configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamResource resolveStaticFile(String pathInfo) throws IOException {
        if (!this.staticFilesCache.containsKey(pathInfo)) {
            String p = StringUtils.urlDecode(StringUtils.trimSlashes(pathInfo));
            if (p.indexOf("..") != -1) {
                throw new RestException(404, "Invalid path", new Object[0]);
            }
            for (Map.Entry<String, String> e : this.staticFilesMap.entrySet()) {
                String p2;
                InputStream is;
                String remainder;
                String key = StringUtils.trimSlashes(e.getKey());
                if (!p.startsWith(key)) continue;
                String string = remainder = p.equals(key) ? "" : p.substring(key.length());
                if (!remainder.isEmpty() && !remainder.startsWith("/") || (is = this.getResource(p2 = StringUtils.trimSlashes(e.getValue()) + remainder, null)) == null) continue;
                try {
                    int i = p2.lastIndexOf(47);
                    String name = i == -1 ? p2 : p2.substring(i + 1);
                    String mediaType = this.mimetypesFileTypeMap.getContentType(name);
                    ObjectMap headers = new ObjectMap().append("Cache-Control", "max-age=86400, public");
                    this.staticFilesCache.put(pathInfo, new StreamResource(MediaType.forString(mediaType), headers, is));
                    StreamResource streamResource = this.staticFilesCache.get(pathInfo);
                    return streamResource;
                }
                finally {
                    is.close();
                }
            }
        }
        return this.staticFilesCache.get(pathInfo);
    }

    protected InputStream getResource(String name, Locale locale) throws IOException {
        return this.resourceFinder.getResourceAsStream(name, locale);
    }

    public String getResourceAsString(String name, Locale locale) throws IOException {
        return this.resourceFinder.getResourceAsString(name, locale);
    }

    public <T> T getResource(Class<T> c, MediaType mediaType, String name, Locale locale) throws IOException, ServletException {
        InputStream is = this.getResource(name, locale);
        if (is == null) {
            return null;
        }
        try {
            Parser p = this.parsers.getParser(mediaType);
            if (p != null) {
                try {
                    if (p.isReaderParser()) {
                        return p.parse((Object)new InputStreamReader(is, IOUtils.UTF8), c);
                    }
                    return p.parse((Object)is, c);
                }
                catch (ParseException e) {
                    throw new ServletException("Could not parse resource '' as media type '" + mediaType + "'.");
                }
            }
            throw new ServletException("Unknown media type '" + mediaType + "'");
        }
        catch (Exception e) {
            throw new ServletException("Could not parse resource with name '" + name + "'", (Throwable)e);
        }
    }

    public String getPath() {
        return this.fullPath;
    }

    public String getHtmlHeader() {
        return this.htmlHeader;
    }

    public String[] getHtmlLinks() {
        return this.htmlLinks;
    }

    public String getHtmlNav() {
        return this.htmlNav;
    }

    public String getHtmlAside() {
        return this.htmlAside;
    }

    public String getHtmlFooter() {
        return this.htmlFooter;
    }

    public String getHtmlStylesheet() {
        return this.htmlStylesheet;
    }

    public String getHtmlStyle() {
        return this.htmlStyle;
    }

    public String getHtmlScript() {
        return this.htmlScript;
    }

    public boolean getHtmlNoWrap() {
        return this.htmlNoWrap;
    }

    public HtmlDocTemplate getHtmlTemplate() {
        return this.htmlTemplate;
    }

    public String getHtmlNoResultsMessage() {
        return this.htmlNoResultsMessage;
    }

    public Map<String, Widget> getHtmlWidgets() {
        return this.htmlWidgets;
    }

    public RestLogger getLogger() {
        return this.logger;
    }

    public MessageBundle getMessages() {
        return this.msgs;
    }

    public RestInfoProvider getInfoProvider() {
        return this.infoProvider;
    }

    protected RestCallHandler getCallHandler() {
        return this.callHandler;
    }

    protected Map<String, CallRouter> getCallRouters() {
        return this.callRouters;
    }

    public Object getResource() {
        return this.resource;
    }

    public RestServlet getRestServlet() {
        return this.resource instanceof RestServlet ? (RestServlet)((Object)this.resource) : null;
    }

    protected void checkForInitException() throws RestException {
        if (this.initException != null) {
            throw this.initException;
        }
    }

    public RestContext getParentContext() {
        return this.parentContext;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public ObjectMap getProperties() {
        return this.properties;
    }

    public SerializerGroup getSerializers() {
        return this.serializers;
    }

    public ParserGroup getParsers() {
        return this.parsers;
    }

    public String getServletInitParameter(String name) {
        return this.config.getInitParameter(name);
    }

    public Map<String, RestContext> getChildResources() {
        return Collections.unmodifiableMap(this.childResources);
    }

    protected int getStackTraceOccurrence(Throwable e) {
        if (!this.useStackTraceHashes) {
            return 0;
        }
        int h = e.hashCode();
        this.stackTraceHashes.putIfAbsent(h, new AtomicInteger());
        return this.stackTraceHashes.get(h).incrementAndGet();
    }

    protected boolean isRenderResponseStackTraces() {
        return this.renderResponseStackTraces;
    }

    protected boolean isAllowHeaderParams() {
        return this.allowHeaderParams;
    }

    protected boolean isAllowBodyParam() {
        return this.allowBodyParam;
    }

    protected String getDefaultCharset() {
        return this.defaultCharset;
    }

    protected String getParamFormat() {
        return this.paramFormat;
    }

    protected String getClientVersionHeader() {
        return this.clientVersionHeader;
    }

    protected boolean allowMethodParam(String m) {
        return !StringUtils.isEmpty(m) && (this.allowMethodParams.contains(m) || this.allowMethodParams.contains("*"));
    }

    protected Class<?>[] getBeanFilters() {
        return this.beanFilters;
    }

    protected Class<?>[] getPojoSwaps() {
        return this.pojoSwaps;
    }

    protected RestParam[] findParams(java.lang.reflect.Method method, boolean methodPlainParams, UrlPathPattern pathPattern) throws ServletException {
        Type[] pt = method.getGenericParameterTypes();
        Annotation[][] pa = method.getParameterAnnotations();
        RestParam[] rp = new RestParam[pt.length];
        int attrIndex = 0;
        for (int i = 0; i < pt.length; ++i) {
            String name;
            Type t = pt[i];
            if (t instanceof Class) {
                Annotation[] c = (Annotation[])t;
                rp[i] = this.paramResolvers.get(c);
                if (rp[i] == null) {
                    rp[i] = RestParamDefaults.STANDARD_RESOLVERS.get(c);
                }
            }
            if (rp[i] == null) {
                for (Annotation a : pa[i]) {
                    if (a instanceof Header) {
                        rp[i] = new RestParamDefaults.HeaderObject((Header)a, t);
                        continue;
                    }
                    if (a instanceof FormData) {
                        rp[i] = new RestParamDefaults.FormDataObject(method, (FormData)a, t, methodPlainParams);
                        continue;
                    }
                    if (a instanceof Query) {
                        rp[i] = new RestParamDefaults.QueryObject(method, (Query)a, t, methodPlainParams);
                        continue;
                    }
                    if (a instanceof HasFormData) {
                        rp[i] = new RestParamDefaults.HasFormDataObject(method, (HasFormData)a, t);
                        continue;
                    }
                    if (a instanceof HasQuery) {
                        rp[i] = new RestParamDefaults.HasQueryObject(method, (HasQuery)a, t);
                        continue;
                    }
                    if (a instanceof Body) {
                        rp[i] = new RestParamDefaults.BodyObject(t);
                        continue;
                    }
                    if (a instanceof Method) {
                        rp[i] = new RestParamDefaults.MethodObject(method, t);
                        continue;
                    }
                    if (a instanceof PathRemainder) {
                        rp[i] = new RestParamDefaults.PathRemainderObject(method, t);
                        continue;
                    }
                    if (a instanceof Properties) {
                        rp[i] = new RestParamDefaults.PropsObject(method, t);
                        continue;
                    }
                    if (!(a instanceof Messages)) continue;
                    rp[i] = new RestParamDefaults.MessageBundleObject();
                }
            }
            if (rp[i] != null) continue;
            Path p = null;
            for (Annotation a : pa[i]) {
                if (!(a instanceof Path)) continue;
                p = (Path)a;
            }
            String string = name = p == null ? "" : StringUtils.firstNonEmpty(p.name(), p.value());
            if (StringUtils.isEmpty(name)) {
                int idx = attrIndex++;
                String[] vars = pathPattern.getVars();
                if (vars.length <= idx) {
                    throw new RestServletException("Number of attribute parameters in method ''{0}'' exceeds the number of URL pattern variables.", method.getName());
                }
                String idxs = String.valueOf(idx);
                for (int j = 0; j < vars.length; ++j) {
                    if (!StringUtils.isNumeric(vars[j]) || !vars[j].equals(idxs)) continue;
                    name = vars[j];
                }
                if (StringUtils.isEmpty(name)) {
                    name = pathPattern.getVars()[idx];
                }
            }
            rp[i] = new RestParamDefaults.PathParameterObject(name, t);
        }
        return rp;
    }

    protected UrlEncodingParser getUrlEncodingParser() {
        return this.urlEncodingParser;
    }

    protected UrlEncodingSerializer getUrlEncodingSerializer() {
        return this.urlEncodingSerializer;
    }

    protected EncoderGroup getEncoders() {
        return this.encoders;
    }

    protected MediaType[] getSupportedAcceptTypes() {
        return this.supportedAcceptTypes;
    }

    protected MediaType[] getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    protected Map<String, String> getDefaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    public Map<String, Object> getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    protected RestConverter[] getConverters() {
        return this.converters;
    }

    protected RestGuard[] getGuards() {
        return this.guards;
    }

    protected ResponseHandler[] getResponseHandlers() {
        return this.responseHandlers;
    }

    protected String getMediaTypeForName(String name) {
        return this.mimetypesFileTypeMap.getContentType(name);
    }

    protected StreamResource getFavIcon() {
        return this.favIcon;
    }

    protected boolean isStaticFile(String p) {
        return StringUtils.pathStartsWith(p, this.staticFilesPrefixes);
    }

    protected Map<String, CallMethod> getCallMethods() {
        return this.callMethods;
    }

    protected void destroy() {
        for (RestContext r : this.childResources.values()) {
            r.destroy();
            if (!(r.resource instanceof Servlet)) continue;
            ((Servlet)r.resource).destroy();
        }
    }

    protected boolean hasChildResources() {
        return !this.childResources.isEmpty();
    }

    protected RestContext getChildResource(String path) {
        return this.childResources.get(path);
    }

    private static <T> T resolve(Class<T> c, Object o, Object ... cArgs) throws RestServletException {
        if (c.isInstance(o)) {
            return (T)o;
        }
        if (!(o instanceof Class)) {
            throw new RestServletException("Invalid object type passed to resolve:  ''{0}''.  Must be an object of type T or a Class<? extend T>.", o.getClass());
        }
        Constructor n = ClassUtils.findPublicConstructor((Class)o, cArgs);
        if (n == null) {
            throw new RestServletException("Could not find public constructor for class ''{0}'' that takes in args {1}", c, JsonSerializer.DEFAULT_LAX.toString(ClassUtils.getClasses(cArgs)));
        }
        try {
            return n.newInstance(cArgs);
        }
        catch (Exception e) {
            throw new RestServletException("Exception occurred while constructing class ''{0}''", c).initCause(e);
        }
    }

    private static class Builder {
        boolean allowHeaderParams;
        boolean allowBodyParam;
        boolean renderResponseStackTraces;
        boolean useStackTraceHashes;
        VarResolver varResolver;
        ConfigFile configFile;
        ObjectMap properties;
        Class<?>[] beanFilters;
        Class<?>[] pojoSwaps;
        Map<Class<?>, RestParam> paramResolvers = new HashMap();
        SerializerGroup serializers;
        ParserGroup parsers;
        UrlEncodingSerializer urlEncodingSerializer;
        UrlEncodingParser urlEncodingParser;
        EncoderGroup encoders;
        String clientVersionHeader = "";
        String defaultCharset;
        String paramFormat;
        String htmlHeader;
        String htmlNav;
        String htmlAside;
        String htmlStyle;
        String htmlStylesheet;
        String htmlScript;
        String htmlFooter;
        String htmlNoResultsMessage;
        String[] htmlLinks;
        boolean htmlNoWrap;
        HtmlDocTemplate htmlTemplate;
        List<MediaType> supportedContentTypes;
        List<MediaType> supportedAcceptTypes;
        Map<String, String> defaultRequestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Map<String, Object> defaultResponseHeaders;
        BeanContext beanContext;
        List<RestConverter> converters = new ArrayList<RestConverter>();
        List<RestGuard> guards = new ArrayList<RestGuard>();
        List<ResponseHandler> responseHandlers = new ArrayList<ResponseHandler>();
        MimetypesFileTypeMap mimetypesFileTypeMap;
        StreamResource favIcon;
        Map<String, String> staticFilesMap;
        String[] staticFilesPrefixes;
        MessageBundle messageBundle;
        Set<String> allowMethodParams = new LinkedHashSet<String>();
        RestLogger logger;
        String fullPath;
        Map<String, Widget> htmlWidgets;

        private Builder(Object resource, RestConfig sc) throws Exception {
            Pair p;
            PropertyStore ps = sc.createPropertyStore();
            LinkedHashMap<Class<?>, RestResource> restResourceAnnotationsChildFirst = ReflectionUtils.findAnnotationsMap(RestResource.class, resource.getClass());
            this.allowHeaderParams = ps.getProperty(RestContext.REST_allowHeaderParams, Boolean.TYPE, true);
            this.allowBodyParam = ps.getProperty(RestContext.REST_allowBodyParam, Boolean.TYPE, true);
            this.renderResponseStackTraces = ps.getProperty(RestContext.REST_renderResponseStackTraces, Boolean.TYPE, false);
            this.useStackTraceHashes = ps.getProperty(RestContext.REST_useStackTraceHashes, Boolean.TYPE, true);
            this.defaultCharset = ps.getProperty(RestContext.REST_defaultCharset, String.class, "utf-8");
            this.paramFormat = ps.getProperty(RestContext.REST_paramFormat, String.class, "");
            for (String m : StringUtils.split(ps.getProperty(RestContext.REST_allowMethodParam, String.class, ""))) {
                if (m.equals("true")) {
                    this.allowMethodParams.add("*");
                    continue;
                }
                this.allowMethodParams.add(m.toUpperCase());
            }
            this.varResolver = sc.varResolverBuilder.vars(FileVar.class, LocalizationVar.class, RequestVar.class, SerializedRequestAttrVar.class, ServletInitParamVar.class, UrlVar.class, UrlEncodeVar.class, WidgetVar.class).build();
            this.configFile = sc.configFile.getResolving(this.varResolver);
            this.properties = sc.properties;
            Collections.reverse(sc.beanFilters);
            Collections.reverse(sc.pojoSwaps);
            this.beanFilters = ArrayUtils.toObjectArray(sc.beanFilters, Class.class);
            this.pojoSwaps = ArrayUtils.toObjectArray(sc.pojoSwaps, Class.class);
            for (Class clazz : sc.paramResolvers) {
                RestParam rp = ClassUtils.newInstance(RestParam.class, clazz, new Object[0]);
                this.paramResolvers.put(rp.forClass(), rp);
            }
            this.clientVersionHeader = sc.clientVersionHeader;
            for (Map.Entry entry : restResourceAnnotationsChildFirst.entrySet()) {
                Class c = (Class)entry.getKey();
                RestResource r = (RestResource)entry.getValue();
                if (r.messages().isEmpty()) continue;
                if (this.messageBundle == null) {
                    this.messageBundle = new MessageBundle(c, r.messages());
                    continue;
                }
                this.messageBundle.addSearchPath(c, r.messages());
            }
            if (this.messageBundle == null) {
                this.messageBundle = new MessageBundle(resource.getClass(), "");
            }
            ps.addBeanFilters(this.beanFilters).addPojoSwaps(this.pojoSwaps).setProperties(this.properties);
            this.serializers = sc.serializers.beanFilters(this.beanFilters).pojoSwaps(this.pojoSwaps).properties(this.properties).listener(sc.serializerListener).build();
            this.parsers = sc.parsers.beanFilters(this.beanFilters).pojoSwaps(this.pojoSwaps).properties(this.properties).listener(sc.parserListener).build();
            this.urlEncodingSerializer = new UrlEncodingSerializer(ps);
            this.urlEncodingParser = new UrlEncodingParser(ps);
            this.encoders = sc.encoders.build();
            this.supportedContentTypes = sc.supportedContentTypes != null ? sc.supportedContentTypes : this.serializers.getSupportedMediaTypes();
            this.supportedAcceptTypes = sc.supportedAcceptTypes != null ? sc.supportedAcceptTypes : this.parsers.getSupportedMediaTypes();
            this.defaultRequestHeaders.putAll(sc.defaultRequestHeaders);
            this.defaultResponseHeaders = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(sc.defaultResponseHeaders));
            this.beanContext = ps.getBeanContext();
            for (Object e : sc.converters) {
                this.converters.add((RestConverter)RestContext.resolve(RestConverter.class, e, new Object[0]));
            }
            for (Object e : sc.guards) {
                this.guards.add((RestGuard)RestContext.resolve(RestGuard.class, e, new Object[0]));
            }
            for (Object e : sc.responseHandlers) {
                this.responseHandlers.add((ResponseHandler)RestContext.resolve(ResponseHandler.class, e, new Object[0]));
            }
            this.mimetypesFileTypeMap = sc.mimeTypes;
            VarResolver vr = sc.getVarResolverBuilder().build();
            if (sc.favIcon != null) {
                Object object = sc.favIcon;
                InputStream is = null;
                if (object instanceof Pair) {
                    p = (Pair)object;
                    is = ReflectionUtils.getResource((Class)p.first(), vr.resolve((String)p.second()));
                } else {
                    is = IOUtils.toInputStream(object);
                }
                if (is != null) {
                    this.favIcon = new StreamResource(MediaType.forString("image/x-icon"), is);
                }
            }
            this.staticFilesMap = new LinkedHashMap<String, String>();
            if (sc.staticFiles != null) {
                for (Object o : sc.staticFiles) {
                    if (o instanceof Pair) {
                        p = (Pair)o;
                        this.staticFilesMap.putAll(JsonParser.DEFAULT.parse((Object)vr.resolve((String)p.second()), LinkedHashMap.class));
                        continue;
                    }
                    throw new RuntimeException("TODO");
                }
            }
            this.staticFilesPrefixes = this.staticFilesMap.keySet().toArray(new String[0]);
            this.logger = sc.logger == null ? new RestLogger.NoOp() : (RestLogger)RestContext.resolve(RestLogger.class, sc.logger, new Object[0]);
            this.fullPath = (sc.parentContext == null ? "" : sc.parentContext.fullPath + '/') + sc.path;
            this.htmlWidgets = sc.htmlWidgets;
            this.htmlHeader = sc.htmlHeader;
            this.htmlLinks = sc.htmlLinks;
            this.htmlNav = sc.htmlNav;
            this.htmlAside = sc.htmlAside;
            this.htmlStyle = sc.htmlStyle;
            this.htmlStylesheet = sc.htmlStylesheet;
            this.htmlScript = sc.htmlScript;
            this.htmlFooter = sc.htmlFooter;
            this.htmlNoWrap = sc.htmlNoWrap;
            this.htmlNoResultsMessage = sc.htmlNoResultsMessage;
            this.htmlTemplate = ClassUtils.newInstance(HtmlDocTemplate.class, sc.htmlTemplate, new Object[0]);
        }
    }
}

