/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerBuilder;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.EncoderGroupBuilder;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.Utils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserGroupBuilder;
import org.apache.juneau.rest.ClientVersionMatcher;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestMatcher;
import org.apache.juneau.rest.RestMatcherReflecting;
import org.apache.juneau.rest.RestParam;
import org.apache.juneau.rest.RestParamType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.RestUtils;
import org.apache.juneau.rest.UrlPathPattern;
import org.apache.juneau.rest.annotation.FormData;
import org.apache.juneau.rest.annotation.Header;
import org.apache.juneau.rest.annotation.HtmlDoc;
import org.apache.juneau.rest.annotation.Inherit;
import org.apache.juneau.rest.annotation.MethodSwagger;
import org.apache.juneau.rest.annotation.Parameter;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.Query;
import org.apache.juneau.rest.annotation.Response;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerGroupBuilder;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingParserBuilder;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

class CallMethod
implements Comparable<CallMethod> {
    private final Method method;
    private final String httpMethod;
    private final UrlPathPattern pathPattern;
    private final RestParam[] params;
    private final RestGuard[] guards;
    private final RestMatcher[] optionalMatchers;
    private final RestMatcher[] requiredMatchers;
    private final RestConverter[] converters;
    private final SerializerGroup serializers;
    private final ParserGroup parsers;
    private final EncoderGroup encoders;
    private final UrlEncodingParser urlEncodingParser;
    private final UrlEncodingSerializer urlEncodingSerializer;
    private final ObjectMap properties;
    private final Map<String, String> defaultRequestHeaders;
    private final Map<String, String> defaultQuery;
    private final Map<String, String> defaultFormData;
    private final String defaultCharset;
    private final boolean deprecated;
    private final String description;
    private final String tags;
    private final String summary;
    private final String externalDocs;
    private final Integer priority;
    private final Parameter[] parameters;
    private final Response[] responses;
    private final RestContext context;
    private final BeanContext beanContext;
    final String htmlHeader;
    final String htmlNav;
    final String htmlAside;
    final String htmlFooter;
    final String htmlStyle;
    final String htmlStylesheet;
    final String htmlScript;
    final String htmlNoResultsMessage;
    final String[] htmlLinks;
    final boolean htmlNoWrap;
    final HtmlDocTemplate htmlTemplate;
    private final Map<String, Widget> widgets;

    CallMethod(Object servlet, Method method, RestContext context) throws RestServletException {
        Builder b = new Builder(servlet, method, context);
        this.context = context;
        this.method = method;
        this.httpMethod = b.httpMethod;
        this.pathPattern = b.pathPattern;
        this.params = b.params;
        this.guards = b.guards;
        this.optionalMatchers = b.optionalMatchers;
        this.requiredMatchers = b.requiredMatchers;
        this.converters = b.converters;
        this.serializers = b.serializers;
        this.parsers = b.parsers;
        this.encoders = b.encoders;
        this.urlEncodingParser = b.urlEncodingParser;
        this.urlEncodingSerializer = b.urlEncodingSerializer;
        this.beanContext = b.beanContext;
        this.properties = b.properties;
        this.defaultRequestHeaders = b.defaultRequestHeaders;
        this.defaultQuery = b.defaultQuery;
        this.defaultFormData = b.defaultFormData;
        this.defaultCharset = b.defaultCharset;
        this.deprecated = b.deprecated;
        this.description = b.description;
        this.tags = b.tags;
        this.summary = b.summary;
        this.externalDocs = b.externalDocs;
        this.priority = b.priority;
        this.parameters = b.parameters;
        this.responses = b.responses;
        this.htmlHeader = b.htmlHeader;
        this.htmlLinks = b.htmlLinks;
        this.htmlNav = b.htmlNav;
        this.htmlAside = b.htmlAside;
        this.htmlFooter = b.htmlFooter;
        this.htmlStyle = b.htmlStyle;
        this.htmlStylesheet = b.htmlStylesheet;
        this.htmlScript = b.htmlScript;
        this.htmlNoWrap = b.htmlNoWrap;
        this.htmlTemplate = b.htmlTemplate;
        this.htmlNoResultsMessage = b.htmlNoResultsMessage;
        this.widgets = Collections.unmodifiableMap(b.htmlWidgets);
    }

    boolean hasGuardsOrMatchers() {
        return this.guards.length != 0 || this.requiredMatchers.length != 0 || this.optionalMatchers.length != 0;
    }

    String getHttpMethod() {
        return this.httpMethod;
    }

    String getPathPattern() {
        return this.pathPattern.toString();
    }

    Operation getSwaggerOperation(RestRequest req) throws ParseException {
        Operation o = SwaggerBuilder.operation().operationId(this.method.getName()).description(this.getDescription(req)).tags(this.getTags(req)).summary(this.getSummary(req)).externalDocs(this.getExternalDocs(req)).parameters(this.getParameters(req)).responses(this.getResponses(req));
        if (this.isDeprecated()) {
            o.deprecated(true);
        }
        if (!this.parsers.getSupportedMediaTypes().equals(this.context.getParsers().getSupportedMediaTypes())) {
            o.consumes(this.parsers.getSupportedMediaTypes());
        }
        if (!this.serializers.getSupportedMediaTypes().equals(this.context.getSerializers().getSupportedMediaTypes())) {
            o.produces(this.serializers.getSupportedMediaTypes());
        }
        return o;
    }

    private Operation getSwaggerOperationFromFile(RestRequest req) {
        Swagger s = req.getSwaggerFromFile();
        if (s != null && s.getPaths() != null && s.getPaths().get(this.pathPattern.getPatternString()) != null) {
            return s.getPaths().get(this.pathPattern.getPatternString()).get(this.httpMethod);
        }
        return null;
    }

    String getSummary(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.summary != null) {
            return vr.resolve(this.summary);
        }
        String summary = this.context.getMessages().findFirstString(req.getLocale(), this.method.getName() + ".summary");
        if (summary != null) {
            return vr.resolve(summary);
        }
        Operation o = this.getSwaggerOperationFromFile(req);
        if (o != null) {
            return o.getSummary();
        }
        return null;
    }

    String getDescription(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.description != null) {
            return vr.resolve(this.description);
        }
        String description = this.context.getMessages().findFirstString(req.getLocale(), this.method.getName() + ".description");
        if (description != null) {
            return vr.resolve(description);
        }
        Operation o = this.getSwaggerOperationFromFile(req);
        if (o != null) {
            return o.getDescription();
        }
        return null;
    }

    private List<String> getTags(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.tags != null) {
                return (List)jp.parse(vr.resolve(this.tags), (Type)((Object)ArrayList.class), new Type[]{String.class});
            }
            String tags = this.context.getMessages().findFirstString(req.getLocale(), this.method.getName() + ".tags");
            if (tags != null) {
                return (List)jp.parse(vr.resolve(tags), (Type)((Object)ArrayList.class), new Type[]{String.class});
            }
            Operation o = this.getSwaggerOperationFromFile(req);
            if (o != null) {
                return o.getTags();
            }
            return null;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    private ExternalDocumentation getExternalDocs(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.externalDocs != null) {
                return jp.parse((Object)vr.resolve(this.externalDocs), ExternalDocumentation.class);
            }
            String externalDocs = this.context.getMessages().findFirstString(req.getLocale(), this.method.getName() + ".externalDocs");
            if (externalDocs != null) {
                return jp.parse((Object)vr.resolve(externalDocs), ExternalDocumentation.class);
            }
            Operation o = this.getSwaggerOperationFromFile(req);
            if (o != null) {
                return o.getExternalDocs();
            }
            return null;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    private boolean isDeprecated() {
        return this.deprecated;
    }

    private List<ParameterInfo> getParameters(RestRequest req) throws ParseException {
        Object in;
        Operation o = this.getSwaggerOperationFromFile(req);
        if (o != null && o.getParameters() != null) {
            return o.getParameters();
        }
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        TreeMap<String, ParameterInfo> m = new TreeMap<String, ParameterInfo>();
        for (Parameter v : this.parameters) {
            String in2 = vr.resolve(v.in());
            ParameterInfo p = SwaggerBuilder.parameterInfo(in2, vr.resolve(v.name()));
            if (!v.description().isEmpty()) {
                p.description(vr.resolve(v.description()));
            }
            if (v.required()) {
                p.required(v.required());
            }
            if ("body".equals(in2)) {
                if (!v.schema().isEmpty()) {
                    p.schema(jp.parse((Object)vr.resolve(v.schema()), SchemaInfo.class));
                }
            } else {
                if (v.allowEmptyValue()) {
                    p.allowEmptyValue(v.allowEmptyValue());
                }
                if (!v.collectionFormat().isEmpty()) {
                    p.collectionFormat(vr.resolve(v.collectionFormat()));
                }
                if (!v._default().isEmpty()) {
                    p._default(vr.resolve(v._default()));
                }
                if (!v.format().isEmpty()) {
                    p.format(vr.resolve(v.format()));
                }
                if (!v.items().isEmpty()) {
                    p.items(jp.parse((Object)vr.resolve(v.items()), Items.class));
                }
                p.type(vr.resolve(v.type()));
            }
            m.put(p.getIn() + '.' + p.getName(), p);
        }
        String prefix = this.method.getName() + ".req";
        for (String key : this.context.getMessages().keySet(prefix)) {
            boolean isBody;
            if (key.length() <= prefix.length()) continue;
            String value = vr.resolve(this.context.getMessages().getString(key));
            String[] parts = key.substring(prefix.length() + 1).split("\\.");
            if (parts.length == ((isBody = "body".equals(in = parts[0])) ? 2 : 3)) {
                String field;
                String name;
                if ("body".equals(in)) {
                    name = null;
                    field = parts[1];
                } else {
                    name = parts[1];
                    field = parts[2];
                }
                String k2 = (String)in + '.' + name;
                ParameterInfo p = (ParameterInfo)m.get(k2);
                if (p == null) {
                    p = SwaggerBuilder.parameterInfoStrict((String)in, name);
                    m.put(k2, p);
                }
                if (field.equals("description")) {
                    p.description(value);
                } else if (field.equals("required")) {
                    p.required(Boolean.valueOf(value));
                }
                if ("body".equals(in)) {
                    if (!field.equals("schema")) continue;
                    p.schema(jp.parse((Object)value, SchemaInfo.class));
                    continue;
                }
                if (field.equals("allowEmptyValue")) {
                    p.allowEmptyValue(Boolean.valueOf(value));
                    continue;
                }
                if (field.equals("collectionFormat")) {
                    p.collectionFormat(value);
                    continue;
                }
                if (field.equals("default")) {
                    p._default(value);
                    continue;
                }
                if (field.equals("format")) {
                    p.format(value);
                    continue;
                }
                if (field.equals("items")) {
                    p.items(jp.parse((Object)value, Items.class));
                    continue;
                }
                if (!field.equals("type")) continue;
                p.type(value);
                continue;
            }
            System.err.println("Unknown bundle key '" + key + "'");
        }
        for (RestParam mp : this.params) {
            String k2;
            ParameterInfo p;
            in = mp.getParamType();
            if (in == RestParamType.OTHER || (p = (ParameterInfo)m.get(k2 = in.toString() + '.' + (in == RestParamType.BODY ? null : mp.getName()))) != null) continue;
            p = SwaggerBuilder.parameterInfoStrict(in.toString(), mp.getName());
            m.put(k2, p);
        }
        if (m.isEmpty()) {
            return null;
        }
        return new ArrayList<ParameterInfo>(m.values());
    }

    private Map<Integer, ResponseInfo> getResponses(RestRequest req) throws ParseException {
        HeaderInfo h;
        ResponseInfo r2;
        Operation o = this.getSwaggerOperationFromFile(req);
        if (o != null && o.getResponses() != null) {
            return o.getResponses();
        }
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        TreeMap<Integer, ResponseInfo> m = new TreeMap<Integer, ResponseInfo>();
        TreeMap<String, HeaderInfo> m2 = new TreeMap<String, HeaderInfo>();
        for (Response r : this.responses) {
            int httpCode = r.value();
            String description = r.description().isEmpty() ? RestUtils.getHttpResponseText(r.value()) : vr.resolve(r.description());
            r2 = SwaggerBuilder.responseInfo(description);
            if (r.headers().length > 0) {
                for (Parameter v : r.headers()) {
                    h = SwaggerBuilder.headerInfoStrict(vr.resolve(v.type()));
                    if (!v.collectionFormat().isEmpty()) {
                        h.collectionFormat(vr.resolve(v.collectionFormat()));
                    }
                    if (!v._default().isEmpty()) {
                        h._default(vr.resolve(v._default()));
                    }
                    if (!v.description().isEmpty()) {
                        h.description(vr.resolve(v.description()));
                    }
                    if (!v.format().isEmpty()) {
                        h.format(vr.resolve(v.format()));
                    }
                    if (!v.items().isEmpty()) {
                        h.items(jp.parse((Object)vr.resolve(v.items()), Items.class));
                    }
                    r2.header(v.name(), h);
                    m2.put(httpCode + 46 + v.name(), h);
                }
            }
            m.put(httpCode, r2);
        }
        String prefix = this.method.getName() + ".res";
        for (String key : this.context.getMessages().keySet(prefix)) {
            String name;
            if (key.length() <= prefix.length()) continue;
            String value = vr.resolve(this.context.getMessages().getString(key));
            String[] parts = key.substring(prefix.length() + 1).split("\\.");
            int httpCode = Integer.parseInt(parts[0]);
            r2 = (ResponseInfo)m.get(httpCode);
            if (r2 == null) {
                r2 = SwaggerBuilder.responseInfo(null);
                m.put(httpCode, r2);
            }
            String string = name = parts.length > 1 ? parts[1] : "";
            if ("header".equals(name) && parts.length > 3) {
                String headerName = parts[2];
                String field = parts[3];
                String k2 = httpCode + 46 + headerName;
                h = (HeaderInfo)m2.get(k2);
                if (h == null) {
                    h = SwaggerBuilder.headerInfoStrict("string");
                    m2.put(k2, h);
                    r2.header(name, h);
                }
                if (field.equals("collectionFormat")) {
                    h.collectionFormat(value);
                    continue;
                }
                if (field.equals("default")) {
                    h._default(value);
                    continue;
                }
                if (field.equals("description")) {
                    h.description(value);
                    continue;
                }
                if (field.equals("format")) {
                    h.format(value);
                    continue;
                }
                if (field.equals("items")) {
                    h.items(jp.parse((Object)value, Items.class));
                    continue;
                }
                if (!field.equals("type")) continue;
                h.type(value);
                continue;
            }
            if ("description".equals(name)) {
                r2.description(value);
                continue;
            }
            if ("schema".equals(name)) {
                r2.schema(jp.parse((Object)value, SchemaInfo.class));
                continue;
            }
            if ("examples".equals(name)) {
                r2.examples(jp.parse((Object)value, TreeMap.class));
                continue;
            }
            System.err.println("Unknown bundle key '" + key + "'");
        }
        return m.isEmpty() ? null : m;
    }

    boolean isRequestAllowed(RestRequest req) {
        for (RestGuard guard : this.guards) {
            req.setJavaMethod(this.method);
            if (guard.isRequestAllowed(req)) continue;
            return false;
        }
        return true;
    }

    int invoke(String pathInfo, RestRequest req, RestResponse res) throws RestException {
        String[] patternVals = this.pathPattern.match(pathInfo);
        if (patternVals == null) {
            return 404;
        }
        String remainder = null;
        if (patternVals.length > this.pathPattern.getVars().length) {
            remainder = patternVals[this.pathPattern.getVars().length];
        }
        for (int i = 0; i < this.pathPattern.getVars().length; ++i) {
            req.getPathMatch().put(this.pathPattern.getVars()[i], patternVals[i]);
        }
        req.getPathMatch().setRemainder(remainder);
        ObjectMap requestProperties = this.createRequestProperties(this.properties, req);
        req.init(this.method, requestProperties, this.defaultRequestHeaders, this.defaultQuery, this.defaultFormData, this.defaultCharset, this.serializers, this.parsers, this.urlEncodingParser, this.beanContext, this.encoders, this.widgets);
        res.init(requestProperties, this.defaultCharset, this.serializers, this.urlEncodingSerializer, this.encoders);
        for (RestGuard guard : this.context.getGuards()) {
            if (guard.guard(req, res)) continue;
            return 401;
        }
        for (RestMatcher m : this.requiredMatchers) {
            if (m.matches(req)) continue;
            return 412;
        }
        if (this.optionalMatchers.length > 0) {
            boolean matches = false;
            for (RestMatcher m : this.optionalMatchers) {
                matches |= m.matches(req);
            }
            if (!matches) {
                return 412;
            }
        }
        this.context.getCallHandler().onPreCall(req);
        Object[] args = new Object[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            try {
                args[i] = this.params[i].resolve(req, res);
                continue;
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestException(400, "Invalid data conversion.  Could not convert {0} ''{1}'' to type ''{2}'' on method ''{3}.{4}''.", this.params[i].getParamType().name(), this.params[i].getName(), this.params[i].getType(), this.method.getDeclaringClass().getName(), this.method.getName()).initCause(e);
            }
        }
        try {
            for (RestGuard guard : this.guards) {
                if (guard.guard(req, res)) continue;
                return 200;
            }
            Object output = this.method.invoke(this.context.getResource(), args);
            if (!(this.method.getReturnType().equals(Void.TYPE) || output == null && res.getOutputStreamCalled())) {
                res.setOutput(output);
            }
            this.context.getCallHandler().onPostCall(req, res);
            if (res.hasOutput()) {
                output = res.getOutput();
                for (RestConverter converter : this.converters) {
                    output = converter.convert(req, output, this.beanContext.getClassMetaForObject(output));
                }
                res.setOutput(output);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RestException(400, "Invalid argument type passed to the following method: ''{0}''.\n\tArgument types: {1}", this.method.toString(), ClassUtils.getReadableClassNames(args)).initCause(e);
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getTargetException();
            if (e2 instanceof RestException) {
                throw (RestException)e2;
            }
            if (e2 instanceof ParseException) {
                throw new RestException(400, e2);
            }
            if (e2 instanceof InvalidDataConversionException) {
                throw new RestException(400, e2);
            }
            throw new RestException(500, e2);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
        return 200;
    }

    ObjectMap createRequestProperties(ObjectMap methodProperties, final RestRequest req) {
        ObjectMap m = new ObjectMap(){

            @Override
            public Object get(Object key) {
                Object o = super.get(key);
                if (o == null) {
                    String remainder;
                    String prefix;
                    Object v;
                    String k = key.toString();
                    int i = k.indexOf(46);
                    if (i != -1 && (v = req.resolveProperty(CallMethod.this, prefix = k.substring(0, i), remainder = k.substring(i + 1))) != null) {
                        return v;
                    }
                    o = req.getPathMatch().get(k);
                    if (o == null) {
                        o = req.getHeader(k);
                    }
                }
                if (o instanceof String) {
                    o = req.getVarResolverSession().resolve(o.toString());
                }
                return o;
            }
        };
        m.setInner(methodProperties);
        return m;
    }

    public String toString() {
        return "SimpleMethod: name=" + this.httpMethod + ", path=" + this.pathPattern.getPatternString();
    }

    @Override
    public int compareTo(CallMethod o) {
        int c = this.priority.compareTo(o.priority);
        if (c != 0) {
            return c;
        }
        c = this.pathPattern.compareTo(o.pathPattern);
        if (c != 0) {
            return c;
        }
        c = Utils.compare(o.requiredMatchers.length, this.requiredMatchers.length);
        if (c != 0) {
            return c;
        }
        c = Utils.compare(o.optionalMatchers.length, this.optionalMatchers.length);
        if (c != 0) {
            return c;
        }
        c = Utils.compare(o.guards.length, this.guards.length);
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CallMethod)) {
            return false;
        }
        return this.compareTo((CallMethod)o) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static class Builder {
        private String httpMethod;
        private String defaultCharset;
        private String description;
        private String tags;
        private String summary;
        private String externalDocs;
        private String htmlNav;
        private String htmlAside;
        private String htmlFooter;
        private String htmlStyle;
        private String htmlStylesheet;
        private String htmlScript;
        private String htmlHeader;
        private String htmlNoResultsMessage;
        private String[] htmlLinks;
        private boolean htmlNoWrap;
        private HtmlDocTemplate htmlTemplate;
        private UrlPathPattern pathPattern;
        private RestParam[] params;
        private RestGuard[] guards;
        private RestMatcher[] optionalMatchers;
        private RestMatcher[] requiredMatchers;
        private RestConverter[] converters;
        private SerializerGroup serializers;
        private ParserGroup parsers;
        private EncoderGroup encoders;
        private UrlEncodingParser urlEncodingParser;
        private UrlEncodingSerializer urlEncodingSerializer;
        private BeanContext beanContext;
        private ObjectMap properties;
        private Map<String, String> defaultRequestHeaders;
        private Map<String, String> defaultQuery;
        private Map<String, String> defaultFormData;
        private boolean plainParams;
        private boolean deprecated;
        private Integer priority;
        private Parameter[] parameters;
        private Response[] responses;
        private Map<String, Widget> htmlWidgets;

        /*
         * WARNING - void declaration
         */
        private Builder(Object servlet, Method method, RestContext context) throws RestServletException {
            String sig = method.getDeclaringClass().getName() + '.' + method.getName();
            try {
                String[] h;
                int n;
                int i;
                MethodSwagger sm;
                RestMethod m = method.getAnnotation(RestMethod.class);
                if (m == null) {
                    throw new RestServletException("@RestMethod annotation not found on method ''{0}''", sig);
                }
                if (!m.description().isEmpty()) {
                    this.description = m.description();
                }
                if (!(sm = m.swagger()).tags().isEmpty()) {
                    this.tags = sm.tags();
                }
                if (!m.summary().isEmpty()) {
                    this.summary = m.summary();
                }
                if (!sm.externalDocs().isEmpty()) {
                    this.externalDocs = sm.externalDocs();
                }
                this.deprecated = sm.deprecated();
                this.parameters = sm.parameters();
                this.responses = sm.responses();
                this.serializers = context.getSerializers();
                this.parsers = context.getParsers();
                this.urlEncodingSerializer = context.getUrlEncodingSerializer();
                this.urlEncodingParser = context.getUrlEncodingParser();
                this.beanContext = context.getBeanContext();
                this.encoders = context.getEncoders();
                this.properties = context.getProperties();
                HtmlDoc hd = m.htmldoc();
                this.htmlWidgets = new HashMap<String, Widget>(context.getHtmlWidgets());
                for (Class<? extends Widget> wc : hd.widgets()) {
                    Widget w = ClassUtils.newInstance(Widget.class, wc, new Object[0]);
                    this.htmlWidgets.put(w.getName(), w);
                }
                this.htmlHeader = RestUtils.resolveNewlineSeparatedAnnotation(hd.header(), context.getHtmlHeader());
                this.htmlNav = RestUtils.resolveNewlineSeparatedAnnotation(hd.nav(), context.getHtmlNav());
                this.htmlAside = RestUtils.resolveNewlineSeparatedAnnotation(hd.aside(), context.getHtmlAside());
                this.htmlFooter = RestUtils.resolveNewlineSeparatedAnnotation(hd.footer(), context.getHtmlFooter());
                this.htmlStyle = RestUtils.resolveNewlineSeparatedAnnotation(hd.style(), context.getHtmlStyle());
                this.htmlScript = RestUtils.resolveNewlineSeparatedAnnotation(hd.script(), context.getHtmlScript());
                this.htmlLinks = RestUtils.resolveLinks(hd.links(), context.getHtmlLinks());
                this.htmlStylesheet = hd.stylesheet().isEmpty() ? context.getHtmlStylesheet() : hd.stylesheet();
                this.htmlNoWrap = hd.nowrap() ? hd.nowrap() : context.getHtmlNoWrap();
                this.htmlNoResultsMessage = hd.noResultsMessage().isEmpty() ? context.getHtmlNoResultsMessage() : hd.noResultsMessage();
                this.htmlTemplate = hd.template() == HtmlDocTemplate.class ? context.getHtmlTemplate() : ClassUtils.newInstance(HtmlDocTemplate.class, hd.template(), new Object[0]);
                List<Inherit> si = Arrays.asList(m.serializersInherit());
                List<Inherit> pi = Arrays.asList(m.parsersInherit());
                SerializerGroupBuilder sgb = null;
                ParserGroupBuilder pgb = null;
                UrlEncodingParserBuilder uepb = null;
                if (m.serializers().length > 0 || m.parsers().length > 0 || m.properties().length > 0 || m.flags().length > 0 || m.beanFilters().length > 0 || m.pojoSwaps().length > 0 || m.bpi().length > 0 || m.bpx().length > 0) {
                    sgb = new SerializerGroupBuilder();
                    pgb = new ParserGroupBuilder();
                    uepb = new UrlEncodingParserBuilder(this.urlEncodingParser.createPropertyStore());
                    if (si.contains((Object)Inherit.SERIALIZERS) || m.serializers().length == 0) {
                        sgb.append(this.serializers.getSerializers());
                    }
                    if (pi.contains((Object)Inherit.PARSERS) || m.parsers().length == 0) {
                        pgb.append(this.parsers.getParsers());
                    }
                }
                this.httpMethod = m.name().toUpperCase(Locale.ENGLISH);
                if (this.httpMethod.equals("") && method.getName().startsWith("do")) {
                    this.httpMethod = method.getName().substring(2).toUpperCase(Locale.ENGLISH);
                }
                if (this.httpMethod.equals("")) {
                    this.httpMethod = "GET";
                }
                if (this.httpMethod.equals("METHOD")) {
                    this.httpMethod = "*";
                }
                this.priority = m.priority();
                String p = m.path();
                this.converters = new RestConverter[m.converters().length];
                for (i = 0; i < this.converters.length; ++i) {
                    this.converters[i] = ClassUtils.newInstance(RestConverter.class, m.converters()[i], new Object[0]);
                }
                this.guards = new RestGuard[m.guards().length];
                for (i = 0; i < this.guards.length; ++i) {
                    this.guards[i] = ClassUtils.newInstance(RestGuard.class, m.guards()[i], new Object[0]);
                }
                LinkedList<void> optionalMatchers = new LinkedList<void>();
                LinkedList<Object> requiredMatchers = new LinkedList<Object>();
                for (int i2 = 0; i2 < m.matchers().length; ++i2) {
                    void var18_24;
                    Class<? extends RestMatcher> c = m.matchers()[i2];
                    Object var18_25 = null;
                    if (ClassUtils.isParentClass(RestMatcherReflecting.class, c)) {
                        RestMatcher restMatcher = ClassUtils.newInstance(RestMatcherReflecting.class, c, servlet, method);
                    } else {
                        RestMatcher restMatcher = ClassUtils.newInstance(RestMatcher.class, c, new Object[0]);
                    }
                    if (var18_24.mustMatch()) {
                        requiredMatchers.add(var18_24);
                        continue;
                    }
                    optionalMatchers.add(var18_24);
                }
                if (!m.clientVersion().isEmpty()) {
                    requiredMatchers.add(new ClientVersionMatcher(context.getClientVersionHeader(), method));
                }
                this.requiredMatchers = requiredMatchers.toArray(new RestMatcher[requiredMatchers.size()]);
                this.optionalMatchers = optionalMatchers.toArray(new RestMatcher[optionalMatchers.size()]);
                Class<?>[] beanFilters = context.getBeanFilters();
                Class<?>[] pojoSwaps = context.getPojoSwaps();
                if (sgb != null) {
                    String s;
                    sgb.append(m.serializers());
                    if (si.contains((Object)Inherit.TRANSFORMS)) {
                        sgb.beanFilters(beanFilters).pojoSwaps(pojoSwaps);
                    }
                    if (si.contains((Object)Inherit.PROPERTIES)) {
                        sgb.properties(this.properties);
                    }
                    for (Property property : m.properties()) {
                        sgb.property(property.name(), property.value());
                    }
                    String[] stringArray = m.flags();
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String string = stringArray[n];
                        sgb.property(string, true);
                    }
                    if (m.bpi().length > 0) {
                        void var21_65;
                        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                        String[] stringArray2 = m.bpi();
                        n = stringArray2.length;
                        boolean bl = false;
                        while (var21_65 < n) {
                            s = stringArray2[var21_65];
                            for (String s2 : StringUtils.split(s, ';')) {
                                int i3 = s2.indexOf(58);
                                if (i3 == -1) {
                                    throw new RestServletException("Invalid format for @RestMethod.bpi() on method ''{0}''.  Must be in the format \"ClassName: comma-delimited-tokens\".  \nValue: {1}", sig, s);
                                }
                                linkedHashMap.put(s2.substring(0, i3).trim(), s2.substring(i3 + 1).trim());
                            }
                            ++var21_65;
                        }
                        sgb.includeProperties(linkedHashMap);
                    }
                    if (m.bpx().length > 0) {
                        void var21_67;
                        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                        String[] stringArray3 = m.bpx();
                        n = stringArray3.length;
                        boolean bl = false;
                        while (var21_67 < n) {
                            s = stringArray3[var21_67];
                            for (String s2 : StringUtils.split(s, ';')) {
                                int i2 = s2.indexOf(58);
                                if (i2 == -1) {
                                    throw new RestServletException("Invalid format for @RestMethod.bpx() on method ''{0}''.  Must be in the format \"ClassName: comma-delimited-tokens\".  \nValue: {1}", sig, s);
                                }
                                linkedHashMap.put(s2.substring(0, i2).trim(), s2.substring(i2 + 1).trim());
                            }
                            ++var21_67;
                        }
                        sgb.excludeProperties(linkedHashMap);
                    }
                    sgb.beanFilters(m.beanFilters());
                    sgb.pojoSwaps(m.pojoSwaps());
                }
                if (pgb != null) {
                    pgb.append(m.parsers());
                    if (pi.contains((Object)Inherit.TRANSFORMS)) {
                        pgb.beanFilters(beanFilters).pojoSwaps(pojoSwaps);
                    }
                    if (pi.contains((Object)Inherit.PROPERTIES)) {
                        pgb.properties(this.properties);
                    }
                    for (Property property : m.properties()) {
                        pgb.property(property.name(), property.value());
                    }
                    String[] stringArray = m.flags();
                    int n3 = stringArray.length;
                    for (n = 0; n < n3; ++n) {
                        String string = stringArray[n];
                        pgb.property(string, true);
                    }
                    pgb.beanFilters(m.beanFilters());
                    pgb.pojoSwaps(m.pojoSwaps());
                }
                if (uepb != null) {
                    for (Property property : m.properties()) {
                        uepb.property(property.name(), property.value());
                    }
                    String[] stringArray = m.flags();
                    int n4 = stringArray.length;
                    for (n = 0; n < n4; ++n) {
                        String string = stringArray[n];
                        uepb.property(string, true);
                    }
                    uepb.beanFilters((Class[])m.beanFilters());
                    uepb.pojoSwaps((Class[])m.pojoSwaps());
                }
                if (m.properties().length > 0 || m.flags().length > 0) {
                    this.properties = new ObjectMap().setInner(this.properties);
                    for (Property property : m.properties()) {
                        this.properties.put(property.name(), property.value());
                    }
                    String[] stringArray = m.flags();
                    int n5 = stringArray.length;
                    for (n = 0; n < n5; ++n) {
                        String string = stringArray[n];
                        this.properties.put(string, true);
                    }
                }
                if (m.encoders().length > 0 || !m.inheritEncoders()) {
                    void var21_75;
                    EncoderGroupBuilder encoderGroupBuilder = new EncoderGroupBuilder();
                    if (m.inheritEncoders()) {
                        encoderGroupBuilder.append(this.encoders);
                    } else {
                        encoderGroupBuilder.append(IdentityEncoder.INSTANCE);
                    }
                    Class<? extends Encoder>[] classArray = m.encoders();
                    n = classArray.length;
                    boolean bl = false;
                    while (var21_75 < n) {
                        Class<? extends Encoder> c = classArray[var21_75];
                        try {
                            encoderGroupBuilder.append(c);
                        }
                        catch (Exception e) {
                            throw new RestServletException("Exception occurred while trying to instantiate Encoder on method ''{0}'': ''{1}''", sig, c.getSimpleName()).initCause(e);
                        }
                        ++var21_75;
                    }
                    this.encoders = encoderGroupBuilder.build();
                }
                this.defaultRequestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                for (String string : m.defaultRequestHeaders()) {
                    h = RestUtils.parseKeyValuePair(string);
                    if (h == null) {
                        throw new RestServletException("Invalid default request header specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", sig, string);
                    }
                    this.defaultRequestHeaders.put(h[0], h[1]);
                }
                this.defaultQuery = new LinkedHashMap<String, String>();
                for (String string : m.defaultQuery()) {
                    h = RestUtils.parseKeyValuePair(string);
                    if (h == null) {
                        throw new RestServletException("Invalid default query parameter specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", sig, string);
                    }
                    this.defaultQuery.put(h[0], h[1]);
                }
                this.defaultFormData = new LinkedHashMap<String, String>();
                for (String string : m.defaultFormData()) {
                    h = RestUtils.parseKeyValuePair(string);
                    if (h == null) {
                        throw new RestServletException("Invalid default form data parameter specified on method ''{0}'': ''{1}''.  Must be in the format: ''name[:=]value''", sig, string);
                    }
                    this.defaultFormData.put(h[0], h[1]);
                }
                Type[] typeArray = method.getGenericParameterTypes();
                Annotation[][] pa = method.getParameterAnnotations();
                for (int i4 = 0; i4 < typeArray.length; ++i4) {
                    for (Annotation a : pa[i4]) {
                        FormData f;
                        if (a instanceof Header) {
                            Header h2 = (Header)a;
                            if (h2.def().isEmpty()) continue;
                            this.defaultRequestHeaders.put(StringUtils.firstNonEmpty(h2.name(), h2.value()), h2.def());
                            continue;
                        }
                        if (a instanceof Query) {
                            Query q = (Query)a;
                            if (q.def().isEmpty()) continue;
                            this.defaultQuery.put(StringUtils.firstNonEmpty(q.name(), q.value()), q.def());
                            continue;
                        }
                        if (!(a instanceof FormData) || (f = (FormData)a).def().isEmpty()) continue;
                        this.defaultFormData.put(StringUtils.firstNonEmpty(f.name(), f.value()), f.def());
                    }
                }
                this.defaultCharset = this.properties.getString("RestServlet.defaultCharset", context.getDefaultCharset());
                String paramFormat = this.properties.getString("RestServlet.paramFormat", context.getParamFormat());
                this.plainParams = paramFormat.equals("PLAIN");
                this.pathPattern = new UrlPathPattern(p);
                this.params = context.findParams(method, this.plainParams, this.pathPattern);
                if (sgb != null) {
                    this.serializers = sgb.build();
                    this.beanContext = this.serializers.getBeanContext();
                }
                if (pgb != null) {
                    this.parsers = pgb.build();
                }
                if (uepb != null) {
                    this.urlEncodingParser = uepb.build();
                }
                method.setAccessible(true);
            }
            catch (RestServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestServletException("Exception occurred while initializing method ''{0}''", sig).initCause(e);
            }
        }
    }
}

