/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.CoreObject;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Setter;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.parser.ParserContext;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.transform.PojoSwap;

public abstract class Parser
extends CoreObject {
    private final MediaType[] mediaTypes;
    private final ParserContext ctx = this.createContext(ParserContext.class);

    Parser(PropertyStore propertyStore) {
        super(propertyStore);
        Consumes c = ReflectionUtils.getAnnotation(Consumes.class, this.getClass());
        if (c == null) {
            throw new FormattedRuntimeException("Class ''{0}'' is missing the @Consumes annotation", c);
        }
        String[] mt = StringUtils.split(c.value());
        this.mediaTypes = new MediaType[mt.length];
        for (int i = 0; i < mt.length; ++i) {
            this.mediaTypes[i] = MediaType.forString(mt[i]);
        }
    }

    @Override
    public ParserBuilder builder() {
        return new ParserBuilder(this.propertyStore);
    }

    protected abstract <T> T doParse(ParserSession var1, ClassMeta<T> var2) throws Exception;

    public abstract boolean isReaderParser();

    public final <T> T parseSession(ParserSession session, ClassMeta<T> type) throws ParseException {
        try {
            if (type.isVoid()) {
                T t = null;
                return t;
            }
            T t = this.doParse(session, type);
            return t;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new ParseException(session, "Depth too deep.  Stack overflow occurred.", new Object[0]);
        }
        catch (IOException e) {
            throw new ParseException(session, "I/O exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage()).initCause(e);
        }
        catch (Exception e) {
            throw new ParseException(session, "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage()).initCause(e);
        }
        finally {
            session.close();
        }
    }

    public final <T> T parse(Object input, Type type, Type ... args) throws ParseException {
        ParserSession session = this.createSession(input);
        return this.parseSession(session, session.getClassMeta(type, args));
    }

    public final <T> T parse(Object input, Class<T> type) throws ParseException {
        ParserSession session = this.createSession(input);
        return this.parseSession(session, session.getClassMeta(type));
    }

    public final <T> T parse(Object input, ClassMeta<T> type) throws ParseException {
        return this.parseSession(this.createSession(input), type);
    }

    public ParserSession createSession(Object input, ObjectMap op, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new ParserSession(this.ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
    }

    protected final ParserSession createSession(Object input) {
        return this.createSession(input, null, null, null, null, null, this.getPrimaryMediaType());
    }

    public final <K, V> Map<K, V> parseIntoMap(Object input, Map<K, V> m, Type keyType, Type valueType) throws ParseException {
        ParserSession session = this.createSession(input);
        try {
            Map<K, V> map = this.doParseIntoMap(session, m, keyType, valueType);
            return map;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(session, e);
        }
        finally {
            session.close();
        }
    }

    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        throw new UnsupportedOperationException("Parser '" + this.getClass().getName() + "' does not support this method.");
    }

    public final <E> Collection<E> parseIntoCollection(Object input, Collection<E> c, Type elementType) throws ParseException {
        ParserSession session = this.createSession(input);
        try {
            Collection<E> collection = this.doParseIntoCollection(session, c, elementType);
            return collection;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(session, e);
        }
        finally {
            session.close();
        }
    }

    protected <E> Collection<E> doParseIntoCollection(ParserSession session, Collection<E> c, Type elementType) throws Exception {
        throw new UnsupportedOperationException("Parser '" + this.getClass().getName() + "' does not support this method.");
    }

    public final Object[] parseArgs(Object input, Type[] argTypes) throws ParseException {
        if (argTypes == null || argTypes.length == 0) {
            return new Object[0];
        }
        ParserSession session = this.createSession(input);
        try {
            Object[] objectArray = this.doParse(session, session.getArgsClassMeta(argTypes));
            return objectArray;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(session, e);
        }
        finally {
            session.close();
        }
    }

    protected <T> T convertAttrToType(ParserSession session, Object outer, String s, ClassMeta<T> type) throws Exception {
        if (s == null) {
            return null;
        }
        if (type == null) {
            type = this.object();
        }
        PojoSwap<T, Object> transform = type.getPojoSwap();
        ClassMeta<?> sType = type.getSerializedClassMeta();
        Object o = s;
        if (sType.isChar()) {
            o = Character.valueOf(s.charAt(0));
        } else if (sType.isNumber()) {
            o = type.canCreateNewInstanceFromNumber(outer) ? type.newInstanceFromNumber(session, outer, StringUtils.parseNumber(s, type.getNewInstanceFromNumberClass())) : StringUtils.parseNumber(s, sType.getInnerClass());
        } else if (sType.isBoolean()) {
            o = Boolean.parseBoolean(s);
        } else if (!sType.isCharSequence() && !sType.isObject()) {
            if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, s);
            } else {
                throw new ParseException(session, "Invalid conversion from string to class ''{0}''", type);
            }
        }
        if (transform != null) {
            o = transform.unswap(session, o, type);
        }
        return (T)o;
    }

    protected void setParent(ClassMeta<?> cm, Object o, Object parent) throws Exception {
        Setter m = cm.getParentProperty();
        if (m != null) {
            m.set(o, parent);
        }
    }

    protected void setName(ClassMeta<?> cm, Object o, Object name) throws Exception {
        Setter m;
        if (cm != null && (m = cm.getNameProperty()) != null) {
            m.set(o, name);
        }
    }

    public MediaType[] getMediaTypes() {
        return this.mediaTypes;
    }

    public MediaType getPrimaryMediaType() {
        return this.mediaTypes == null || this.mediaTypes.length == 0 ? null : this.mediaTypes[0];
    }
}

