/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.microservice.Microservice;
import org.apache.juneau.microservice.resources.LogEntryFormatter;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.utils.ManifestFile;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class RestMicroservice
extends Microservice {
    Server server;
    int port;
    String contextPath;
    Logger logger;

    public static void main(String[] args) throws Exception {
        new RestMicroservice(args).start().join();
    }

    public RestMicroservice(String ... args) throws Exception {
        super(args);
    }

    @Override
    public RestMicroservice start() throws Exception {
        super.start();
        this.initLogging();
        this.createServer();
        this.startServer();
        return this;
    }

    @Override
    public RestMicroservice join() throws Exception {
        this.server.join();
        return this;
    }

    @Override
    public RestMicroservice stop() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    if (RestMicroservice.this.server.isStopping() || RestMicroservice.this.server.isStopped()) {
                        return;
                    }
                    RestMicroservice.this.onStopServer();
                    RestMicroservice.this.logger.warning("Stopping server.");
                    RestMicroservice.this.server.stop();
                    RestMicroservice.this.logger.warning("Server stopped.");
                    RestMicroservice.this.onPostStopServer();
                }
                catch (Exception e) {
                    RestMicroservice.this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.stop();
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public URI getURI() {
        String scheme = RestMicroservice.getConfig().getBoolean("REST/useSsl") ? "https" : "http";
        String hostname = "localhost";
        String ctx = "/".equals(this.contextPath) ? null : this.contextPath;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            return new URI(scheme, null, hostname, this.port, ctx, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initLogging() throws Exception {
        ObjectMap loggerLevels;
        ConfigFile cf = RestMicroservice.getConfig();
        this.logger = Logger.getLogger("");
        String logFile = cf.getString("Logging/logFile");
        if (!StringUtils.isEmpty(logFile)) {
            LogManager.getLogManager().reset();
            String logDir = cf.getString("Logging/logDir", ".");
            FileUtils.mkdirs(new File(logDir), false);
            boolean append = cf.getBoolean("Logging/append");
            int limit = cf.getInt("Logging/limit", 0x100000);
            int count = cf.getInt("Logging/count", 1);
            FileHandler fh = new FileHandler(logDir + '/' + logFile, limit, count, append);
            boolean useStackTraceHashes = cf.getBoolean("Logging/useStackTraceHashes");
            String format = cf.getString("Logging/format", "[{date} {level}] {msg}%n");
            String dateFormat = cf.getString("Logging/dateFormat", "yyyy.MM.dd hh:mm:ss");
            fh.setFormatter(new LogEntryFormatter(format, dateFormat, useStackTraceHashes));
            this.logger.addHandler(fh);
            ConsoleHandler ch = new ConsoleHandler();
            ch.setLevel(Level.parse(cf.getString("Logging/consoleLevel", "WARNING")));
            ch.setFormatter(new LogEntryFormatter(format, dateFormat, false));
            this.logger.addHandler(ch);
        }
        if ((loggerLevels = cf.getObject("Logging/levels", ObjectMap.class)) != null) {
            for (String l : loggerLevels.keySet()) {
                Logger.getLogger(l).setLevel(loggerLevels.get(Level.class, l));
            }
        }
    }

    protected Server createServer() throws Exception {
        this.onCreateServer();
        ConfigFile cf = RestMicroservice.getConfig();
        ManifestFile mf = RestMicroservice.getManifest();
        int[] ports = cf.getObjectWithDefault("REST/port", mf.get(int[].class, "Rest-Port", new int[]{8000}), int[].class);
        this.port = RestMicroservice.findOpenPort(ports);
        if (this.port == 0) {
            System.err.println("Open port not found.  Tried " + JsonSerializer.DEFAULT_LAX.toString(ports));
            System.exit(1);
        }
        this.contextPath = cf.getString("REST/contextPath", mf.getString("Rest-ContextPath", "/"));
        if (cf.getBoolean("REST/useSsl")) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            ObjectMap m = cf.writeProperties("REST-SslContextFactory", sslContextFactory, false, String.class, String[].class, Boolean.TYPE, Integer.TYPE);
            String[] excludeCipherSuites = ArrayUtils.combine(StringUtils.split("SSL_RSA_WITH_DES_CBC_SHA,SSL_DHE_RSA_WITH_DES_CBC_SHA,SSL_DHE_DSS_WITH_DES_CBC_SHA,SSL_RSA_EXPORT_WITH_RC4_40_MD5,SSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA,SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA256,TLS_DHE_DSS_WITH_AES_256_CBC_SHA256,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA256,TLS_DHE_DSS_WITH_AES_128_CBC_SHA256,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA"), sslContextFactory.getExcludeCipherSuites());
            sslContextFactory.setExcludeCipherSuites(excludeCipherSuites);
            this.logger.log(Level.WARNING, "SSL properties set: {0}", JsonSerializer.DEFAULT_LAX.toString(m));
            SslSocketConnector connector = new SslSocketConnector(sslContextFactory);
            connector.setPort(this.port);
            this.server = new Server();
            this.server.setConnectors(new Connector[]{connector});
        } else {
            this.server = new Server(this.port);
        }
        ServletContextHandler context = new ServletContextHandler(1);
        String authType = cf.getString("REST/authType", mf.getString("Rest-AuthType", "NONE"));
        if (authType.equals("BASIC")) {
            context.setSecurityHandler(RestMicroservice.basicAuth(cf, mf));
        }
        context.setContextPath(this.contextPath);
        this.server.setHandler((Handler)context);
        for (Map.Entry<String, Class<? extends Servlet>> e : this.getResourceMap().entrySet()) {
            context.addServlet(e.getValue(), e.getKey()).setInitOrder(0);
        }
        return this.server;
    }

    private static int findOpenPort(int[] ports) {
        for (int port : ports) {
            try {
                if (port == 0) {
                    port = new Random().nextInt(Short.MAX_VALUE - ports[0] + 1) + ports[0];
                }
                ServerSocket ss = new ServerSocket(port);
                ss.close();
                return port;
            }
            catch (IOException iOException) {
            }
        }
        return 0;
    }

    protected int startServer() throws Exception {
        this.onStartServer();
        this.server.start();
        this.logger.warning("Server started on port " + this.port);
        this.onPostStartServer();
        return this.port;
    }

    protected Map<String, Class<? extends Servlet>> getResourceMap() throws ClassNotFoundException, ParseException {
        LinkedHashMap<String, Class<? extends Servlet>> rm;
        block6: {
            String[] resources;
            block5: {
                ConfigFile cf = RestMicroservice.getConfig();
                ManifestFile mf = RestMicroservice.getManifest();
                rm = new LinkedHashMap<String, Class<? extends Servlet>>();
                ObjectMap resourceMap = cf.getObject("REST/resourceMap", ObjectMap.class);
                resources = cf.getStringArray("REST/resources", mf.getStringArray("Rest-Resources"));
                if (resourceMap == null || resourceMap.isEmpty()) break block5;
                for (Map.Entry<String, Object> e : resourceMap.entrySet()) {
                    Class<?> c = Class.forName(e.getValue().toString());
                    if (!ClassUtils.isParentClass(Servlet.class, c)) {
                        throw new ClassNotFoundException("Invalid class specified as resource.  Must be a Servlet.  Class='" + c.getName() + "'");
                    }
                    rm.put(e.getKey(), c);
                }
                break block6;
            }
            if (resources.length <= 0) break block6;
            for (String resource : resources) {
                String path;
                Class<?> c = Class.forName(resource);
                if (!ClassUtils.isParentClass(Servlet.class, c)) {
                    throw new ClassNotFoundException("Invalid class specified as resource.  Must be a Servlet.  Class='" + c.getName() + "'");
                }
                RestResource rr = c.getAnnotation(RestResource.class);
                String string = path = rr == null ? "/*" : rr.path();
                if (!path.endsWith("*")) {
                    path = path + (path.endsWith("/") ? "*" : "/*");
                }
                rm.put(path, c);
            }
        }
        return rm;
    }

    @Override
    protected void onConfigSave(ConfigFile cf) {
        try {
            String saveConfigAction = cf.getString("REST/saveConfigAction", "NOTHING");
            if (saveConfigAction.equals("RESTART_SERVER")) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            RestMicroservice.this.stop();
                            RestMicroservice.this.start();
                        }
                        catch (Exception e) {
                            RestMicroservice.this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                    }
                }.start();
            } else if (saveConfigAction.equals("RESTART_SERVICE")) {
                this.stop();
                System.exit(3);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void onCreateServer() {
    }

    protected void onStartServer() {
    }

    protected void onPostStartServer() {
    }

    protected void onStopServer() {
    }

    protected void onPostStopServer() {
    }

    @Override
    public RestMicroservice setConfig(String cfPath, boolean create) throws IOException {
        super.setConfig(cfPath, create);
        return this;
    }

    @Override
    public RestMicroservice setConfig(ConfigFile cf) {
        super.setConfig(cf);
        return this;
    }

    @Override
    public RestMicroservice setManifest(Manifest mf) {
        super.setManifest(mf);
        return this;
    }

    @Override
    public RestMicroservice setManifestContents(String ... contents) throws IOException {
        super.setManifestContents(contents);
        return this;
    }

    @Override
    public RestMicroservice setManifest(File f) throws IOException {
        super.setManifest(f);
        return this;
    }

    @Override
    public RestMicroservice setManifest(Class<?> c) throws IOException {
        super.setManifest(c);
        return this;
    }

    private static final SecurityHandler basicAuth(ConfigFile cf, ObjectMap mf) {
        HashLoginService l = new HashLoginService();
        String user = cf.getString("REST/loginUser", mf.getString("Rest-LoginUser"));
        String pw = cf.getString("REST/loginPassword", mf.getString("Rest-LoginPassword"));
        String realm = cf.getString("REST/authRealm", mf.getString("Rest-AuthRealm", ""));
        String ctx = cf.getString("REST/contextPath", mf.getString("Rest-ContextPath", "/"));
        l.putUser(user, Credential.getCredential((String)pw), new String[]{"user"});
        l.setName(realm);
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec(ctx);
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("myrealm");
        csh.addConstraintMapping(cm);
        csh.setLoginService((LoginService)l);
        return csh;
    }
}

