/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.json.JsonClassMeta;
import org.apache.juneau.json.JsonSchemaSerializer;
import org.apache.juneau.json.JsonSerializerBuilder;
import org.apache.juneau.json.JsonSerializerContext;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.json.JsonWriter;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.PojoSwap;

@Produces(value="application/json,text/json")
public class JsonSerializer
extends WriterSerializer {
    public static final JsonSerializer DEFAULT = new JsonSerializer(PropertyStore.create());
    public static final JsonSerializer DEFAULT_READABLE = new Readable(PropertyStore.create());
    public static final JsonSerializer DEFAULT_LAX = new Simple(PropertyStore.create());
    public static final JsonSerializer DEFAULT_LAX_READABLE = new SimpleReadable(PropertyStore.create());
    public static final JsonSerializer DEFAULT_LAX_READABLE_SAFE = new SimpleReadableSafe(PropertyStore.create());
    private final JsonSerializerContext ctx = this.createContext(JsonSerializerContext.class);
    private volatile JsonSchemaSerializer schemaSerializer;

    public JsonSerializer(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public JsonSerializerBuilder builder() {
        return new JsonSerializerBuilder(this.propertyStore);
    }

    SerializerWriter serializeAnything(JsonSerializerSession session, JsonWriter out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws Exception {
        String wrapperAttr;
        ClassMeta<Object> aType;
        boolean isRecursion;
        if (o == null) {
            out.append("null");
            return out;
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = session.push(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        ClassMeta<Object> sType = aType.getSerializedClassMeta();
        String typeName = session.getBeanTypeName(eType, aType, pMeta);
        PojoSwap<Object, ?> swap = aType.getPojoSwap();
        if (swap != null) {
            o = swap.swap(session, o);
            if (sType.isObject()) {
                sType = session.getClassMetaForObject(o);
            }
        }
        if ((wrapperAttr = sType.getExtendedMeta(JsonClassMeta.class).getWrapperAttr()) != null) {
            out.append('{').cr(session.indent).attr(wrapperAttr).append(':').s(session.indent);
            ++session.indent;
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.append("null");
        } else if (sType.isNumber() || sType.isBoolean()) {
            out.append(o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(session, out, session.toBeanMap(o), typeName);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.uriValue(o);
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(session, out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(session, out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(session, out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(session, out, JsonSerializer.toList(sType.getInnerClass(), o), eType);
        } else {
            out.stringValue(session.toString(o));
        }
        if (wrapperAttr != null) {
            --session.indent;
            out.cre(session.indent - 1).append('}');
        }
        if (!isRecursion) {
            session.pop();
        }
        return out;
    }

    private SerializerWriter serializeMap(JsonSerializerSession session, JsonWriter out, Map m, ClassMeta<?> type) throws Exception {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        m = session.sort(m);
        int i = session.getIndent();
        out.append('{');
        Iterator mapEntries = m.entrySet().iterator();
        while (mapEntries.hasNext()) {
            Map.Entry e = mapEntries.next();
            Object value = e.getValue();
            Object key = session.generalize(e.getKey(), keyType);
            out.cr(i).attr(session.toString(key)).append(':').s(i);
            this.serializeAnything(session, out, value, valueType, key == null ? null : session.toString(key), null);
            if (!mapEntries.hasNext()) continue;
            out.append(',').smi(i);
        }
        out.cre(i - 1).append('}');
        return out;
    }

    private SerializerWriter serializeBeanMap(JsonSerializerSession session, JsonWriter out, BeanMap<?> m, String typeName) throws Exception {
        int i = session.getIndent();
        out.append('{');
        boolean addComma = false;
        for (BeanPropertyValue p : m.getValues(session.isTrimNulls(), typeName != null ? session.createBeanTypeNameProperty(m, typeName) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.onBeanGetterException(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            if (addComma) {
                out.append(',').smi(i);
            }
            out.cr(i).attr(key).append(':').s(i);
            this.serializeAnything(session, out, value, cMeta, key, pMeta);
            addComma = true;
        }
        out.cre(i - 1).append('}');
        return out;
    }

    private SerializerWriter serializeCollection(JsonSerializerSession session, JsonWriter out, Collection c, ClassMeta<?> type) throws Exception {
        ClassMeta<?> elementType = type.getElementType();
        c = session.sort(c);
        out.append('[');
        int depth = session.getIndent();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            out.cr(depth);
            this.serializeAnything(session, out, value, elementType, "<iterator>", null);
            if (!i.hasNext()) continue;
            out.append(',').smi(depth);
        }
        out.cre(depth - 1).append(']');
        return out;
    }

    public JsonSchemaSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = new JsonSchemaSerializer(this.propertyStore, this.getOverrideProperties());
        }
        return this.schemaSerializer;
    }

    @Override
    public JsonSerializerSession createSession(Object output, ObjectMap op, Method javaMethod, Locale locale, TimeZone timeZone, MediaType mediaType, UriContext uriContext) {
        return new JsonSerializerSession(this.ctx, op, output, javaMethod, locale, timeZone, mediaType, uriContext);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        JsonSerializerSession s = (JsonSerializerSession)session;
        this.serializeAnything(s, s.getWriter(), o, s.getExpectedRootType(o), "root", null);
    }

    public static class SimpleReadableSafe
    extends JsonSerializer {
        public SimpleReadableSafe(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("JsonSerializer.simpleMode", true).append("Serializer.quoteChar", Character.valueOf('\'')).append("Serializer.useWhitespace", true).append("Serializer.detectRecursions", true);
        }
    }

    public static class SimpleReadable
    extends JsonSerializer {
        public SimpleReadable(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("JsonSerializer.simpleMode", true).append("Serializer.quoteChar", Character.valueOf('\'')).append("Serializer.useWhitespace", true);
        }
    }

    @Produces(value="application/json+simple,text/json+simple", contentType="application/json")
    public static class Simple
    extends JsonSerializer {
        public Simple(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("JsonSerializer.simpleMode", true).append("Serializer.quoteChar", Character.valueOf('\''));
        }
    }

    public static class Readable
    extends JsonSerializer {
        public Readable(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Serializer.useWhitespace", true);
        }
    }
}

