/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.List;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.jena.annotation.RdfNs;
import org.apache.juneau.jena.annotation.RdfSchema;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.NamespaceFactory;

public class RdfUtils {
    public static Namespace findNamespace(List<Rdf> rdfs, List<RdfSchema> schemas) {
        Namespace ns;
        for (Rdf rdf : rdfs) {
            ns = RdfUtils.findNamespace(rdf.prefix(), rdf.namespace(), rdfs, schemas);
            if (ns == null) continue;
            return ns;
        }
        for (RdfSchema schema : schemas) {
            ns = RdfUtils.findNamespace(schema.prefix(), schema.namespace(), null, schemas);
            if (ns == null) continue;
            return ns;
        }
        return null;
    }

    private static Namespace findNamespace(String prefix, String ns, List<Rdf> rdfs, List<RdfSchema> schemas) {
        if (!prefix.isEmpty() && !ns.isEmpty()) {
            return NamespaceFactory.get(prefix, ns);
        }
        if (!prefix.isEmpty()) {
            if (rdfs != null) {
                for (Rdf rdf2 : rdfs) {
                    if (!rdf2.prefix().equals(prefix) || rdf2.namespace().isEmpty()) continue;
                    return NamespaceFactory.get(prefix, rdf2.namespace());
                }
            }
            for (RdfSchema schema : schemas) {
                if (schema.prefix().equals(prefix) && !schema.namespace().isEmpty()) {
                    return NamespaceFactory.get(prefix, schema.namespace());
                }
                for (RdfNs rdfNs : schema.rdfNs()) {
                    if (!rdfNs.prefix().equals(prefix)) continue;
                    return NamespaceFactory.get(prefix, rdfNs.namespaceURI());
                }
            }
            throw new BeanRuntimeException("Found @Rdf.prefix annotation with no matching URI.  prefix='" + prefix + "'");
        }
        if (!ns.isEmpty()) {
            if (rdfs != null) {
                for (Rdf rdf2 : rdfs) {
                    if (!rdf2.namespace().equals(ns) || rdf2.prefix().isEmpty()) continue;
                    return NamespaceFactory.get(rdf2.prefix(), ns);
                }
            }
            for (RdfSchema schema : schemas) {
                if (schema.namespace().equals(ns) && !schema.prefix().isEmpty()) {
                    return NamespaceFactory.get(schema.prefix(), ns);
                }
                for (RdfNs rdfNs : schema.rdfNs()) {
                    if (!rdfNs.namespaceURI().equals(ns)) continue;
                    return NamespaceFactory.get(rdfNs.prefix(), ns);
                }
            }
        }
        return null;
    }
}

