/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommonContext;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.xml.Namespace;

public final class RdfSerializerContext
extends SerializerContext
implements RdfCommonContext {
    public static final String RDF_addLiteralTypes = "RdfSerializer.addLiteralTypes";
    public static final String RDF_addRootProperty = "RdfSerializer.addRootProperty";
    public static final String RDF_autoDetectNamespaces = "RdfSerializer.autoDetectNamespaces";
    public static final String RDF_namespaces = "RdfSerializer.namespaces.list";
    public static final String RDF_addBeanTypeProperties = "RdfSerializer.addBeanTypeProperties";
    final boolean addLiteralTypes;
    final boolean addRootProperty;
    final boolean useXmlNamespaces;
    final boolean looseCollections;
    final boolean autoDetectNamespaces;
    final boolean addBeanTypeProperties;
    final String rdfLanguage;
    final Namespace juneauNs;
    final Namespace juneauBpNs;
    final RdfCollectionFormat collectionFormat;
    final Map<String, Object> jenaSettings = new HashMap<String, Object>();
    final Namespace[] namespaces;

    public RdfSerializerContext(PropertyStore ps) {
        super(ps);
        this.addLiteralTypes = ps.getProperty(RDF_addLiteralTypes, Boolean.TYPE, false);
        this.addRootProperty = ps.getProperty(RDF_addRootProperty, Boolean.TYPE, false);
        this.useXmlNamespaces = ps.getProperty("Rdf.useXmlNamespaces", Boolean.TYPE, true);
        this.looseCollections = ps.getProperty("Rdf.looseCollections", Boolean.TYPE, false);
        this.autoDetectNamespaces = ps.getProperty(RDF_autoDetectNamespaces, Boolean.TYPE, true);
        this.rdfLanguage = ps.getProperty("Rdf.language", String.class, "RDF/XML-ABBREV");
        this.juneauNs = ps.getProperty("Rdf.juneauNs", Namespace.class, new Namespace("j", "http://www.apache.org/juneau/"));
        this.juneauBpNs = ps.getProperty("Rdf.juneauBpNs", Namespace.class, new Namespace("jp", "http://www.apache.org/juneaubp/"));
        this.collectionFormat = ps.getProperty("Rdf.collectionFormat", RdfCollectionFormat.class, RdfCollectionFormat.DEFAULT);
        this.namespaces = ps.getProperty(RDF_namespaces, Namespace[].class, new Namespace[0]);
        this.addBeanTypeProperties = ps.getProperty(RDF_addBeanTypeProperties, Boolean.TYPE, ps.getProperty("Serializer.addBeanTypeProperties", Boolean.TYPE, true));
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("RdfSerializerContext", new ObjectMap().append("addLiteralTypes", this.addLiteralTypes).append("addRootProperty", this.addRootProperty).append("useXmlNamespaces", this.useXmlNamespaces).append("looseCollections", this.looseCollections).append("autoDetectNamespaces", this.autoDetectNamespaces).append("rdfLanguage", this.rdfLanguage).append("juneauNs", this.juneauNs).append("juneauBpNs", this.juneauBpNs).append("collectionFormat", (Object)this.collectionFormat).append("namespaces", this.namespaces).append("addBeanTypeProperties", this.addBeanTypeProperties));
    }
}

