/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommonContext;
import org.apache.juneau.parser.ParserContext;
import org.apache.juneau.xml.Namespace;

public final class RdfParserContext
extends ParserContext
implements RdfCommonContext {
    public static final String RDF_trimWhitespace = "RdfParser.trimWhitespace";
    final boolean trimWhitespace;
    final boolean looseCollections;
    final String rdfLanguage;
    final Namespace juneauNs;
    final Namespace juneauBpNs;
    final RdfCollectionFormat collectionFormat;
    final Map<String, Object> jenaSettings = new HashMap<String, Object>();

    public RdfParserContext(PropertyStore ps) {
        super(ps);
        this.trimWhitespace = ps.getProperty(RDF_trimWhitespace, Boolean.TYPE, false);
        this.looseCollections = ps.getProperty("Rdf.looseCollections", Boolean.TYPE, false);
        this.rdfLanguage = ps.getProperty("Rdf.language", String.class, "RDF/XML-ABBREV");
        this.juneauNs = ps.getProperty("Rdf.juneauNs", Namespace.class, new Namespace("j", "http://www.apache.org/juneau/"));
        this.juneauBpNs = ps.getProperty("Rdf.juneauBpNs", Namespace.class, new Namespace("j", "http://www.apache.org/juneaubp/"));
        this.collectionFormat = ps.getProperty("Rdf.collectionFormat", RdfCollectionFormat.class, RdfCollectionFormat.DEFAULT);
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("RdfParserContext", new ObjectMap().append("trimWhitespace", this.trimWhitespace).append("looseCollections", this.looseCollections).append("rdfLanguage", this.rdfLanguage).append("juneauNs", this.juneauNs).append("juneauBpNs", this.juneauBpNs).append("collectionFormat", (Object)this.collectionFormat));
    }
}

