/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jena.RdfBeanMeta;
import org.apache.juneau.jena.RdfBeanPropertyMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfParserBuilder;
import org.apache.juneau.jena.RdfParserContext;
import org.apache.juneau.jena.RdfParserSession;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.transform.PojoSwap;

@Consumes(value="text/xml+rdf")
public class RdfParser
extends ReaderParser {
    public static final RdfParser DEFAULT_XML = new RdfParser(PropertyStore.create());
    public static final RdfParser DEFAULT_TURTLE = new Turtle(PropertyStore.create());
    public static final RdfParser DEFAULT_NTRIPLE = new NTriple(PropertyStore.create());
    public static final RdfParser DEFAULT_N3 = new N3(PropertyStore.create());
    private final RdfParserContext ctx = this.createContext(RdfParserContext.class);

    public RdfParser(PropertyStore propertyStore) {
        super(propertyStore);
    }

    @Override
    public RdfParserBuilder builder() {
        return new RdfParserBuilder(this.propertyStore);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        RdfParserSession s = (RdfParserSession)session;
        Model model = s.getModel();
        RDFReader r = s.getRdfReader();
        r.read(model, session.getReader(), null);
        List<Resource> roots = RdfParser.getRoots(s, model);
        if (s.isLooseCollections() && type.isCollectionOrArray()) {
            Collection c = null;
            c = type.isArray() || type.isArgs() ? new ArrayList() : (type.canCreateNewInstance(session.getOuter()) ? (Collection)type.newInstance(session.getOuter()) : new ObjectList(session));
            int argIndex = 0;
            for (Resource resource : roots) {
                c.add(this.parseAnything(s, type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), (RDFNode)resource, session.getOuter(), null));
            }
            if (type.isArray() || type.isArgs()) {
                return (T)session.toArray(type, c);
            }
            return (T)c;
        }
        if (roots.isEmpty()) {
            return null;
        }
        if (roots.size() > 1) {
            throw new ParseException(session, "Too many root nodes found in model:  {0}", roots.size());
        }
        Resource resource = roots.get(0);
        return this.parseAnything(s, type, (RDFNode)resource, session.getOuter(), null);
    }

    private static List<Resource> getRoots(RdfParserSession session, Model m) {
        LinkedList<Resource> l = new LinkedList<Resource>();
        Property root = m.createProperty(session.getJuneauNsUri(), "root");
        ResIterator i = m.listResourcesWithProperty(root);
        while (i.hasNext()) {
            l.add((Resource)i.next());
        }
        if (!l.isEmpty()) {
            return l;
        }
        HashSet<RDFNode> objects = new HashSet<RDFNode>();
        StmtIterator i2 = m.listStatements();
        while (i2.hasNext()) {
            Statement st = (Statement)i2.next();
            Resource subject = st.getSubject();
            RDFNode object = st.getObject();
            if (!object.isResource() || object.equals(subject)) continue;
            objects.add(object);
        }
        i2 = m.listSubjects();
        while (i2.hasNext()) {
            Resource r = (Resource)i2.next();
            if (objects.contains(r)) continue;
            l.add(r);
        }
        return l;
    }

    private <T> BeanMap<T> parseIntoBeanMap(RdfParserSession session, Resource r2, BeanMap<T> m) throws Exception {
        BeanMeta<T> bm = m.getMeta();
        RdfBeanMeta rbm = bm.getExtendedMeta(RdfBeanMeta.class);
        if (rbm.hasBeanUri() && r2.getURI() != null) {
            rbm.getBeanUriProperty().set(m, null, r2.getURI());
        }
        StmtIterator i = r2.listProperties();
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            Property p = st.getPredicate();
            String key = session.decodeString(p.getLocalName());
            BeanPropertyMeta pMeta = m.getPropertyMeta(key);
            session.setCurrentProperty(pMeta);
            if (pMeta != null) {
                RDFNode o = st.getObject();
                ClassMeta<?> cm = pMeta.getClassMeta();
                if (cm.isCollectionOrArray() && RdfParser.isMultiValuedCollections(session, pMeta)) {
                    ClassMeta<?> et = cm.getElementType();
                    Object value = this.parseAnything(session, et, o, m.getBean(false), pMeta);
                    this.setName(et, value, key);
                    pMeta.add(m, key, value);
                } else {
                    Object value = this.parseAnything(session, cm, o, m.getBean(false), pMeta);
                    this.setName(cm, value, key);
                    pMeta.set(m, key, value);
                }
            } else if (!p.equals(session.getRootProperty()) && !p.equals(session.getTypeProperty())) {
                session.onUnknownProperty(key, m, -1, -1);
            }
            session.setCurrentProperty(null);
        }
        return m;
    }

    private static boolean isMultiValuedCollections(RdfParserSession session, BeanPropertyMeta pMeta) {
        if (pMeta != null && pMeta.getExtendedMeta(RdfBeanPropertyMeta.class).getCollectionFormat() != RdfCollectionFormat.DEFAULT) {
            return pMeta.getExtendedMeta(RdfBeanPropertyMeta.class).getCollectionFormat() == RdfCollectionFormat.MULTI_VALUED;
        }
        return session.getCollectionFormat() == RdfCollectionFormat.MULTI_VALUED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(RdfParserSession session, ClassMeta<T> eType, RDFNode n, Object outer, BeanPropertyMeta pMeta) throws Exception {
        String c;
        ClassMeta<?> tcm;
        Statement st;
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<Object, Object> transform = eType.getPojoSwap();
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        session.setCurrentClass(sType);
        if (!sType.canCreateNewInstance(outer) && n.isResource() && (st = n.asResource().getProperty(session.getTypeProperty())) != null && (tcm = session.getClassMeta(c = st.getLiteral().getString(), pMeta, eType)) != null) {
            eType = tcm;
            sType = eType;
        }
        Collection o = null;
        if (!n.isResource() || n.asResource().getURI() == null || !n.asResource().getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) {
            Map<String, Object> m;
            Resource r;
            if (sType.isObject()) {
                if (n.isLiteral()) {
                    o = n.asLiteral().getValue();
                    if (o instanceof String) {
                        o = session.decodeString(o);
                    }
                } else {
                    if (!n.isResource()) throw new ParseException(session, "Unrecognized node type ''{0}'' for object", n);
                    r = n.asResource();
                    if (session.wasAlreadyProcessed(r)) {
                        o = r.getURI();
                    } else if (r.getProperty(session.getValueProperty()) != null) {
                        o = this.parseAnything(session, this.object(), n.asResource().getProperty(session.getValueProperty()).getObject(), outer, null);
                    } else if (RdfParser.isSeq(session, (RDFNode)r)) {
                        o = new ObjectList(session);
                        this.parseIntoCollection(session, (Container)r.as(Seq.class), o, sType, pMeta);
                    } else if (RdfParser.isBag(session, (RDFNode)r)) {
                        o = new ObjectList(session);
                        this.parseIntoCollection(session, (Container)r.as(Bag.class), o, sType, pMeta);
                    } else if (r.canAs(RDFList.class)) {
                        o = new ObjectList(session);
                        this.parseIntoCollection(session, (RDFList)r.as(RDFList.class), o, sType, pMeta);
                    } else {
                        String uri = r.getURI();
                        if (uri != null && !r.listProperties().hasNext()) {
                            o = r.getURI();
                        } else {
                            ObjectMap m2 = new ObjectMap(session);
                            this.parseIntoMap(session, r, m2, null, null, pMeta);
                            o = session.cast(m2, pMeta, eType);
                        }
                    }
                }
            } else if (sType.isBoolean()) {
                o = session.convertToType(this.getValue(session, n, outer), Boolean.TYPE);
            } else if (sType.isCharSequence()) {
                o = session.decodeString(this.getValue(session, n, outer));
            } else if (sType.isChar()) {
                o = Character.valueOf(session.decodeString(this.getValue(session, n, outer)).charAt(0));
            } else if (sType.isNumber()) {
                o = StringUtils.parseNumber(this.getValue(session, n, outer).toString(), sType.getInnerClass());
            } else if (sType.isMap()) {
                r = n.asResource();
                if (session.wasAlreadyProcessed(r)) {
                    return null;
                }
                m = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(session);
                o = this.parseIntoMap(session, r, m, eType.getKeyType(), eType.getValueType(), pMeta);
            } else if (sType.isCollectionOrArray() || sType.isArgs()) {
                o = sType.isArray() || sType.isArgs() ? new ArrayList() : (sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(session));
                r = n.asResource();
                if (session.wasAlreadyProcessed(r)) {
                    return null;
                }
                if (RdfParser.isSeq(session, (RDFNode)r)) {
                    this.parseIntoCollection(session, (Container)r.as(Seq.class), o, sType, pMeta);
                } else if (RdfParser.isBag(session, (RDFNode)r)) {
                    this.parseIntoCollection(session, (Container)r.as(Bag.class), o, sType, pMeta);
                } else {
                    if (!r.canAs(RDFList.class)) throw new ParseException("Unrecognized node type ''{0}'' for collection", n);
                    this.parseIntoCollection(session, (RDFList)r.as(RDFList.class), o, sType, pMeta);
                }
                if (sType.isArray() || sType.isArgs()) {
                    o = session.toArray(sType, o);
                }
            } else if (sType.canCreateNewBean(outer)) {
                r = n.asResource();
                if (session.wasAlreadyProcessed(r)) {
                    return null;
                }
                BeanMap<?> bm = session.newBeanMap(outer, sType.getInnerClass());
                o = this.parseIntoBeanMap(session, r, bm).getBean();
            } else if (sType.isUri() && n.isResource()) {
                o = sType.newInstanceFromString(outer, session.decodeString(n.asResource().getURI()));
            } else if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, session.decodeString(this.getValue(session, n, outer)));
            } else if (sType.canCreateNewInstanceFromNumber(outer)) {
                o = sType.newInstanceFromNumber(session, outer, StringUtils.parseNumber(this.getValue(session, n, outer).toString(), sType.getNewInstanceFromNumberClass()));
            } else {
                if (!n.isResource()) throw new ParseException("Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
                r = n.asResource();
                m = new ObjectMap(session);
                this.parseIntoMap(session, r, m, sType.getKeyType(), sType.getValueType(), pMeta);
                if (!m.containsKey(session.getBeanTypePropertyName(eType))) throw new ParseException(session, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
                o = session.cast((ObjectMap)m, pMeta, eType);
            }
        }
        if (transform != null && o != null) {
            o = transform.unswap(session, o, eType);
        }
        if (outer == null) return (T)o;
        this.setParent(eType, o, outer);
        return (T)o;
    }

    private static boolean isSeq(RdfParserSession session, RDFNode n) {
        Statement st;
        if (n.isResource() && (st = n.asResource().getProperty(session.getRdfTypeProperty())) != null) {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq".equals(st.getResource().getURI());
        }
        return false;
    }

    private static boolean isBag(RdfParserSession session, RDFNode n) {
        Statement st;
        if (n.isResource() && (st = n.asResource().getProperty(session.getRdfTypeProperty())) != null) {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag".equals(st.getResource().getURI());
        }
        return false;
    }

    private Object getValue(RdfParserSession session, RDFNode n, Object outer) throws Exception {
        Statement st;
        if (n.isLiteral()) {
            return n.asLiteral().getValue();
        }
        if (n.isResource() && (st = n.asResource().getProperty(session.getValueProperty())) != null) {
            n = st.getObject();
            if (n.isLiteral()) {
                return n.asLiteral().getValue();
            }
            return this.parseAnything(session, this.object(), st.getObject(), outer, null);
        }
        throw new ParseException(session, "Unknown value type for node ''{0}''", n);
    }

    private <K, V> Map<K, V> parseIntoMap(RdfParserSession session, Resource r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        if (r.getURI() != null) {
            K uri = this.convertAttrToType(session, m, "uri", keyType);
            V value = this.convertAttrToType(session, m, r.getURI(), valueType);
            m.put(uri, value);
        }
        StmtIterator i = r.listProperties();
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            Property p = st.getPredicate();
            String key = p.getLocalName();
            if (key.equals("root") && p.getURI().equals(session.getJuneauNsUri())) continue;
            key = session.decodeString(key);
            RDFNode o = st.getObject();
            K key2 = this.convertAttrToType(session, m, key, keyType);
            V value = this.parseAnything(session, valueType, o, m, pMeta);
            this.setName(valueType, value, key);
            m.put(key2, value);
        }
        return m;
    }

    private <E> Collection<E> parseIntoCollection(RdfParserSession session, Container c, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws Exception {
        int argIndex = 0;
        NodeIterator ni = c.iterator();
        while (ni.hasNext()) {
            Object e = this.parseAnything(session, type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), ni.next(), l, pMeta);
            l.add(e);
        }
        return l;
    }

    private <E> Collection<E> parseIntoCollection(RdfParserSession session, RDFList list, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws Exception {
        int argIndex = 0;
        ExtendedIterator ni = list.iterator();
        while (ni.hasNext()) {
            Object e = this.parseAnything(session, type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), (RDFNode)ni.next(), l, pMeta);
            l.add(e);
        }
        return l;
    }

    @Override
    public RdfParserSession createSession(Object input, ObjectMap op, Method javaMethod, Object outer, Locale locale, TimeZone timeZone, MediaType mediaType) {
        return new RdfParserSession(this.ctx, op, input, javaMethod, outer, locale, timeZone, mediaType);
    }

    @Consumes(value="text/n3")
    public static class N3
    extends RdfParser {
        public N3(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Rdf.language", "N3");
        }
    }

    @Consumes(value="text/turtle")
    public static class Turtle
    extends RdfParser {
        public Turtle(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Rdf.language", "TURTLE");
        }
    }

    @Consumes(value="text/n-triple")
    public static class NTriple
    extends RdfParser {
        public NTriple(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Rdf.language", "N-TRIPLE");
        }
    }

    @Consumes(value="text/xml+rdf")
    public static class Xml
    extends RdfParser {
        public Xml(PropertyStore propertyStore) {
            super(propertyStore);
        }

        @Override
        protected ObjectMap getOverrideProperties() {
            return super.getOverrideProperties().append("Rdf.language", "RDF/XML");
        }
    }
}

