/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.ini;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanSession;
import org.apache.juneau.Writable;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.ini.ConfigFileFormat;
import org.apache.juneau.ini.ConfigFileImpl;
import org.apache.juneau.ini.ConfigFileListener;
import org.apache.juneau.ini.Section;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.svl.vars.ConfigFileVar;

public final class ConfigFileWrapped
extends ConfigFile {
    private final ConfigFileImpl cf;
    private final VarResolverSession vs;

    ConfigFileWrapped(ConfigFileImpl cf, VarResolver vr) {
        this.cf = cf;
        this.vs = vr.builder().vars(ConfigFileVar.class).contextObject("config", cf).build().createSession();
    }

    ConfigFileWrapped(ConfigFileImpl cf, VarResolverSession vs) {
        this.cf = cf;
        this.vs = vs;
    }

    @Override
    public void clear() {
        this.cf.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cf.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cf.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Section>> entrySet() {
        return this.cf.entrySet();
    }

    @Override
    public Section get(Object key) {
        return this.cf.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.cf.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.cf.keySet();
    }

    @Override
    public Section put(String key, Section value) {
        return this.cf.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Section> map) {
        this.cf.putAll(map);
    }

    @Override
    public Section remove(Object key) {
        return this.cf.remove(key);
    }

    @Override
    public int size() {
        return this.cf.size();
    }

    @Override
    public Collection<Section> values() {
        return this.cf.values();
    }

    @Override
    public ConfigFile loadIfModified() throws IOException {
        this.cf.loadIfModified();
        return this;
    }

    @Override
    public ConfigFile load() throws IOException {
        this.cf.load();
        return this;
    }

    @Override
    public ConfigFile load(Reader r) throws IOException {
        this.cf.load(r);
        return this;
    }

    @Override
    public boolean isEncoded(String key) {
        return this.cf.isEncoded(key);
    }

    @Override
    public ConfigFile addLines(String section, String ... lines) {
        this.cf.addLines(section, lines);
        return this;
    }

    @Override
    public ConfigFile addHeaderComments(String section, String ... headerComments) {
        this.cf.addHeaderComments(section, headerComments);
        return this;
    }

    @Override
    public ConfigFile clearHeaderComments(String section) {
        this.cf.clearHeaderComments(section);
        return this;
    }

    @Override
    public Section getSection(String name) {
        return this.cf.getSection(name);
    }

    @Override
    public Section getSection(String name, boolean create) {
        return this.cf.getSection(name, create);
    }

    @Override
    public ConfigFile addSection(String name) {
        this.cf.addSection(name);
        return this;
    }

    @Override
    public ConfigFile setSection(String name, Map<String, String> contents) {
        this.cf.setSection(name, contents);
        return this;
    }

    @Override
    public ConfigFile removeSection(String name) {
        this.cf.removeSection(name);
        return this;
    }

    @Override
    public ConfigFile save() throws IOException {
        this.cf.save();
        return this;
    }

    @Override
    public ConfigFile serializeTo(Writer out, ConfigFileFormat format) throws IOException {
        this.cf.serializeTo(out, format);
        return this;
    }

    @Override
    public String toString() {
        return this.cf.toString();
    }

    @Override
    public ConfigFile getResolving(VarResolver varResolver) {
        ThrowableUtils.assertFieldNotNull(varResolver, "vr");
        return new ConfigFileWrapped(this.cf, varResolver);
    }

    @Override
    public ConfigFile getResolving(VarResolverSession varSession) {
        ThrowableUtils.assertFieldNotNull(varSession, "vs");
        return new ConfigFileWrapped(this.cf, varSession);
    }

    @Override
    public ConfigFile getResolving() {
        return new ConfigFileWrapped(this.cf, VarResolver.DEFAULT);
    }

    @Override
    public ConfigFile addListener(ConfigFileListener listener) {
        this.cf.addListener(listener);
        return this;
    }

    @Override
    public Writable toWritable() {
        return this.cf.toWritable();
    }

    @Override
    public ConfigFile merge(ConfigFile newCf) {
        this.cf.merge(newCf);
        return this;
    }

    @Override
    protected BeanSession getBeanSession() {
        return this.cf.getBeanSession();
    }

    @Override
    public String get(String sectionName, String sectionKey) {
        String s = this.cf.get(sectionName, sectionKey);
        if (s == null) {
            return null;
        }
        return this.vs.resolve(s);
    }

    @Override
    public String put(String sectionName, String sectionKey, String value, boolean encoded) {
        return this.cf.put(sectionName, sectionKey, value, encoded);
    }

    @Override
    public String put(String sectionName, String sectionKey, Object value, Serializer serializer, boolean encoded, boolean newline) throws SerializeException {
        return this.cf.put(sectionName, sectionKey, value, serializer, encoded, newline);
    }

    @Override
    public String remove(String sectionName, String sectionKey) {
        return this.cf.remove(sectionName, sectionKey);
    }

    @Override
    public Set<String> getSectionKeys(String sectionName) {
        return this.cf.getSectionKeys(sectionName);
    }

    @Override
    protected void readLock() {
        this.cf.readLock();
    }

    @Override
    protected void readUnlock() {
        this.cf.readUnlock();
    }

    @Override
    protected String serialize(Object o, Serializer s, boolean newline) throws SerializeException {
        return this.cf.serialize(o, s, newline);
    }

    @Override
    protected <T> T parse(String s, Parser parser, Type type, Type ... args) throws ParseException {
        return this.cf.parse(s, parser, type, args);
    }
}

