/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public class MediaType
implements Comparable<MediaType> {
    private static final boolean nocache = Boolean.getBoolean("juneau.nocache");
    private static final ConcurrentHashMap<String, MediaType> cache = new ConcurrentHashMap();
    public static final MediaType CSV = MediaType.forString("text/csv");
    public static final MediaType HTML = MediaType.forString("text/html");
    public static final MediaType JSON = MediaType.forString("application/json");
    public static final MediaType MSGPACK = MediaType.forString("octal/msgpack");
    public static final MediaType PLAIN = MediaType.forString("text/plain");
    public static final MediaType UON = MediaType.forString("text/uon");
    public static final MediaType URLENCODING = MediaType.forString("application/x-www-form-urlencoded");
    public static final MediaType XML = MediaType.forString("text/xml");
    public static final MediaType XMLSOAP = MediaType.forString("text/xml+soap");
    public static final MediaType RDF = MediaType.forString("text/xml+rdf");
    public static final MediaType RDFABBREV = MediaType.forString("text/xml+rdf+abbrev");
    public static final MediaType NTRIPLE = MediaType.forString("text/n-triple");
    public static final MediaType TURTLE = MediaType.forString("text/turtle");
    public static final MediaType N3 = MediaType.forString("text/n3");
    private final String mediaType;
    private final String type;
    private final String subType;
    private final String[] subTypes;
    private final List<String> subTypesList;
    private final Map<String, Set<String>> parameters;

    public static MediaType forString(String s) {
        if (s == null) {
            return null;
        }
        MediaType mt = cache.get(s);
        if (mt == null) {
            mt = new MediaType(s);
            if (nocache) {
                return mt;
            }
            cache.putIfAbsent(s, mt);
        }
        return cache.get(s);
    }

    MediaType(String mt) {
        Builder b = new Builder(mt);
        this.mediaType = b.mediaType;
        this.type = b.type;
        this.subType = b.subType;
        this.subTypes = b.subTypes;
        this.subTypesList = Collections.unmodifiableList(Arrays.asList(this.subTypes));
        this.parameters = b.parameters == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(b.parameters);
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public List<String> getSubTypes() {
        return this.subTypesList;
    }

    public final boolean matches(MediaType o) {
        return this.match(o) > 0;
    }

    public final int match(MediaType o) {
        if (this == o || this.type.equals(o.type) && this.subType.equals(o.subType)) {
            return Integer.MAX_VALUE;
        }
        int c1 = 0;
        int c2 = 0;
        if (this.type.equals(o.type)) {
            c1 += 10000;
        } else if ("*".equals(this.type) || "*".equals(o.type)) {
            c1 += 5000;
        }
        if (c1 == 0) {
            return 0;
        }
        if (this.subType.equals(o.subType)) {
            return c1 + 9999;
        }
        int c3 = 0;
        for (String st1 : this.subTypes) {
            if ("*".equals(st1)) {
                ++c1;
                continue;
            }
            if (ArrayUtils.contains(st1, o.subTypes)) {
                c1 += 100;
                continue;
            }
            if (ArrayUtils.contains("*", o.subTypes)) {
                c1 += 10;
                continue;
            }
            return 0;
        }
        return c1 + c2 + c3;
    }

    public Map<String, Set<String>> getParameters() {
        return this.parameters;
    }

    public String toString() {
        if (this.parameters.isEmpty()) {
            return this.mediaType;
        }
        StringBuilder sb = new StringBuilder(this.mediaType);
        for (Map.Entry<String, Set<String>> e : this.parameters.entrySet()) {
            for (String value : e.getValue()) {
                sb.append(';').append(e.getKey()).append('=').append(value);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int compareTo(MediaType o) {
        return this.mediaType.compareTo(o.mediaType);
    }

    private static class Builder {
        private String mediaType;
        private String type;
        private String subType;
        private String[] subTypes;
        private Map<String, Set<String>> parameters;

        private Builder(String mt) {
            mt = mt.trim();
            int i = mt.indexOf(59);
            if (i == -1) {
                this.parameters = Collections.EMPTY_MAP;
            } else {
                this.parameters = new TreeMap<String, Set<String>>();
                String[] tokens = mt.substring(i + 1).split(";");
                for (int j = 0; j < tokens.length; ++j) {
                    String[] parm = tokens[j].split("=");
                    if (parm.length != 2) continue;
                    String k = parm[0].trim();
                    String v = parm[1].trim();
                    if (!this.parameters.containsKey(k)) {
                        this.parameters.put(k, new TreeSet());
                    }
                    this.parameters.get(k).add(v);
                }
                mt = mt.substring(0, i);
            }
            this.mediaType = mt;
            if (mt != null) {
                i = (mt = mt.replace(' ', '+')).indexOf(47);
                this.type = i == -1 ? mt : mt.substring(0, i);
                this.subType = i == -1 ? "*" : mt.substring(i + 1);
            }
            this.subTypes = StringUtils.split(this.subType, '+');
        }
    }
}

