/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.html.HtmlDocSerializer;
import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ObjectUtils;

public class HtmlDocTemplateBasic
implements HtmlDocTemplate {
    @Override
    public void head(HtmlDocSerializerSession session, HtmlWriter w, HtmlDocSerializer s, Object o) throws Exception {
        if (this.hasStyle(session)) {
            w.sTag(2, "style").nl(2);
            this.style(session, w, s, o);
            w.ie(2).eTag("style").nl(2);
        }
        if (this.hasScript(session)) {
            w.sTag(2, "script").nl(2);
            this.script(session, w, s, o);
            w.ie(2).eTag("script").nl(2);
        }
    }

    @Override
    public void style(HtmlDocSerializerSession session, HtmlWriter w, HtmlDocSerializer s, Object o) throws Exception {
        String[] stylesheet = session.getStylesheet();
        if (!ArrayUtils.contains("NONE", stylesheet)) {
            for (String ss : stylesheet) {
                w.append(3, "@import ").q().append(session.resolveUri(ss)).q().appendln("; ");
            }
        }
        if (session.isNoWrap()) {
            w.appendln(3, "div.data * {white-space:nowrap;} ");
        }
        if (session.getStyle() != null) {
            for (String style : session.getStyle()) {
                w.append(3, style).appendln(" ");
            }
        }
    }

    @Override
    public void script(HtmlDocSerializerSession session, HtmlWriter w, HtmlDocSerializer s, Object o) throws Exception {
        if (session.getScript() != null) {
            for (String script : session.getScript()) {
                w.append(3, script);
            }
        }
    }

    @Override
    public void body(HtmlDocSerializerSession session, HtmlWriter w, HtmlDocSerializer s, Object o) throws Exception {
        if (this.hasHeader(session)) {
            w.sTag(2, "header").nl(2);
            this.header(session, w, s, o);
            w.ie(2).eTag("header").nl(2);
        }
        if (this.hasNav(session)) {
            w.sTag(2, "nav").nl(2);
            this.nav(session, w, s, o);
            w.ie(2).eTag("nav").nl(2);
        }
        w.sTag(2, "section").nl(2);
        w.sTag(3, "article").nl(3);
        this.article(session, w, s, o);
        w.ie(3).eTag("article").nl(3);
        if (this.hasAside(session)) {
            w.sTag(3, "aside").nl(3);
            this.aside(session, w, s, o);
            w.ie(3).eTag("aside").nl(3);
        }
        w.ie(2).eTag("section").nl(2);
        if (this.hasFooter(session)) {
            w.sTag(2, "footer").nl(2);
            this.footer(session, w, s, o);
            w.ie(2).eTag("footer").nl(2);
        }
    }

    @Override
    public void header(HtmlDocSerializerSession session, HtmlWriter w, HtmlDocSerializer s, Object o) throws Exception {
        String header = session.getHeader();
        if (HtmlDocTemplateBasic.exists(header)) {
            w.append(3, header).nl(3);
        }
    }

    @Override
    public void nav(HtmlDocSerializerSession session, HtmlWriter w, HtmlDocSerializer s, Object o) throws Exception {
        String nav = session.getNav();
        if (nav != null) {
            if (HtmlDocTemplateBasic.exists(nav)) {
                w.append(3, nav).nl(3);
            }
        } else {
            String[] links = session.getLinks();
            if (links.length > 0) {
                w.sTag(3, "ol").nl(3);
                for (String l : links) {
                    w.sTag(4, "li");
                    if (l.matches("(?s)\\S+\\:.*")) {
                        int i = l.indexOf(58);
                        String key = l.substring(0, i);
                        String val = l.substring(i + 1).trim();
                        if (val.startsWith("<")) {
                            w.nl(4).appendln(5, val);
                        } else {
                            w.oTag("a").attr("href", (Object)session.resolveUri(val), true).cTag().text(key, true).eTag("a");
                        }
                        w.eTag("li").nl(4);
                        continue;
                    }
                    w.nl(4).appendln(5, l);
                    w.eTag(4, "li").nl(4);
                }
                w.eTag(3, "ol").nl(3);
            }
        }
    }

    @Override
    public void aside(HtmlDocSerializerSession session, HtmlWriter w, HtmlDocSerializer s, Object o) throws Exception {
        String aside = session.getAside();
        if (HtmlDocTemplateBasic.exists(aside)) {
            w.append(4, aside);
        }
    }

    @Override
    public void article(HtmlDocSerializerSession session, HtmlWriter w, HtmlDocSerializer s, Object o) throws Exception {
        w.oTag(4, "div").attr("class", "outerdata").append('>').nl(4);
        w.oTag(5, "div").attr("class", "data").attr("id", "data").append('>').nl(5);
        if (o == null) {
            w.append(6, "<null/>").nl(6);
        } else if (ObjectUtils.isEmpty(o)) {
            String m = session.getNoResultsMessage();
            if (HtmlDocTemplateBasic.exists(m)) {
                w.append(6, m).nl(6);
            }
        } else {
            session.indent = 6;
            s.parentSerialize(session, o);
        }
        w.ie(5).eTag("div").nl(5);
        w.ie(4).eTag("div").nl(4);
    }

    @Override
    public void footer(HtmlDocSerializerSession session, HtmlWriter w, HtmlDocSerializer s, Object o) throws Exception {
        String footer = session.getFooter();
        if (HtmlDocTemplateBasic.exists(footer)) {
            w.append(3, footer).nl(3);
        }
    }

    @Override
    public boolean hasStyle(HtmlDocSerializerSession session) {
        return true;
    }

    @Override
    public boolean hasScript(HtmlDocSerializerSession session) {
        return true;
    }

    @Override
    public boolean hasHeader(HtmlDocSerializerSession session) {
        return HtmlDocTemplateBasic.exists(session.getHeader());
    }

    @Override
    public boolean hasNav(HtmlDocSerializerSession session) {
        return HtmlDocTemplateBasic.exists(session.getNav()) || session.getLinks().length > 0;
    }

    @Override
    public boolean hasAside(HtmlDocSerializerSession session) {
        return HtmlDocTemplateBasic.exists(session.getAside());
    }

    @Override
    public boolean hasFooter(HtmlDocSerializerSession session) {
        return HtmlDocTemplateBasic.exists(session.getFooter());
    }

    private static boolean exists(String s) {
        return s != null && !"NONE".equals(s);
    }
}

